<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
  <div class="row page-titles">
    <div class="col-md-5 align-self-center">
      <h3 class="text-themecolor"><?php echo e(trans('lang.coupon_plural')); ?></h3>
    </div>

    <div class="col-md-7 align-self-center">
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
        <?php if (isset($_GET['eid']) && $_GET['eid'] != '') { ?>
          <li class="breadcrumb-item"><a href="<?php echo e(route('restaurants.coupons',$_GET['eid'])); ?>"><?php echo e(trans('lang.coupon_plural')); ?></a></li>
        <?php } else { ?>
          <li class="breadcrumb-item"><a href="<?php echo route('coupons'); ?>"><?php echo e(trans('lang.coupon_plural')); ?></a></li>
        <?php } ?>
        <li class="breadcrumb-item active"><?php echo e(trans('lang.coupon_edit')); ?></li>
      </ol>
    </div>

  </div>
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">
        <div class="card pb-4">
          <div class="card-body">

            <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;"><?php echo e(trans('lang.processing')); ?></div>

            <div class="error_top" style="display:none"></div>
            <?php if($errors->any()): ?>
            <div class="alert alert-danger">
              <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
            </div>
            <?php endif; ?>
            <form method="post" action="<?php echo e(route('coupons.update',$discount->id)); ?>" enctype="multipart/form-data">
              <?php echo csrf_field(); ?>
              <?php echo method_field("PUT"); ?>
              <div class="row restaurant_payout_create">

                <div class="restaurant_payout_create-inner">

                  <!-- <div class="col-md-6"> -->
                  <fieldset>
                    <legend><?php echo e(trans('lang.coupon_edit')); ?></legend>

                    <div class="form-group row width-50">
                      <label class="col-3 control-label"><?php echo e(trans('lang.coupon_code')); ?></label>
                      <div class="col-7">
                        <input type="text" type="text" class="form-control coupon_code" name="code" value="<?php echo e($discount->code); ?>">
                        <div class="form-text text-muted"><?php echo e(trans("lang.coupon_code_help")); ?> </div>
                      </div>
                    </div>

                    <div class="form-group row width-50">
                      <label class="col-3 control-label"><?php echo e(trans('lang.coupon_discount_type')); ?></label>
                      <div class="col-7">
                        <select id="coupon_discount_type" class="form-control" name="type">
                          <option value="Percentage" <?php echo e($discount->type == 'Percentage' ? 'selected' : ''); ?>><?php echo e(trans('lang.coupon_percent')); ?></option>
                          <option value="Fix Price" <?php echo e($discount->type == 'Fix Price' ? 'selected' : ''); ?>><?php echo e(trans('lang.coupon_fixed')); ?></option>
                        </select>
                        <div class="form-text text-muted"><?php echo e(trans("lang.coupon_discount_type_help")); ?></div>

                      </div>
                    </div>

                    <div class="form-group row width-50" id="discount" style="<?php echo e($discount->apply_for == 'normal' ? '' : 'display:none;'); ?>">
                      <label class="col-3 control-label"><?php echo e(trans('lang.coupon_discount')); ?></label>
                      <div class="col-7">

                        <input type="number" type="text" class="form-control coupon_discount" name="discount" value="<?php echo e($discount->discount); ?>">
                        <div class="form-text text-muted"><?php echo e(trans("lang.coupon_discount_help")); ?></div>

                      </div>
                    </div>

                    <div class="form-group row width-100" id="discount_slab" style="<?php echo e($discount->apply_for == 'completed' ? '' : 'display:none;'); ?>">

                      <label class="col-3 control-label">Discount Slabs</label>
                      <div class="col-7">

                        <table class="table table-bordered" id="slab_table">
                          <thead>
                            <tr>
                              <th>Minimum Ride Amount</th>
                              <th>Discount</th>
                              <th></th>
                            </tr>
                          </thead>
                          <tbody>
                            <?php $__currentLoopData = $slabs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $slab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                              <td>
                                <input type="number" name="slabs[<?php echo e($i); ?>][min]" class="form-control"
                                  value="<?php echo e($slab->min_ride_amount); ?>" required>
                              </td>
                              <td>
                                <input type="number" name="slabs[<?php echo e($i); ?>][discount]" class="form-control"
                                  value="<?php echo e($slab->discount_amount); ?>" required>
                              </td>
                              <!-- <td>
                                <select name="slabs[<?php echo e($i); ?>][discount_type]" class="form-control">
                                  <option value="flat" <?php echo e($slab->discount_type=='flat'?'selected':''); ?>>Flat</option>
                                  <option value="percent" <?php echo e($slab->discount_type=='percent'?'selected':''); ?>>Percent</option>
                                </select>
                              </td> -->
                              <td>
                                <button type="button" class="btn btn-sm btn-danger remove_slab">X</button>
                              </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </tbody>
                        </table>

                        <button type="button" class="btn btn-sm btn-secondary" id="add_slab">+ Add slab</button>
                      </div>
                    </div>


                    <div class="form-group row width-50">
                      <label class="col-3 control-label"><?php echo e(trans('lang.coupon_expires_at')); ?></label>
                      <div class="col-7">
                        <!-- <div class="form-group"> -->
                        <div class='input-group date' id='datetimepicker1'>

                          <input type='date' class="form-control date_picker input-group-addon" name="expire_at" min="<?php echo e(now()->format('Y-m-d')); ?>" value="<?php echo e(date('Y-m-d', strtotime($discount->expire_at))); ?>" />
                          <span class="">
                            <!-- <span class="glyphicon glyphicon-calendar fa fa-calendar"></span> -->
                          </span>
                        </div>
                        <div class="form-text text-muted">
                          <?php echo e(trans("lang.coupon_expires_at_help")); ?>

                        </div>
                        <!-- </div> -->
                      </div>
                    </div>
                    <div class="form-group row width-50">
                      <label class="col-3 control-label"><?php echo e(trans('lang.coupon_type')); ?></label>
                      <div class="col-7">
                        <select id="coupon_type" class="form-control" name="coupon_type">
                          <option value="Ride" <?php echo e($discount->coupon_type == 'Ride' ? 'selected' : ''); ?>><?php echo e(trans('lang.ride')); ?></option>
                          <option value="Parcel" <?php echo e($discount->coupon_type == 'Parcel' ? 'selected' : ''); ?>><?php echo e(trans('lang.parcel')); ?></option>

                        </select>
                        <div class="form-text text-muted">
                          <?php echo e(trans("lang.coupon_type_help")); ?>

                        </div>
                      </div>
                    </div>

                    <div class="form-group row width-50" id="minimun_amount" style="<?php echo e($discount->apply_for == 'normal' ? '' : 'display:none;'); ?>">

                      <label class="col-3 control-label"><?php echo e(trans('Minimun amount')); ?></label>
                      <div class="col-7">
                        <input type="number" type="text" class="form-control minimun_amount" name="minimun_amount" value="<?php echo e($discount->minimum_amount); ?>">
                        <div class="form-text text-muted"><?php echo e(trans("insert minimun amount")); ?></div>
                      </div>
                    </div>

                    <!-- <div class="form-group row width-50">
                      <label class="col-3 control-label"><?php echo e(trans('Number of times allowed')); ?></label>
                      <div class="col-7">
                        <input type="number" type="text" class="form-control number_time_allowed" name="number_time_allowed" value="<?php echo e($discount->number_time_allowed); ?>">
                        <div class="form-text text-muted"><?php echo e(trans("insert number of times for use")); ?></div>
                      </div>
                    </div> -->


                    <!-- <div class="form-group row width-50">
              <label class="col-3 control-label"><?php echo e(trans('lang.coupon_restaurant_id')); ?></label>
              <div class="col-7">
                <select id="vendor_restaurant_select" class="form-control">
                  <option value=""><?php echo e(trans('lang.select_restaurant')); ?></option>
                </select>
                <div class="form-text text-muted">
                  <?php echo e(trans("lang.coupon_restaurant_id_help")); ?>

                </div> 
              </div>
            </div> -->

                    
                    <div class="form-group row width-50">
                      <label class="col-3 control-label">Apply For</label>
                      <div class="col-7">
                        <select class="form-control" name="apply_for">
                          <option value="normal" <?php echo e($discount->apply_for == 'normal' ? 'selected' : ''); ?>>Normal</option>
                          <option value="completed" <?php echo e($discount->apply_for == 'completed' ? 'selected' : ''); ?>>Completed</option>
                        </select>
                      </div>
                    </div>

                    
                    <div class="form-group row width-50" id="number_of_time" style="<?php echo e($discount->apply_for == 'completed' ? 'display:none;' : ''); ?>">
                      <label class="col-3 control-label">Number of times allowed</label>
                      <div class="col-7">
                        <input type="number" class="form-control number_time_allowed" name="number_time_allowed" value="<?php echo e($discount->number_time_allowed); ?>">
                      </div>
                    </div>

                    
                    <div class="form-group row width-50" id="rating_div" style="<?php echo e($discount->apply_for == 'completed' ? '' : 'display:none;'); ?>">
                      <label class="col-3 control-label">Rating</label>
                      <div class="col-7">
                        <select class="form-control" name="rating" id="rating_select">
                          <option value="">Select Rating</option>
                          <?php for($i = 1; $i <= 5; $i++): ?>
                            <option value="<?php echo e($i); ?>" <?php echo e($discount->rating == $i ? 'selected' : ''); ?>><?php echo e($i); ?></option>
                            <?php endfor; ?>
                        </select>
                      </div>
                    </div>


                    <div class="form-group row width-50">
                      <label class="col-3 control-label"><?php echo e(trans('lang.coupon_title')); ?></label>
                      <div class="col-7">
                        <input type="text" type="text" class="form-control coupon_code" name="title" value="<?php echo e($discount->title); ?>">
                        <div class="form-text text-muted"><?php echo e(trans("lang.coupon_title_help")); ?> </div>
                      </div>
                    </div>

                    <div class="form-group row width-100">
                      <label class="col-3 control-label"><?php echo e(trans('lang.coupon_description')); ?></label>
                      <div class="col-7">
                        <textarea rows="12" class="form-control coupon_description" name="discription" id="coupon_description"><?php echo e($discount->discription); ?></textarea>
                        <div class="form-text text-muted"><?php echo e(trans("lang.coupon_description_help")); ?></div>
                      </div>
                    </div>

                    <div class="form-group row width-100">
                      <div class="form-check">
                        <?php if($discount->statut === "yes"): ?>
                        <input type="checkbox" class="coupon_enabled" id="coupon_enabled" name="statut" checked="checked">

                        <?php else: ?>
                        <input type="checkbox" class="coupon_enabled" id="coupon_enabled" name="statut">
                        <?php endif; ?>
                        <label class="col-3 control-label" for="coupon_enabled"><?php echo e(trans('lang.coupon_enabled')); ?></label>

                      </div>
                    </div>
                  </fieldset>
                </div>

              </div>

          </div>
          <div class="form-group col-12 text-center btm-btn">
            <button type="submit" class="btn btn-primary save_coupon_btn"><i class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?></button>
          </div>
          </form>
        </div>
      </div>
    </div>
  </div>

  <?php $__env->stopSection(); ?>

  <?php $__env->startSection('scripts'); ?>
  <script>
    let slabIndex = <?php echo e(count($slabs)); ?>;

    $('#add_slab').click(function() {
      $('#slab_table tbody').append(`
    <tr>
      <td><input type="number" name="slabs[${slabIndex}][min]" class="form-control" required></td>
      <td><input type="number" name="slabs[${slabIndex}][discount]" class="form-control" required></td>     
      <td><button type="button" class="btn btn-sm btn-danger remove_slab">X</button></td>
    </tr>
  `);
      slabIndex++;
    });

    $(document).on('click', '.remove_slab', function() {
      $(this).closest('tr').remove();
    });


    function toggleRating() {
      var applyFor = $('select[name="apply_for"]').val();
      // if (applyFor === 'completed') {
      //   $('#rating_div').show();
      //   $('#number_of_time').hide();
      // } else {
      //   $('#rating_div').hide();
      //   $('#number_of_time').show();
      // }

      if (applyFor === 'completed') {
        $('#rating_div').show();        
        $('#discount_slab').show();
        $('#discount').hide();
        $('#number_of_time').hide();
        $('#minimun_amount').hide();
      } else {
        $('#rating_div').hide();
        $('#rating_select').val('');
        $('#discount_slab').hide();
        $('#discount').show();
        $('#number_of_time').show();
        $('#minimun_amount').show();
      }


    }

    // On page load
    toggleRating();

    // On change of Apply For dropdown
    $('select[name="apply_for"]').change(function() {
      toggleRating();
    });
  </script>

  <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/coupons/edit.blade.php ENDPATH**/ ?>