<?php $__env->startSection('content'); ?>

<div class="page-wrapper">

    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor"><?php echo e(trans('lang.rental_vehicle_type')); ?></h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                <li class="breadcrumb-item active"><?php echo e(trans('lang.rental_vehicle_type')); ?></li>
            </ol>
        </div>
        <div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">

                    <div class="card-body">

                        <div id="data-table_processing" class="dataTables_processing panel panel-default"
                             style="display: none;"><?php echo e(trans('lang.processing')); ?>

                        </div>

                        <div class="userlist-topsearch d-flex mb-3">

                            <div class="userlist-top-left">
                                <a class="nav-link do_not_create" href="<?php echo route('vehicle-rental-type.create'); ?>"><i class="fa fa-plus mr-2"></i><?php echo e(trans('lang.create_rental_vehicle_type')); ?></a>
                            </div>

                            <div id="users-table_filter" class="ml-auto">
                              <label><?php echo e(trans('lang.search_by')); ?>

                                <div class="form-group">

                                    <form action="<?php echo e(route('vehicle-rental-type')); ?>" method="get">


                                        <?php if(isset($_GET['selected_search']) && $_GET['selected_search'] != ''): ?>
                                        <select name="selected_search" id="selected_search"
                                                class="form-control input-sm">
                                            <option value="libelle" <?php if($_GET[
                                            'selected_search']=='libelle'): ?>
                                            selected="selected" <?php endif; ?>><?php echo e(trans('lang.vehicle_type')); ?></option>
                                            <option value="prix" <?php if($_GET[
                                            'selected_search']=='prix'): ?>
                                            selected="selected" <?php endif; ?>><?php echo e(trans('lang.price')); ?></option>
                                        </select>
                                        <?php else: ?>
                                        <select name="selected_search" id="selected_search"
                                                class="form-control input-sm">
                                            <option value="libelle"><?php echo e(trans('lang.vehicle_type')); ?></option>
                                            <option value="prix"><?php echo e(trans('lang.price')); ?></option>
                                        </select>
                                        <?php endif; ?>
                                        <div class="search-box position-relative">
                                            <?php if(isset($_GET['search']) && $_GET['search'] != ''): ?>
                                            <input type="text" class="search form-control" name="search" id="search"
                                                   value="<?php echo e($_GET['search']); ?>">
                                            <?php else: ?>
                                            <input type="text" class="search form-control" name="search" id="search">
                                            <?php endif; ?>
                                            <button type="submit" class="btn-flat position-absolute"><i
                                                        class="fa fa-search"></i></button>
                                            <a class="btn btn-warning btn-flat"
                                               href="<?php echo e(url('vehicle-rental-type/index')); ?>">Clear</a>
                                        </div>

                                    </form>

                                </div>
                              </label>
                            </div>
                        </div>
                        <div class="table-responsive m-t-10">
                            <table id="example24"
                                   class="display nowrap table table-hover table-striped table-bordered table table-striped"
                                   cellspacing="0" width="100%">
                                <thead>
                                <tr>
                                    <th class="delete-all"><input type="checkbox" id="is_active"><label
                                                class="col-3 control-label" for="is_active"><a id="deleteAll"
                                                                                               class="do_not_delete"
                                                                                               href="javascript:void(0)"><i
                                                        class="fa fa-trash"></i> All</a></label></th>
                                    <th><?php echo e(trans('lang.extra_image')); ?></th>
                                    <th><?php echo e(trans('lang.vehicle_type')); ?></th>
                                    <th><?php echo e(trans('lang.price')); ?></th>
                                    <th><?php echo e(trans('lang.number_of_passenger')); ?></th>
                                    <th><?php echo e(trans('lang.status')); ?></th>
                                    <!-- <th ><?php echo e(trans('lang.status')); ?></th> -->
                                    <th><?php echo e(trans('lang.created_at')); ?></th>
                                    

                                    <th><?php echo e(trans('lang.actions')); ?></th>
                                </tr>
                                </thead>
                                <tbody id="append_list12">
                                <?php if(count($vehicletype) > 0): ?>
                                <?php $__currentLoopData = $vehicletype; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <tr>
                                    <td class="delete-all"><input type="checkbox"
                                                                  id="is_open_<?php echo e($type->id); ?>"
                                                                  class="is_open"
                                                                  dataid="<?php echo e($type->id); ?>"><label
                                                class="col-3 control-label"
                                                for="is_open_<?php echo e($type->id); ?>"></label></td>
                                    <?php if(file_exists(public_path('assets/images/type_vehicle_rental'.'/'.$type->image)) &&
                                    !empty($type->image)): ?>
                                    <td><img class="rounded" style="width:50px"
                                             src="<?php echo e(asset('assets/images/type_vehicle_rental').'/'.$type->image); ?>" alt="image">
                                    </td>
                                    <?php else: ?>
                                    <td><img class="rounded" style="width:50px"
                                             src="<?php echo e(asset('assets/images/placeholder_image.jpg')); ?>" alt="image"></td>
                                    <?php endif; ?>
                                    <td><?php echo e($type->libelle); ?></td>
                                    <td>
                                        <?php if($currency->symbol_at_right=="true"): ?>
                                            <?php echo e(number_format(floatval($type->prix),$currency->decimal_digit)."".$currency->symbole); ?>

                                        <?php else: ?>
                                         <?php echo e($currency->symbole."".number_format(floatval($type->prix),$currency->decimal_digit)); ?>

                                        <?php endif; ?>                                        
                                    </td>
                                    <td><?php echo e($type->no_of_passenger); ?></td>
                                    <td> <?php if($type->status=="yes"): ?>
                                          <label class="switch"><input type="checkbox" id="<?php echo e($type->id); ?>" name="publish" checked><span class="slider round"></span></label>
                                        <?php else: ?>
                                              <label class="switch"><input type="checkbox" id="<?php echo e($type->id); ?>" name="publish"><span class="slider round"></span></label>
                                        <?php endif; ?>
                                      </td>




                                    <td>
                                        <span class="date"><?php echo e(date('d F Y',strtotime($type->creer))); ?></span>
                                        <span class="time"><?php echo e(date('h:i A',strtotime($type->creer))); ?></span>
                                    </td>
                                   
                                    <td class="action-btn"><a class="edit_type_vehicle do_not_edit" href="<?php echo e(route('vehicle-rental-type.edit', ['id' => $type->id])); ?>"><i
                                                    class="fa fa-edit"></i></a><a id="'+val.id+'" class="do_not_delete"
                                                                                  href="<?php echo e(route('vehicle-rental-type.delete', ['id' => $type->id])); ?>" class="do_not_delete"><i
                                                    class="fa fa-trash"></i></a></td>



                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                	<?php else: ?>
                                	<tr><td colspan="11" align="center"><?php echo e(trans("lang.no_result")); ?></td></tr>
                                <?php endif; ?>
                                </tbody>
                            </table>


                            <nav aria-label="Page navigation example" class="custom-pagination">
                                <?php echo e($vehicletype->appends(request()->query())->links()); ?>

                            </nav>
                            <?php echo e($vehicletype->links('pagination.pagination')); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
</div>



<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>

<script type="text/javascript">
    $(document).ready(function () {
        $(".shadow-sm").hide();
    })

    $(".edit_type_vehicle").click(function () {


    })

    $("#is_active").click(function () {
        $("#example24 .is_open").prop('checked', $(this).prop('checked'));

    });

    $("#deleteAll").click(function () {
        if ($('#example24 .is_open:checked').length) {
            if (confirm('Are You Sure want to Delete Selected Data ?')) {
                var arrayUsers = [];
                $('#example24 .is_open:checked').each(function () {
                    var dataId = $(this).attr('dataId');
                    arrayUsers.push(dataId);

                });

                arrayUsers = JSON.stringify(arrayUsers);
                var url = "<?php echo e(url('vehicle-rental-type/delete', 'id')); ?>";
                url = url.replace('id', arrayUsers);

                $(this).attr('href', url);
            }
        } else {
            alert('Please Select Any One Record .');
        }
    });

    $(document).on("click", "input[name='publish']", function (e) {
    
    var ischeck = $(this).is(':checked');
    var id = this.id;

    $.ajax({
      headers: {
     'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
   },
       url : '../rental_vehicle_type/switch',
       method:"POST",
       data:{'ischeck':ischeck,'id':id},
       success: function(data){

       },
    });

});
    
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/rental_vehicle_type/index.blade.php ENDPATH**/ ?>