<?php
use Illuminate\Pagination\Paginator;
?>

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <!-- ============================================================== -->
    <!-- Bread crumb and right sidebar toggle -->
    <!-- ============================================================== -->
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor"><?php echo e(trans('lang.language')); ?></h3>
        </div>
        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                <li class="breadcrumb-item active">languages</li>
            </ol>
        </div>
        <div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">

                    <div class="card-body">
                        <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;"><?php echo e(trans('lang.processing')); ?>

                        </div>
                        <div class="userlist-topsearch d-flex mb-3">
                            <div class="userlist-top-left">
                            <a class="nav-link do_not_create" href="<?php echo e(route('language.create')); ?>"><i class="fa fa-plus mr-2"></i><?php echo e(trans('lang.language_create')); ?></a>
                            </div>
                        <div id="users-table_filter" class="ml-auto">
                          <label><?php echo e(trans('lang.search_by')); ?>

                            <div class="form-group mb-0">
                                <form action="<?php echo e(route('language')); ?>" method="get">
                                    <?php if(isset($_GET['selected_search']) &&  $_GET['selected_search'] != ''): ?>
                                    <select name="selected_search" id="selected_search" class="form-control input-sm">
                                        <option value="prenom" <?php if($_GET['selected_search']=='language'): ?> selected="selected" <?php endif; ?> ><?php echo e(trans('lang.language')); ?></option>
                                    </select>
                                     <?php else: ?>
                                        <select name="selected_search" id="selected_search" class="form-control input-sm">
                                            <option value="prenom"><?php echo e(trans('lang.language')); ?></option>
                                        </select>
                                    <?php endif; ?>
                                        <div class="search-box position-relative">
                                            <?php if(isset($_GET['search']) &&  $_GET['search'] != ''): ?>
                                            <input type = "text" class="search form-control" name="search" id = "search" value="<?php echo e($_GET['search']); ?>">
                                            <?php else: ?>
                                            <input type = "text" class="search form-control" name="search" id = "search">
                                            <?php endif; ?>
                                            <button type="submit" class="btn-flat position-absolute"><i class="fa fa-search"></i></button>
                                            <a class="btn btn-warning btn-flat" href="<?php echo e(url('language')); ?>">Clear</a>
                                        </div>
                                </form>
                            </div>
                          </label>
                        </div>
                    </div>
                        <div class="table-responsive m-t-10">
                        <div class="error_top"></div>
									<?php if($errors->any()): ?>
							<div class="alert alert-danger" style="display:none;">
								<ul>
									<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<li><?php echo e($error); ?></li>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</ul>
							</div>
							<?php endif; ?>
                         
                            <table id="example24" class="display nowrap table table-hover table-striped table-bordered table table-striped" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th><?php echo e(trans('lang.extra_image')); ?></th>
                                        <th ><?php echo e(trans('lang.language')); ?></th>
                                        <th ><?php echo e(trans('lang.code')); ?></th>
                                        <th ><?php echo e(trans('lang.status')); ?></th>
                                        <th><?php echo e(trans('lang.actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody id="append_list12">
                                    <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                        <?php if(file_exists(public_path('assets/images/flags'.'/'.$customer->flag)) && !empty($customer->flag)): ?>
                                            <td><img class="rounded" style="width:50px" src="<?php echo e(asset('assets/images/flags').'/'.$customer->flag); ?>" alt="image"></td>
                                        <?php else: ?>
                                        <td><img class="rounded" style="width:50px" src="<?php echo e(asset('assets/images/placeholder_image.jpg')); ?>" alt="image"></td>

                                        <?php endif; ?>
                                        <td><?php echo e($customer->language); ?></td>
                                        <td><?php echo e($customer->code); ?></td>
                                        <td>
                                            <?php if($customer->status=="true"): ?>
                                                        <label class="switch"><input type="checkbox" checked id="<?php echo e($customer->id); ?>" name="publish"><span class="slider round"></span></label>
                                                    <?php else: ?>
                                                        <label class="switch"><input type="checkbox"  id="<?php echo e($customer->id); ?>" name="publish"><span class="slider round"></span></label>
                                                    <?php endif; ?>
                                        </td>
                                        <td class="action-btn"><a href="<?php echo e(route('language.edit', ['id' => $customer->id])); ?>" class="do_not_edit"><i class="fa fa-edit"></i></a><a id="'+val.id+'" class="do_not_delete" name="user-delete" href="<?php echo e(route('language.delete', ['id' => $customer->id])); ?>"><i class="fa fa-trash"></i></a>
                                         <!-- <a href="<?php echo e(route('users.show', ['id' => $customer->id])); ?>" class="" data-toggle="tooltip" data-original-title="Details"><i class="fa fa-ellipsis-h"></i></a></td> -->
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>

                            <nav aria-label="Page navigation example" class="custom-pagination">
                                 <?php echo e($language->appends(request()->query())->links()); ?>

                            </nav>
                            <?php echo e($language->links('pagination.pagination')); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script type="text/javascript">


$(document).ready(function() {
     $(".shadow-sm").hide();
})

var status = $("input[name='publish']").val();
    
    $(document).on("click", "input[name='publish']", function (e) {
        
       var ischeck = $(this).is(':checked');
       var id = this.id;
       var url = "<?php echo e(route('language.switch')); ?>";
       
       $.ajax({
           headers: {
               'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
           },
           url: url,
           method: "POST",
           data: {'ischeck': ischeck, 'id': id},
           success: function (data) {
               console.log(data.error);
               if(data.error){
                   $(".error_top").show();
                   $(".error_top").html("");
                   $(".error_top").after("<div class='alert alert-danger'><ul><li>"+data.error+"</li></ul></div>");
               }
               window.location.reload();

           },
           error: function(response) {
            },
       });
   });

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/language/index.blade.php ENDPATH**/ ?>