<!doctype html>

<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>

    <meta charset="utf-8">

    <meta name="viewport" content="width=device-width, initial-scale=1">


    <!-- CSRF Token -->

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">


    <title><?php echo e(config('app.name', 'Laravel')); ?></title>


    <!-- Fonts -->

    <link rel="dns-prefetch" href="//fonts.gstatic.com">

    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">

    <!-- Styles -->

    <link href="<?php echo e(asset('assets/plugins/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet">

    <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">

    <link href="<?php echo e(asset('assets/plugins/toast-master/css/jquery.toast.css')); ?>" rel="stylesheet">

    <link href="<?php echo e(asset('css/colors/blue.css')); ?>" rel="stylesheet">

    <?php echo $__env->yieldContent('style'); ?>


</head>

<body>

<style type="text/css">


    .form-group.default-admin {
        padding: 10px;
        font-size: 14px;
        color: #000;
        font-weight: 600;
        border-radius: 10px;
        box-shadow: 0 0px 6px 0px rgba(0, 0, 0, 0.5);
        margin: 20px 10px 10px 10px;
    }

    .form-group.default-admin .crediantials-field {
        position: relative;
        padding-right: 15px;
        text-align: left;
        padding-top: 5px;
        padding-bottom: 5px;
    }

    .form-group.default-admin .crediantials-field > a {
        position: absolute;
        right: 0;
        top: 0;
        bottom: 0;
        margin: auto;
        height: 20px;
    }

    .login-register {
        background-color: #072750;
    }

    .btn-primary, .btn-primary.disabled, .btn-primary:hover, .btn-primary.disabled:hover {
        background: #072750;
    }

    <?php if(isset($_COOKIE['admin_panel_color'])){ ?>
	a, a:hover, a:focus {
        color: <?php echo $_COOKIE['admin_panel_color']; ?>;
    }

    .btn-primary, .btn-primary.disabled, .btn-primary:hover, .btn-primary.disabled:hover {
        background: <?php echo $_COOKIE['admin_panel_color']; ?>;
        border: 1px solid<?php echo $_COOKIE['admin_panel_color']; ?>;
    }

    [type="checkbox"]:checked + label::before {
        border-right: 2px solid<?php echo $_COOKIE['admin_panel_color']; ?>;
        border-bottom: 2px solid<?php echo $_COOKIE['admin_panel_color']; ?>;
    }

    .form-material .form-control, .form-material .form-control.focus, .form-material .form-control:focus {
        background-image: linear-gradient(<?php echo $_COOKIE['admin_panel_color']; ?>, <?php echo $_COOKIE['admin_panel_color']; ?>), linear-gradient(rgba(120, 130, 140, 0.13), rgba(120, 130, 140, 0.13));
    }

    .btn-primary.active, .btn-primary:active, .btn-primary:focus, .btn-primary.disabled.active, .btn-primary.disabled:active, .btn-primary.disabled:focus, .btn-primary.active.focus, .btn-primary.active:focus, .btn-primary.active:hover, .btn-primary.focus:active, .btn-primary:active:focus, .btn-primary:active:hover, .open > .dropdown-toggle.btn-primary.focus, .open > .dropdown-toggle.btn-primary:focus, .open > .dropdown-toggle.btn-primary:hover, .btn-primary.focus, .btn-primary:focus, .btn-primary:not(:disabled):not(.disabled).active:focus, .btn-primary:not(:disabled):not(.disabled):active:focus, .show > .btn-primary.dropdown-toggle:focus {
        background: <?php echo $_COOKIE['admin_panel_color']; ?>;
        border-color: <?php echo $_COOKIE['admin_panel_color']; ?>;
        box-shadow: 0 0 0 0.2rem<?php echo $_COOKIE['admin_panel_color']; ?>;
    }

    .login-register {
        background-color: <?php echo $_COOKIE['admin_panel_color']; ?>;
    }
    <?php } ?>

</style>


<section id="wrapper">


    <div class="login-register">


        <div class="login-logo text-center py-3">

            <a href="#" style="display: inline-block;background: #fff;padding: 10px;border-radius: 5px;"><img
                        src="<?php echo e(asset('images/_logo_taxijaune.jpg')); ?>"> </a>

        </div>

        <div class="login-box card" style="margin-bottom:0%;">

            <div class="card-body">


                <?php if(count($errors) > 0): ?>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="alert alert-danger display-hide">
                            <button class="close" data-close="alert"></button>
                            <span><?php echo e($message); ?></span>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>

                <form class="form-horizontal form-material" method="POST" action="<?php echo e(route('login')); ?>">

                    <?php echo csrf_field(); ?>

                    <div class="box-title m-b-20"><?php echo e(__('Login')); ?></div>


                    <div class="form-group ">


                        <div class="col-xs-12">


                            <input class="form-control" placeholder="<?php echo e(__('Email Address')); ?>" id="email" type="email"
                                   class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="email"
                                   value="<?php echo e(old('email')); ?>" required autocomplete="email" autofocus></div>


                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>

                        <span class="invalid-feedback" role="alert">

                                            <strong><?php echo e($message); ?></strong>

                                        </span>

                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>


                    </div>


                    <div class="form-group">


                        <div class="col-xs-12">


                            <input id="password" placeholder="<?php echo e(__('Password')); ?>" type="password"
                                   class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="password" required
                                   autocomplete="current-password"></div>


                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>

                        <span class="invalid-feedback" role="alert">

                                                <strong><?php echo e($message); ?></strong>

                                            </span>

                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>


                    </div>


                    <div class="form-group text-center m-t-20">


                        <div class="col-xs-12">


                            <input class="form-check-input" type="checkbox" name="remember"
                                   id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>


                            <label class="form-check-label" for="remember">

                                <?php echo e(__('Remember Me')); ?>


                            </label>


                        </div>


                    </div>


                    <div class="form-group text-center m-t-20 mb-0">


                        <div class="col-xs-12">


                            <button type="submit"
                                    class="btn btn-dark btn-lg btn-block text-uppercase waves-effect waves-light btn btn-primary">

                                <?php echo e(__('Login')); ?>


                            </button>

                        </div>


                    </div>

                    
                </form>

            </div>

        </div>

    </div>

</section>

<script src="<?php echo e(asset('assets/plugins/jquery/jquery.min.js')); ?>"></script>

<script src="<?php echo e(asset('assets/plugins/bootstrap/js/popper.min.js')); ?>"></script>

<script src="<?php echo e(asset('assets/plugins/bootstrap/js/bootstrap.min.js')); ?>"></script>

<script src="<?php echo e(asset('js/jquery.slimscroll.js')); ?>"></script>

<script src="<?php echo e(asset('js/waves.js')); ?>"></script>

<script src="<?php echo e(asset('js/sidebarmenu.js')); ?>"></script>

<script src="<?php echo e(asset('assets/plugins/sticky-kit-master/dist/sticky-kit.min.js')); ?>"></script>

<script src="<?php echo e(asset('assets/plugins/sparkline/jquery.sparkline.min.js')); ?>"></script>

<script src="<?php echo e(asset('js/custom.min.js')); ?>"></script>

</body>

</html>
<?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/auth/login.blade.php ENDPATH**/ ?>