<?php $__env->startSection('content'); ?>
<div class="page-wrapper">

    <div class="row page-titles">

        <div class="col-md-5 align-self-center">

            <h3 class="text-themecolor"><?php echo e(trans('lang.notification')); ?></h3>

        </div>

        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a>
                </li>
                <li class="breadcrumb-item active">
                    <?php echo e(trans('lang.notification')); ?>

                </li>
            </ol>
        </div>

    </div>

    <div class="container-fluid">

        <div class="row">

            <div class="col-12">

                <div class="card">

                    <div class="card-body">

                        <div class="userlist-topsearch d-flex mb-3">
                            <div class="userlist-top-left">
                                <a class="nav-link do_not_create" href="<?php echo e(route('notifications.create')); ?>"><i class="fa fa-plus mr-2"></i><?php echo e(trans('lang.create_notification')); ?></a>
                            </div>

                            <div id="users-table_filter" class="ml-auto">

                                <div class="form-group">
                                    <form action="<?php echo e(route('notifications')); ?>" method="get">
                                        <?php if(isset($_GET['selected_search']) && $_GET['selected_search'] != ''): ?>
                                        <select name="selected_search" id="selected_search"
                                            class="form-control input-sm">

                                            <option value="title" <?php if($_GET['selected_search']=='title'): ?>
                                                    selected="selected" <?php endif; ?> ><?php echo e(trans('lang.title')); ?></option>

                                                    <option value="message" <?php if($_GET['selected_search']=='message'): ?>
                                                    selected="selected" <?php endif; ?>><?php echo e(trans('lang.message')); ?></option>

                                                    
                                            <!-- <option value="name_admin"><?php echo e(trans('lang.name_admin')); ?></option> -->
                                            
                                        </select>
                                        <?php else: ?>
                                        <select name="selected_search" id="selected_search"
                                            class="form-control input-sm">
                                            <!-- <option value="name_admin"><?php echo e(trans('lang.name_admin')); ?></option> -->
                                            <option value="title"><?php echo e(trans('lang.title')); ?></option>
                                            <option value="message"><?php echo e(trans('lang.message')); ?></option>
                                        </select>
                                        <?php endif; ?>
                                        <div class="search-box position-relative">
                                            <?php if(isset($_GET['search']) && $_GET['search'] != ''): ?>
                                            <input type="text" class="search form-control" name="search" id="search"
                                                value="<?php echo e($_GET['search']); ?>">
                                            <?php else: ?>
                                            <input type="text" class="search form-control" name="search" id="search">
                                            <?php endif; ?>
                                            <button type="submit" class="btn-flat position-absolute"><i
                                                    class="fa fa-search"></i></button>
                                            <a class="btn btn-warning btn-flat" href="<?php echo e(url('notification')); ?>">Clear</a>
                                        </div>
                                    </form>
                                </div>
                            </div>

                        </div>

                        <div class="table-responsive m-t-10">

                            <table id="example24"
                                class="display nowrap table table-hover table-striped table-bordered table table-striped"
                                cellspacing="0" width="100%">

                                <thead>

                                    <tr>
                                        <th class="delete-all"><input type="checkbox" id="is_active"><label
                                                class="col-3 control-label" for="is_active"><a id="deleteAll"
                                                    class="do_not_delete" href="javascript:void(0)"><i
                                                        class="fa fa-trash"></i> All</a></label></th>
                                        <th><?php echo e(trans('lang.title')); ?></th>
                                        <th><?php echo e(trans('lang.message')); ?></th>
                                        <th><?php echo e(trans('lang.created')); ?></th>
                                        <th><?php echo e(trans('lang.actions')); ?></th>
                                    </tr>

                                </thead>

                                <tbody id="append_list1">
                                    <?php if(count($notifications) > 0): ?>
                                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="delete-all"><input type="checkbox" id="is_open_<?php echo e($notification->id); ?>"
                                                class="is_open" dataid="<?php echo e($notification->id); ?>"><label
                                                class="col-3 control-label" for="is_open_<?php echo e($notification->id); ?>"></label>
                                        </td>

                                        <td><?php echo e($notification->title); ?></td>
                                        <td class="address-td"><?php echo e($notification->message); ?></td>
                                        <td class="dt-time"><span class="date"><?php echo e(date('d F
                                                Y',strtotime($notification->created_at))); ?></span>
                                            <span class="time"><?php echo e(date('h:i A',strtotime($notification->updated_at))); ?></span>
                                        </td>
                                        <td class="action-btn">
                                            <a id="'+val.id+'" class="do_not_delete" name="user-delete"
                                                href="<?php echo e(route('notifications.delete', ['id' => $notification->id])); ?>"><i
                                                    class="fa fa-trash"></i></a>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                            		<tr><td colspan="5" align="center"><?php echo e(trans("lang.no_result")); ?></td></tr>
                            	    <?php endif; ?>
                                </tbody>

                            </table>

                            <nav aria-label="Page navigation example" class="custom-pagination">
                                <?php echo e($notifications->links()); ?>

                            </nav>
                            <?php echo e($notifications->links('pagination.pagination')); ?>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script type="text/javascript">
    $(document).ready(function () {
        $(".shadow-sm").hide();
    })

    $("#is_active").click(function () {
        $("#example24 .is_open").prop('checked', $(this).prop('checked'));

    });

    $("#deleteAll").click(function () {
        if ($('#example24 .is_open:checked').length) {

            if (confirm('Are You Sure want to Delete Selected Data ?')) {
                var arrayUsers = [];
                $('#example24 .is_open:checked').each(function () {
                    var dataId = $(this).attr('dataId');
                    arrayUsers.push(dataId);

                });

                arrayUsers = JSON.stringify(arrayUsers);
                var url = "<?php echo e(url('notification/delete', 'id')); ?>";
                url = url.replace('id', arrayUsers);

                $(this).attr('href', url);
            }
        } else {
            alert('Please Select Any One Record .');
        }
    });

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/admin_notifications/index.blade.php ENDPATH**/ ?>