<?php $__env->startSection('content'); ?>


<div class="page-wrapper">
  <div class="row page-titles">
    <div class="col-md-5 align-self-center">
      <h3 class="text-themecolor"><?php echo e(trans('lang.driver_edit')); ?></h3>
    </div>

    <div class="col-md-7 align-self-center">
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
        <li class="breadcrumb-item"><a href="<?php echo route('drivers'); ?>"><?php echo e(trans('lang.driver_plural')); ?></a></li>
        <li class="breadcrumb-item active"><?php echo e(trans('lang.driver_edit')); ?></li>
      </ol>
    </div>
  </div>







  <div class="container-fluid">

    <div class="row daes-top-sec">



      <!-- Column -->

      <!-- Column -->

      <div class="col-lg-4 col-md-6">


        <div class="card">

          <div class="card-body d-flex icon-blue">

            <div class="card-left">

              <?php if($earnings[0]->montant == ""): ?>
              <?php $earning=0 ?>
              <?php else: ?>
              <?php $earning=$earnings[0]->montant ?>
              <?php endif; ?>
              <h3 class="m-b-0 text-info" id="restaurant_count">
                <?php if($currency->symbol_at_right=="true"): ?>
                <?php echo e(number_format($earning,$currency->decimal_digit)); ?><?php echo e($currency->symbole); ?>

                <?php else: ?>
                <?php echo e($currency->symbole); ?><?php echo e(number_format($earning,$currency->decimal_digit)); ?>

                <?php endif; ?>
              </h3>



              <h5 class="text-muted m-b-0"><?php echo e(trans('lang.dashboard_total_earnings')); ?></h5>
            </div>

            <div class="card-right ml-auto">

              <i class="mdi mdi-wallet"></i>

            </div>

          </div>

        </div>



      </div>

      <!-- Column -->

      <!-- Column -->

      <div class="col-lg-4 col-md-6">

        <div class="card">

          <div class="card-body d-flex icon-blue">

            <div class="card-left">

              <?php if($earnings[0]->rides == ""): ?>
              <h3 class="m-b-0 text-info">0</h3>
              <?php else: ?>
              <h3 class="m-b-0 text-info"><?php echo e($earnings[0]->rides); ?></h3>
              <?php endif; ?>
              <h5 class="text-muted m-b-0"><?php echo e(trans('lang.completed_rides')); ?></h5>
            </div>

            <div class="card-right ml-auto">

              <i class="mdi mdi-car"></i>

            </div>

          </div>

        </div>


      </div>



      <div class="col-lg-4 col-md-6">
        <div class="card">
          <div class="card-body d-flex icon-blue">
            <div class="card-left">
              <h3 class="m-b-0 text-info"><?php echo e(number_format($avg_rating,1)); ?></h3>
              <h5 class="text-muted m-b-0"><?php echo e(trans('lang.average_ratings')); ?></h5>
            </div>
            <div class="card-right ml-auto"><i class="mdi mdi-star"></i></div>
          </div>
        </div>
      </div>


      <!-- Column -->


      <!-- Column -->

    </div>

    <div class="card pb-4">

      <div class="card-body">

        <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;">
          <?php echo e(trans('lang.processing')); ?></div>
        <div class="error_top"></div>
        <?php if($errors->any()): ?>
        <div class="alert alert-danger">
          <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </ul>
        </div>
        <?php endif; ?>
        <form method="post" action="<?php echo e(route('driver.update',$driver->id)); ?>" enctype="multipart/form-data">
          <?php echo csrf_field(); ?>
          <?php echo method_field("PUT"); ?>
          <div class="row restaurant_payout_create">
            <div class="restaurant_payout_create-inner">

              <fieldset>
                <legend><?php echo e(trans('lang.driver_edit')); ?></legend>
                <div class="form-group row width-50">
                  <label class="col-3 control-label"><?php echo e(trans('lang.first_name')); ?></label>
                  <div class="col-7">
                    <input type="text" class="form-control user_first_name" name="nom" value="<?php echo e($driver->nom); ?>">
                    <div class="form-text text-muted">
                      <?php echo e(trans("lang.user_first_name_help")); ?>

                    </div>
                  </div>
                </div>

                <div class="form-group row width-50">
                  <label class="col-3 control-label"><?php echo e(trans('lang.last_name')); ?></label>
                  <div class="col-7">
                    <input type="text" class="form-control user_last_name" name="prenom" value="<?php echo e($driver->prenom); ?>">
                    <div class="form-text text-muted">
                      <?php echo e(trans("lang.user_last_name_help")); ?>

                    </div>
                  </div>
                </div>
                <div class="form-group row width-50">
                  <label class="col-3 control-label"><?php echo e(trans('lang.email')); ?></label>
                  <div class="col-7">
                    <input type="text" class="form-control user_email" name="email" value="<?php echo e($driver->email); ?>">
                    <div class="form-text text-muted">
                      <?php echo e(trans("lang.user_email_help")); ?>

                    </div>
                  </div>
                </div>

                <div class="form-group row width-50">
                  <label class="col-3 control-label"><?php echo e(trans('lang.user_phone')); ?></label>
                  <div class="col-7">
                    <input type="text" class="form-control user_phone" name="phone" value="<?php echo e($driver->phone); ?>">
                    <div class="form-text text-muted w-50">
                      <?php echo e(trans("lang.user_phone_help")); ?>

                    </div>
                  </div>

                </div>

                <div class="form-group row width-50">
                  <label class="col-3 control-label"><?php echo e(trans('lang.zone')); ?></label>
                  <div class="col-7">
                    <select class="form-control" name="zone[]" id="zone" multiple="multiple">
                      <?php $__currentLoopData = $zones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $zone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <?php if (in_array($zone->id,explode(',',$driver->zone_id))) {
                        $selected = 'Selected';
                      } else {
                        $selected = '';
                      }
                      ?>
                      <option value="<?php echo e($zone->id); ?>" <?php echo $selected ?>><?php echo e($zone->name); ?></option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <div class="form-text text-muted w-50">
                      <?php echo e(trans("lang.select_zone_help")); ?>

                    </div>
                  </div>
                </div>
                <div class="form-group row width-50">
                  <label class="col-3 control-label">Driver Type</label>
                  <?php
          $type = ['In house driver', 'Outside driver']
        ?>
                  <div class="col-7">
                    <select class="form-control" name="driver_type">
                      <option value="">Select Driver Type</option>
                      <?php $__currentLoopData = $type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($value); ?>" <?php if($driver->driver_type == $value) echo 'selected';?>><?php echo e($value); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                  </div>

                </div>

                <div class="form-group row width-100">
                  <label class="col-2 control-label"><?php echo e(trans('lang.restaurant_image')); ?></label>
                  <input type="file" class="col-6" name="photo" onchange="readURL(this);">
                  <?php if(file_exists(public_path('assets/images/driver'.'/'.$driver->photo_path)) &&
                  !empty($driver->photo_path)): ?>
                  <td><img class="rounded" id="uploding_image" style="width:100px"
                      src="<?php echo e(asset('assets/images/driver').'/'.$driver->photo_path); ?>" alt="image"></td>
                  <?php else: ?>
                  <td><img class="rounded" id="uploding_image" style="width:100px"
                      src="<?php echo e(asset('assets/images/placeholder_image.jpg')); ?>" alt="image"></td>

                  <?php endif; ?>

                </div>


                <div class="form-group row width-50">

                  <div class="form-check">

                    <?php if($driver->statut === "yes"): ?>
                    <input type="checkbox" class="user_active" name="statut" id="user_active" checked="checked">
                    <?php else: ?>
                    <input type="checkbox" class="user_active" name="statut" id="user_active">
                    <?php endif; ?>
                    <label class="col-3 control-label" for="user_active"><?php echo e(trans('lang.status')); ?></label>
                  </div>

                </div>
                <div class="form-check  width-50">
                  <input type="checkbox" class="col-7 form-check-inline parcel_delivery" id="parcel_delivery"
                    name="parcel_delivery" value="yes" <?php echo e(($driver->parcel_delivery=="yes") ? "checked" : ""); ?>>
                  <label class="col-3 control-label" for="parcel_delivery"><?php echo e(trans('lang.active_parcel_delivery')); ?></label>
                </div>

  
              </fieldset>

              <fieldset>
                <legend><?php echo e(trans('lang.vehicle_info')); ?></legend>
                <div class="form-group row width-50">
                  <label class="col-3 control-label"><?php echo e(trans('lang.vehicle_type')); ?></label>
                  <div class="col-7">
                    <select class="form-control model" name="id_type_vehicule" id="id_type_vehicule">
                      <option value=""><?php echo e(trans('lang.select_type')); ?></option>
                      <?php $__currentLoopData = $vehicleType; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <?php if ($value->id == $vehicle->id_type_vehicule) {
                        $selected = 'Selected';
                      } else {
                        $selected = '';
                      }
                      ?>
                      <option value="<?php echo e($value->id); ?>" <?php echo $selected ?>><?php echo e($value->libelle); ?></option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                  </div>
                </div>
                <div class="form-group row width-50">
                  <label class="col-3 control-label"><?php echo e(trans('lang.vehicle_brand')); ?></label>
                  <div class="col-7">
                    <select class="form-control brand_id" name="brand">
                      <option value=""><?php echo e(trans('lang.select_brand')); ?></option>
                      
                      <?php $__currentLoopData = $brand; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <?php if ($value->id == $vehicle->brand) {
                        $selected = 'Selected';
                      } else {
                        $selected = '';
                      }
                      ?>
                      <option value="<?php echo e($value->id); ?>" <?php echo $selected ?>><?php echo e($value->name); ?></option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                  </div>

                </div>

                <div class="form-group row width-50">
                  <label class="col-3 control-label"><?php echo e(trans('lang.vehicle_model')); ?></label>
                  <div class="col-7">
                    <select class="form-control model" name="model" id="model">
                      <option value=""><?php echo e(trans('lang.select_model')); ?></option>
                      <?php $__currentLoopData = $model; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <?php
                      if ($value->id == $vehicle->model) {
                        $selected = 'Selected';
                      } else {
                        $selected = '';
                      }
                      ?>
                      <option value="<?php echo e($value->id); ?>" <?php echo $selected ?>><?php echo e($value->name); ?></option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <div class="form-text text-muted"><?php echo e(trans('lang.car_model_help')); ?></div>
                  </div>
                </div>

                <div class="form-group row width-50">
                  <label class="col-3 control-label"><?php echo e(trans('lang.vehicle_color')); ?></label>
                  <div class="col-7">
                    <input type="text" class="form-control user_last_name" name="color"
                      value="<?php echo e(!empty($vehicle) ? $vehicle->color : ''); ?>">
                    <div class="form-text text-muted">
                      <?php echo e(trans("lang.car_color_help")); ?>

                    </div>
                  </div>
                </div>
                <div class="form-group row width-50">
                  <label class="col-3 control-label"><?php echo e(trans('lang.vehicle_numberplate')); ?></label>
                  <div class="col-7">
                    <input type="text" class="form-control user_email" name="numberplate"
                      value="<?php echo e(!empty($vehicle) ? $vehicle->numberplate : ''); ?>">
                    <div class="form-text text-muted"><?php echo e(trans('lang.car_number_help')); ?></div>
                  </div>
                </div>

                <div class="form-group row width-50">
                  <label class="col-3 control-label"><?php echo e(trans('lang.number_of_pessanger')); ?></label>
                  <div class="col-7">
                    <input type="number" class="form-control user_phone" name="passenger"
                      value="<?php echo e(!empty($vehicle) ? $vehicle->passenger : ''); ?>">
                    <div class="form-text text-muted w-50">
                      <?php echo e(trans("lang.number_of_passenger_help")); ?>

                    </div>
                  </div>

                </div>
                <div class="form-group row width-50">
                  <label class="col-3 control-label"><?php echo e(trans('lang.vehicle_milage')); ?></label>
                  <div class="col-7">
                    <input type="number" class="form-control user_phone" name="milage"
                      value="<?php echo e(!empty($vehicle) ? $vehicle->milage : ''); ?>">
                    <div class="form-text text-muted w-50">

                    </div>
                  </div>

                </div>
                <div class="form-group row width-50">
                  <label class="col-3 control-label"><?php echo e(trans('lang.vehicle_km')); ?></label>
                  <div class="col-7">
                    <input type="number" class="form-control user_phone" name="km"
                      value="<?php echo e(!empty($vehicle) ? $vehicle->km : ''); ?>">
                    <div class="form-text text-muted">
                      <?php echo e(trans('lang.vehicle_km_help')); ?>

                    </div>
                  </div>

                </div>

              </fieldset>

              <fieldset>
                <legend><?php echo e(trans('lang.driver_bank_details')); ?></legend>
                <div class="form-group row width-50">
                  <label class="col-3 control-label"><?php echo e(trans('lang.bank_name')); ?></label>
                  <div class="col-7">
                    <input type="text" class="form-control address_line1" name="bank_name"
                      value="<?php echo e($driver->bank_name); ?>">
                  </div>

                </div>

                <div class="form-group row width-50">
                  <label class="col-3 control-label"><?php echo e(trans('lang.branch_name')); ?></label>
                  <div class="col-7">
                    <input type="text" class="form-control user_first_name" name="branch_name"
                      value="<?php echo e($driver->branch_name); ?>">
                    
                  </div>
                </div>

                <div class="form-group row width-50">
                  <label class="col-3 control-label"><?php echo e(trans('lang.holder_name')); ?></label>
                  <div class="col-7">
                    <input type="text" class="form-control user_last_name" name="holder_name"
                      value="<?php echo e($driver->holder_name); ?>">
                    
                  </div>
                </div>
                <div class="form-group row width-50">
                  <label class="col-3 control-label"><?php echo e(trans('lang.account_no')); ?></label>
                  <div class="col-7">
                    <input type="text" class="form-control user_email" name="account_no"
                      value="<?php echo e($driver->account_no); ?>">
                    
                  </div>
                </div>

                <div class="form-group row width-50">
                  <label class="col-3 control-label"><?php echo e(trans('lang.Other_info')); ?></label>
                  <div class="col-7">
                    <input type="text" class="form-control user_phone" name="other_info"
                      value="<?php echo e($driver->other_info); ?>">
                    
                  </div>

                </div>
                <div class="form-group row width-50">
                  <label class="col-3 control-label"><?php echo e(trans("lang.ifsc_code")); ?></label>
                  <div class="col-7">
                    <input type="text" class="form-control user_phone" name="ifsc_code" value="<?php echo e($driver->ifsc_code); ?>">

                  </div>

                </div>


              </fieldset>


            </div>
          </div>
      </div>
      <div class="form-group col-12 text-center btm-btn">
        <button type="submit" class="btn btn-primary  save_user_btn"><i class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?></button>
        <a href="<?php echo route('drivers'); ?>" class="btn btn-default"><i class="fa fa-undo"></i><?php echo e(trans('lang.cancel')); ?></a>
      </div>

    </div>
    </form>
  </div>




</div>



<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
  $(document).ready(function () {
    $('select[name="brand"]').on('change', function () {

      var brand_id = $(this).val();
      var id_type_vehicule = $('select[name="id_type_vehicule"]').val();
      var url = "<?php echo e(route('driver.model',':brandId')); ?>";
      url = url.replace(':brandId', brand_id);

      if (brand_id) {
        $.ajax({
          url: url,
          type: "POST",
          data: {
            id_type_vehicule: id_type_vehicule,
            _token: '<?php echo e(csrf_token()); ?>',
          },

          dataType: 'json',
          success: function (data) {
            $('select[name="model"]').empty();
            $('select[name="model"]').append('<option value=""><?php echo e(trans("lang.select_model")); ?></option>');
            $.each(data.model, function (key, value) {
              $('select[name="model"]').append('<option value="' + value.id + '">' + value.name + '</option>');
            });
          }
        });
      } else {
        $('select[name="model"]').empty();
      }
    });





  });

  function readURL(input) {
    console.log(input.files);
    if (input.files && input.files[0]) {
      var reader = new FileReader();

      reader.onload = function (e) {
        //	$('#image_preview').show();
        $('#uploding_image').attr('src', e.target.result);


      }

      reader.readAsDataURL(input.files[0]);
    }

  }
  function readCarURL(input) {

    if (input.files && input.files[0]) {
      var reader = new FileReader();

      reader.onload = function (e) {
        //	$('#image_preview').show();
        $('#car_image').attr('src', e.target.result);


      }

      reader.readAsDataURL(input.files[0]);
    }

  }
  function readURLNic(input) {
    console.log(input.files);
    if (input.files && input.files[0]) {
      var reader = new FileReader();

      reader.onload = function (e) {
        //$('#placeholder_img_thumb').show();
        $('#user_nic_image').attr('src', e.target.result);
      }

      reader.readAsDataURL(input.files[0]);
    }
  }

</script>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/drivers/edit.blade.php ENDPATH**/ ?>