<?php $__env->startSection('content'); ?>

<div class="page-wrapper userdetail-page">

        <div class="row page-titles">

            <div class="col-md-5 align-self-center">

                <h3 class="text-themecolor">User Detail</h3>

            </div>

            <div class="col-md-7 align-self-center">

                <ol class="breadcrumb">

                    <li class="breadcrumb-item"><a href="<?php echo url('/dashboard'); ?>">Dashboard</a></li>

                    <li class="breadcrumb-item"><a href="<?php echo url('users'); ?>">Users</a></li>

                    <li class="breadcrumb-item active">User Detail</li>

                </ol>

            </div>

        </div>

        <div class="container-fluid">

            <div class="row">

                <div class="col-12">

                    <div class="card">

                        <div class="card-body p-0 pb-5">

                           <div class="user-top">

                                <div class="row align-items-center">

									<div class="user-profile col-md-2">

										<div class="profile-img">

	                                       
                                             <?php if(file_exists(public_path('assets/images/users'.'/'.$user->photo_path)) && !empty($user->photo_path)): ?>
	                                            <td><img class="profile-pic" src="<?php echo e(asset('assets/images/users').'/'.$user->photo_path); ?>" alt="image"></td>
	                                        <?php else: ?>
	                                        <td><img class="profile-pic" src="<?php echo e(asset('assets/images/placeholder_image.jpg')); ?>" alt="image"></td>

	                                        <?php endif; ?>
										</div>

                                 	</div>
	                                <div class="user-title col-md-7">
		                                 <h4 class="card-title"> Details of <?php echo e($user->prenom); ?> <?php echo e($user->nom); ?></h4>
        	                        </div>
									<div class="col-md-3">
								<a href="javascript:void(0)" data-toggle="modal" data-target="#addWalletModal"
                               class="text-white add-wallate btn btn-success"><i class="fa fa-plus"></i> Add Wallet Amount</a>
									</div>
                               </div>
                           </div>


						<div class="user-detail" role="tabpanel">

						    <!-- Nav tabs -->
						    <ul class="nav nav-tabs">

						    	<li role="presentation" class="">
						        	<a href="#information" aria-controls="information" role="tab" data-toggle="tab" class="<?php echo e((Request::get('tab') == 'information' || Request::get('tab') == '') ? 'active show' : ''); ?>">Information</a>
						        </li>

						        <li role="presentation" class="">
						        	<a href="#rides" aria-controls="rides" role="tab" data-toggle="tab" class="<?php echo e((Request::get('tab') == 'rides') ? 'active show' : ''); ?>">Rides</a>
						        </li>

								<li role="presentation" class="">
									<a href="#parcels" aria-controls="parcels" role="tab" data-toggle="tab"
										class="<?php echo e((Request::get('tab') == 'parcels') ? 'active show' : ''); ?>"><?php echo e(trans('lang.parcel')); ?></a>
								</li>

						        <li role="presentation" class="">
						        	<a href="#transactions" aria-controls="transactions" role="tab" data-toggle="tab" class="<?php echo e((Request::get('tab') == 'transactions') ? 'active show' : ''); ?>">Wallet Transactions</a>
						        </li>


						    </ul>

						    <!-- Tab panes -->
						    <div class="tab-content">

						        <div role="tabpanel" class="tab-pane <?php echo e((Request::get('tab') == 'information' || Request::get('tab') == '') ? 'active' : ''); ?>" id="information">

						        	<div class="row">

		                                <div class="col-md-6">
		                                  <div class="col-group">
		                                    	<label for="" class="font-weight-bold"><?php echo e(trans('lang.user_phone')); ?>:</label>
		                                    	<span><?php echo e($user->phone); ?></span>
		                                	</div>
		                                </div>

		                                <div class="col-md-6">
		                                  	<div class="col-group">
		                                    	<label for="" class="font-weight-bold"><?php echo e(trans('lang.email')); ?>:</label>
		                                    	<span><?php echo e($user->email); ?></span>
		                                   	</div>
		                                </div>

		                                <div class="col-md-6">
		                                  	<div class="col-group">
		                                		<label for="" class="font-weight-bold"><?php echo e(trans('lang.status')); ?> :</label>
		                                        <?php if($user->statut=="yes"): ?>
		                                            <span class="badge badge-success">Enabled</span>
		                                        <?php else: ?>
		                                            <span class="badge badge-warning">Disabled</span>
		                                        <?php endif; ?>
		                                   </div>
		                                </div>

		                                <div class="col-md-6">
		                                   	<div class="col-group">
		                                    	<label for="" class="font-weight-bold"><?php echo e(trans('lang.created_at')); ?> :</label>
		                                    	<span class="date"><?php echo e(date('d F Y',strtotime($user->creer))); ?></span>
                                                      <span class="time"><?php echo e(date('h:i A',strtotime($user->creer))); ?></span>
		                                	</div>
		                                </div>

		                                <div class="col-md-6">
		                                  	<div class="col-group">
		                                  	  <label for="" class="font-weight-bold"><?php echo e(trans('lang.edited')); ?> :</label>
		                                    	<?php if($user->modifier!='0000-00-00 00:00:00'): ?>
                                                      <span class="date"><?php echo e(date('d F Y',strtotime($user->modifier))); ?></span>
                                                      <span class="time"><?php echo e(date('h:i A',strtotime($user->modifier))); ?></span>
                                                      <?php endif; ?>
		                                	</div>
										</div>

										<div class="col-md-6">
		                                  	<div class="col-group">
		                                  	  <label for="" class="font-weight-bold"><?php echo e(trans('lang.wallet_balance')); ?> :</label>
		                                    	<span>
													<?php if($currency->symbol_at_right=="true"): ?>
														<?php echo e(number_format($user->amount,$currency->decimal_digit)."".$currency->symbole); ?>

												
													<?php else: ?>
													<?php echo e($currency->symbole."".number_format($user->amount,$currency->decimal_digit)); ?>

													<?php endif; ?>
												</span>
		                                	</div>
										</div>

										<div class="col-md-6">
		                                    <div class="col-group">
										        <label for="" class="font-weight-bold"><?php echo e(trans('lang.rating')); ?> :</label>
													<span><i class="fa fa-star" style="color:yellow"></i> <?php echo e($userRating); ?></span>
		                                   </div>
		                                </div>

										<div class="col-md-6">
		                                    <div class="col-group-btn">
		                                        <?php if($user->statut=="no"): ?>
		                                            <a href="<?php echo e(route('users.changeStatus', ['id' => $user->id])); ?>" class="btn btn-success btn-sm" data-toggle="tooltip" data-original-title="Activate"><?php echo e(trans('lang.enable_account')); ?><i class="fa fa-check"></i> </a>
		                                        <?php else: ?>
		                                        <a href="<?php echo e(route('users.changeStatus', ['id' => $user->id])); ?>" class="btn btn-warning btn-sm" data-toggle="tooltip" data-original-title="Activate"> Disable account <i class="fa fa-check"></i> </a>
		                                        <?php endif; ?>
		                                   </div>
		                                </div>



		                             </div>

						        </div>

						        <div role="tabpanel" class="tab-pane <?php echo e(Request::get('tab') == 'rides' ? 'active' : ''); ?>" id="rides">
						        	<?php if(count($rides) > 0): ?>
						        	<div class="table-responsive">
						        		<table class="display nowrap table table-hover table-striped table-bordered table table-striped">
			                                <thead>
			                                    <tr>
			                                        <th><?php echo e(trans('lang.ride_id')); ?></th>
			                                        <th><?php echo e(trans('lang.driver_name')); ?></th>
			                                        <!-- <th ><?php echo e(trans('lang.depart')); ?></th>
			                                        <th ><?php echo e(trans('lang.destination')); ?></th> -->
			                                        <th ><?php echo e(trans('lang.status')); ?></th>
			                                        <th ><?php echo e(trans('lang.created')); ?></th>
			                                        <th><?php echo e(trans('lang.actions')); ?></th>
			                                    </tr>
			                                </thead>
			                                <tbody id="append_list12">
			                                    <?php $__currentLoopData = $rides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ride): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			                                    <tr>
			                                        <td><a href="<?php echo e(route('ride.show', ['id' => $ride->id])); ?>"><?php echo e($ride->id); ?></a></td>
                                                    <td><a href="<?php echo e(route('driver.show', ['id' => $ride->driver_id])); ?>"><?php echo e($ride->driverPrenom); ?> <?php echo e($ride->driverNom); ?></a></td>
			                                        <!-- <td><?php echo e($ride->depart_name); ?></td>
			                                        <td><?php echo e($ride->destination_name); ?></td> -->
			                                        <td>
			                                        	<?php if($ride->statut=="completed"): ?>
			                                                <span class="badge badge-success"><?php echo e($ride->statut); ?><span>
			                                            <?php elseif($ride->statut=="rejected"): ?>
			                                                <span class="badge badge-danger"><?php echo e($ride->statut); ?><span>
			                                            <?php else: ?>
			                                                <span class="badge badge-warning"><?php echo e($ride->statut); ?><span>
			                                            <?php endif; ?>
			                                        </td>
			                                        <td><?php echo e(date('d F Y h:i A',strtotime($ride->creer))); ?></td>
			                                        <td class="action-btn">
			                                        	<a href="<?php echo e(route('ride.show', ['id' => $ride->id])); ?>" class="" data-toggle="tooltip" data-original-title="Details"><i class="fa fa-ellipsis-h"></i></a>
														<a id="'+val.id+'"
                                                   class="do_not_delete"
                                                   name="user-delete"
                                                   href="<?php echo e(route('ride.delete', ['rideid' => $ride->id])); ?>"><i
                                                            class="fa fa-trash"></i></a>
													</td>
			                                    </tr>
			                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			                                </tbody>
			                            </table>
			                            <nav aria-label="Page navigation example" class="custom-pagination">
                                    		<?php echo e($rides->appends(['tab'=>'rides'])->links()); ?>

                                		</nav>
									</div>
									<?php else: ?>
						        		<p><center>No results found.</center></p>
									<?php endif; ?>
						        </div>
								<div role="tabpanel"
									class="tab-pane <?php echo e(Request::get('tab') == 'parcels' ? 'active' : ''); ?>"
									id="parcels">
									<?php if(count($parcelOrders) > 0): ?>
									<div class="table-responsive">
										<table
											class="display nowrap table table-hover table-striped table-bordered table table-striped">
											<thead>
												<tr>
													<th><?php echo e(trans('lang.parcel_id')); ?></th>
													<th><?php echo e(trans('lang.driver_name')); ?></th>
													<th><?php echo e(trans('lang.status')); ?></th>
													<th><?php echo e(trans('lang.created')); ?></th>
													<th><?php echo e(trans('lang.actions')); ?></th>
												</tr>
											</thead>
											<tbody id="append_list12">
												<?php $__currentLoopData = $parcelOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parcel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<tr>
													<td><a href="<?php echo e(route('parcel.show', ['id' => $parcel->id])); ?>"><?php echo e($parcel->id); ?></a></td>
													<td><a href="<?php echo e(route('driver.show', ['id' => $parcel->driver_id])); ?>"><?php echo e($parcel->driverPrenom); ?> <?php echo e($parcel->driverNom); ?></a></td>
													<td>
														<?php if($parcel->status=="completed"): ?>
														<span class="badge badge-success"><?php echo e($parcel->status); ?><span>
																<?php elseif($parcel->status == "confirmed"): ?>
																<span class="badge badge-success"><?php echo e($parcel->status); ?><span>
																		<?php elseif($parcel->status == "new"): ?>
																		<span class="badge badge-primary"><?php echo e($parcel->status); ?><span>
																				<?php elseif($parcel->status=="rejected"): ?>
																				<span class="badge badge-danger"><?php echo e($parcel->status); ?><span>
																						<?php elseif($parcel->status=="driver_rejected"): ?>
																						<span
																							class="badge badge-danger"><?php echo e(trans("lang.driver_rejected")); ?><span>
																								<?php else: ?>
																								<span
																									class="badge badge-warning"><?php echo e($parcel->status); ?><span>
																										<?php endif; ?>
													</td>
													<td><?php echo e(date('d F Y h:i A',strtotime($parcel->created_at))); ?></td>
													<td class="action-btn">
														<a href="<?php echo e(route('parcel.show', ['id' => $parcel->id])); ?>"
															class="" data-toggle="tooltip"
															data-original-title="Details"><i
																class="fa fa-ellipsis-h"></i></a>
														<a id="'+val.id+'" class="do_not_delete" name="user-delete"
															href="<?php echo e(route('parcel.delete', ['rideid' => $parcel->id])); ?>"><i
																class="fa fa-trash"></i></a>
													</td>
												</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</tbody>
										</table>
										<nav aria-label="Page navigation example" class="custom-pagination">
											<?php echo e($parcelOrders->appends(['tab'=>'parcels'])->links()); ?>


										</nav>
										<?php echo e($parcelOrders->appends(['tab'=>'parcels'])->links('pagination.pagination')); ?>


									</div>
									<?php else: ?>
									<p>
										<center>No results found.</center>
									</p>
									<?php endif; ?>
								</div>


								<div role="tabpanel" class="tab-pane <?php echo e(Request::get('tab') == 'transactions' ? 'active' : ''); ?>" id="transactions">
						        	<?php if(count($transactions) > 0): ?>
						        	<div class="table-responsive">
			                            <table class="display nowrap table table-hover table-striped table-bordered table table-striped">
			                                <thead>
			                                    <tr>
			                                    	<th><?php echo e(trans('lang.transaction_id')); ?></th>
			                                        <th><?php echo e(trans('lang.amount')); ?></th>
                                                	<th><?php echo e(trans('lang.date')); ?></th>
                                                	<th><?php echo e(trans('lang.payment_method')); ?></th>
                                                	<th><?php echo e(trans('lang.status')); ?></th>
			                                    </tr>
			                                </thead>
			                                <tbody id="append_list12">
			                                    <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<tr>
													<td><?php echo e($transaction->id); ?></td>
			                                        
														<?php if($currency->symbol_at_right=="true"): ?>
														<?php if($transaction->deduction_type=="0"): ?>
														<td style="color:red">(-<?php echo e(number_format($transaction->amount,$currency->decimal_digit).$currency->symbole); ?>)</td>
														<?php else: ?>
														<td style="color:green"><?php echo e(number_format($transaction->amount,$currency->decimal_digit).$currency->symbole); ?></td>
														<?php endif; ?>
														<?php else: ?>
														<?php if($transaction->deduction_type=="0"): ?>
														<td style="color:red">(-<?php echo e($currency->symbole."".number_format($transaction->amount,$currency->decimal_digit)); ?>)</td>
														<?php else: ?>
														<td style="color:green"><?php echo e($currency->symbole."".number_format($transaction->amount,$currency->decimal_digit)); ?></td>
														<?php endif; ?>
														<?php endif; ?>
													</td>
			                                        <td><?php echo e(date('d F Y h:i A',strtotime($transaction->creer))); ?></td>
													   
													<?php if($transaction->image): ?>
                                                        <td><img class="rounded" style="width:50px"
                                                            src="<?php echo e(asset('/assets/images/payment_method/'.$transaction->image)); ?>"
                                                            alt="image"></td>
														<?php else: ?>
														<td><?php echo e($transaction->payment_method); ?>"</td>
                                                        <?php endif; ?>

			                                        <td>
			                                        	<?php if($transaction->deduction_type == 1): ?>
			                                                <span class="badge badge-success">Credit<span>
			                                            <?php else: ?>
			                                                <span class="badge badge-warning">Debit<span>
			                                            <?php endif; ?>
			                                        </td>
			                                    </tr>
			                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			                                </tbody>
			                            </table>
			                            <nav aria-label="Page navigation example" class="custom-pagination">
                                    		<?php echo e($transactions->appends(['tab'=>'transactions'])->links()); ?>

                                		</nav>
									</div>
									<?php else: ?>
						        		<p><center>No results found.</center></p>
									<?php endif; ?>
						        </div>

						    </div>

						</div>

					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<div class="modal fade" id="addWalletModal" tabindex="-1" role="dialog" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered location_modal">

        <div class="modal-content">

            <div class="modal-header">

                <h5 class="modal-title locationModalTitle"><?php echo e(trans('lang.add_wallet_amount')); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>

            </div>

            <div class="modal-body">

                <form action="<?php echo e(route('user.wallet',$user->id)); ?>" method="post" class="">
				<?php echo csrf_field(); ?>

                    <div class="form-row">

                        <div class="form-group row">

                            <div class="form-group row width-100">
                                <label class="col-12 control-label"><?php echo e(trans('lang.amount')); ?></label>
                                <div class="col-12">
                                    <input type="number" name="amount" class="form-control" id="amount" placeholder="Enter Amount">
                                    <div id="wallet_error" style="color:red"></div>
                                </div>
                            </div>

                        </div>

                    </div>


                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" id="add-wallet-btn"><?php echo e(trans('submit')); ?></a>
                    </button>
                    <button type="button" class="btn btn-primary" data-dismiss="modal" aria-label="Close">
                        <?php echo e(trans('close')); ?></a>
                    </button>

                </div>
			</form>


            </div>
        </div>

    </div>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
	$("#add-wallet-btn").click(function () {
		var amount = $('#amount').val();
        if(amount==''){
            $('#wallet_error').text('<?php echo e(trans("lang.add_wallet_amount_error")); ?>');
            return false;
        }

	});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/settings/users/show.blade.php ENDPATH**/ ?>