<?php $__env->startSection('content'); ?>

<div class="page-wrapper userdetail-page">

	<div class="row page-titles">

		<div class="col-md-5 align-self-center">

			<h3 class="text-themecolor"><?php echo e(trans('lang.coupon_detail')); ?></h3>

		</div>

		<div class="col-md-7 align-self-center">

			<ol class="breadcrumb">

				<li class="breadcrumb-item"><a href="<?php echo url('/dashboard'); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>

				<li class="breadcrumb-item"><a href="<?php echo url('coupons'); ?>"><?php echo e(trans('lang.coupon_plural')); ?></a></li>

				<li class="breadcrumb-item active"><?php echo e(trans('lang.coupon_detail')); ?></li>

			</ol>

		</div>

	</div>

	<div class="container-fluid">

		<div class="row">

			<div class="col-12">

				<?php if($errors->any()): ?>
				<div class="alert alert-danger">
					<ul>
						<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<li class="error"><?php echo e($error); ?></li>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</ul>
				</div>
				<?php endif; ?>

				<div class="card">

					<div class="card-body p-0 pb-5">

						<div class="user-top">

							<div class="row align-items-center">


								<div class="user-title col-md-8">
									<h4 class="card-title"> Details of <?php echo e($discount->code); ?></h4>
								</div>
							</div>
						</div>


						<div class="user-detail" role="tabpanel">

							<!-- Nav tabs -->
							<ul class="nav nav-tabs">

								<li role="presentation" class="">
									<a href="#information" aria-controls="information" role="tab" data-toggle="tab" class="<?php echo e((Request::get('tab') == 'information' || Request::get('tab') == '') ? 'active show' : ''); ?>">Information</a>
								</li>



							</ul>

							<!-- Tab panes -->
							<div class="tab-content">

								<div role="tabpanel" class="tab-pane <?php echo e((Request::get('tab') == 'information' || Request::get('tab') == '') ? 'active' : ''); ?>" id="information">

									<div class="row">



										<div class="col-md-6">
											<div class="col-group">
												<label for="" class="font-weight-bold"><?php echo e(trans('lang.coupon_code')); ?>:</label>
												<span><?php echo e($discount->code); ?></span>
											</div>
										</div>

										<div class="col-md-6">
											<div class="col-group">
												<label for="" class="font-weight-bold"><?php echo e(trans('lang.coupon_discount')); ?>:</label>
												<span><?php echo e($discount->discount ?? '-'); ?> </span>
											</div>
										</div>
										<div class="col-md-6">
											<div class="col-group">
												<label for="" class="font-weight-bold"><?php echo e(trans('lang.type')); ?>:</label>
												<span><?php echo e($discount->type); ?></span>
											</div>
										</div>

										<div class="col-md-6">
											<div class="col-group">
												<label for="" class="font-weight-bold"><?php echo e(trans('lang.title')); ?>:</label>
												<span><?php echo e($discount->title); ?></span>
											</div>
										</div>


										<div class="col-md-6">
											<div class="col-group">
												<label for="" class="font-weight-bold"><?php echo e(trans('lang.coupon_description')); ?>:</label>
												<span><?php echo e($discount->discription); ?></span>
											</div>
										</div>

										<div class="col-md-6">
											<div class="col-group">
												<label for="" class="font-weight-bold"><?php echo e(trans('lang.apply_for')); ?>:</label>
												<span><?php echo e($discount->apply_for); ?></span>
											</div>
										</div>




										<div class="col-md-6">
											<div class="col-group">
												<label for="" class="font-weight-bold"><?php echo e(trans('lang.coupon_expires_at')); ?>:</label>
												<?php if($discount->expire_at!='0000-00-00 00:00:00'): ?>
												<span class="date"><?php echo e(date('d F Y',strtotime($discount->expire_at))); ?></span>
												<span class="time"><?php echo e(date('h:i A',strtotime($discount->expire_at))); ?></span>
												<?php endif; ?>
											</div>
										</div>
										<div class="col-md-6">
											<div class="col-group">
												<label for="" class="font-weight-bold"><?php echo e(trans('lang.coupon_type')); ?>:</label>
												<span><?php echo e($discount->coupon_type); ?></span>
											</div>
										</div>
										<div class="col-md-12">
											<div class="col-group-btn">
												<?php if($discount->statut=="yes"): ?>
												<a href="<?php echo e(route('coupons.changeStatus', ['id' => $discount->id])); ?>" class="btn btn-success btn-sm" data-toggle="tooltip" data-original-title="Activate">Enable<i class="fa fa-check"></i> </a>
												<?php else: ?>
												<a href="<?php echo e(route('coupons.changeStatus', ['id' => $discount->id])); ?>" class="btn btn-warning btn-sm" data-toggle="tooltip" data-original-title="Activate"> Disable<i class="fa fa-check"></i> </a>
												<?php endif; ?>
											</div>
										</div>
										<br>

										<?php if($slabs->count()): ?>
										<!-- <div class="row mt-4"> -->
										<div class="mt-4 col-md-12">
											<h5 class="font-weight-bold">Discount Slabs</h5>

											<table class="table table-bordered">
												<thead>
													<tr>
														<th>#</th>
														<th>Minimum Ride Amount</th>
														<th>Discount</th>
														<!-- <th>Type</th> -->
													</tr>
												</thead>
												<tbody>
													<?php $__currentLoopData = $slabs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $slab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<tr>
														<td><?php echo e($i+1); ?></td>
														<td>₹<?php echo e(number_format($slab->min_ride_amount,2)); ?></td>
														<td><?php echo e($slab->discount_amount); ?></td>
														<!-- <td><?php echo e(ucfirst($slab->discount_type)); ?></td> -->
													</tr>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</tbody>
											</table>
										</div>
										<!-- </div> -->
										<?php endif; ?>



									</div>

								</div>



							</div>

						</div>

					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/coupons/show.blade.php ENDPATH**/ ?>