<?php $__env->startSection('content'); ?>
    <div class="page-wrapper">
        <!-- ============================================================== -->
        <!-- Bread crumb and right sidebar toggle -->
        <!-- ============================================================== -->
        <div class="row page-titles">
            <div class="col-md-5 align-self-center">
                <h3 class="text-themecolor"><?php echo e(trans('lang.vehicle_renting')); ?></h3>
            </div>
            <div class="col-md-7 align-self-center">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a>
                    </li>
                    <li class="breadcrumb-item active">
                        <?php echo e(trans('lang.vehicle_rent')); ?>

                    </li>
                </ol>
            </div>
            <div></div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">

                        <div class="card-body">

                            <div id="data-table_processing" class="dataTables_processing panel panel-default"
                                 style="display: none;">
                                <?php echo e(trans('lang.processing')); ?>

                            </div>

                            <div class="userlist-topsearch d-flex mb-3">

                                <div id="users-table_filter" class="ml-auto">

                                <!-- <select name="selected_search" id="selected_search" class="form-control input-sm">
									<option value="first_name"><?php echo e(trans('lang.first_name')); ?></option>
									<option value="last_name"><?php echo e(trans('lang.last_name')); ?></option>
									<option value="email"><?php echo e(trans('lang.email')); ?></option>
									</select> --> <!-- <input type="search" id="search" class="search form-control" placeholder="Search"
									aria-controls="users-table">
									</label>&nbsp;<button onclick="searchtext();"
									class="btn btn-warning btn-flat">Search</button>&nbsp;<button onclick="searchclear();"
									class="btn btn-warning btn-flat">Clear</button> -->
                                    <label><?php echo e(trans('lang.search_by')); ?>

                                    <div class="form-group mb-0">
                                        <form action="<?php echo e(route('vehicle-rent')); ?>" method="get">

                                            <?php if(isset($_GET['selected_search']) &&  $_GET['selected_search'] != ''): ?>
                                                <select name="selected_search" id="selected_search"
                                                        class="form-control input-sm">
                                                    <option value="vehicle_type" <?php if($_GET[
                                            'selected_search']=='vehicle_type'): ?>
                                            selected="selected" <?php endif; ?>><?php echo e(trans('lang.vehicle_type')); ?></option>
                                                    <option value="customer" <?php if($_GET[
                                            'selected_search']=='customer'): ?>
                                            selected="selected" <?php endif; ?>><?php echo e(trans('lang.customer')); ?></option>
                                                </select>
                                            <?php else: ?>
                                                <select name="selected_search" id="selected_search"
                                                        class="form-control input-sm">
                                                    <option value="vehicle_type	"><?php echo e(trans('lang.vehicle_type')); ?></option>
                                                    <option value="customer"><?php echo e(trans('lang.customer')); ?></option>
                                                </select>
                                            <?php endif; ?>
                                            <div class="search-box position-relative">
                                                <?php if(isset($_GET['search']) &&  $_GET['search'] != ''): ?>
                                                    <input type="text" class="search form-control" name="search"
                                                           id="search" value="<?php echo e($_GET['search']); ?>">
                                                <?php else: ?>
                                                    <input type="text" class="search form-control" name="search"
                                                           id="search">
                                                <?php endif; ?>
                                                <button type="submit" class="btn-flat position-absolute"><i
                                                            class="fa fa-search"></i></button>
                                                <!-- <input type="search" id="search" class="search form-control" placeholder="Search" aria-controls="users-table"></label>&nbsp;<button onclick="searchtext();" class="btn btn-warning btn-flat">Search</button>&nbsp; -->
                                                <!-- <button onclick="searchclear();" class="btn btn-warning btn-flat">Clear</button> -->
                                                <a class="btn btn-warning btn-flat"
                                                   href="<?php echo e(url('vehicle/vehicle-rent')); ?>">Clear</a>
                                            </div>
                                        </form>

                                    </div>
                                    </label>
                                </div>
                            </div>
                            <div class="table-responsive m-t-10">
                                <table id="example24"
                                       class="display nowrap table table-hover table-striped table-bordered table table-striped"
                                       cellspacing="0" width="100%">
                                    <thead>
                                    <tr>
                                        <th class="delete-all"><input type="checkbox" id="is_active"><label
                                                    class="col-3 control-label" for="is_active"><a id="deleteAll"
                                                                                                   class="do_not_delete"
                                                                                                   href="javascript:void(0)"><i
                                                            class="fa fa-trash"></i> All</a></label></th>
                                        <th><?php echo e(trans('lang.vehicle_type')); ?></th>
                                        <th><?php echo e(trans('lang.customer')); ?></th>
                                        <th><?php echo e(trans('lang.number_of_days')); ?></th>
                                        <th><?php echo e(trans('lang.start_date')); ?></th>
                                        <th><?php echo e(trans('lang.end_date')); ?></th>
                                        <th><?php echo e(trans('lang.contact')); ?></th>
                                        <th><?php echo e(trans('lang.status')); ?></th>
                                        <th><?php echo e(trans('lang.created_at')); ?></th>
                                        <th><?php echo e(trans('lang.modified_at')); ?></th>
                                        <th><?php echo e(trans('lang.actions')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody id="append_list12">
									 <?php if(count($rentals) > 0): ?>
                                    <?php $__currentLoopData = $rentals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rental): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="delete-all"><input type="checkbox"
                                                                          id="is_open_<?php echo e($rental->id); ?>"
                                                                          class="is_open"
                                                                          dataid="<?php echo e($rental->id); ?>"><label
                                                        class="col-3 control-label"
                                                        for="is_open_<?php echo e($rental->id); ?>"></label></td>
                                            <td><?php echo e($rental->libelle); ?></td>
                                            <td><?php echo e($rental->prenom); ?></td>
                                            <td><?php echo e($rental->nb_jour); ?></td>
                                            <td><span class="date"><?php echo e(date('d F Y',strtotime($rental->date_debut))); ?></span></td>
                                            <td><span class="date"><?php echo e(date('d F Y',strtotime($rental->date_fin))); ?></span></td>
                                            <td><?php echo e(!empty($rental->contact) ? $rental->contact : '-'); ?></td>

                                            <td><?php if($rental->statut=="in progress"): ?>
                                                    <span class="badge badge-success"><?php echo e($rental->statut); ?><span> <?php else: ?>
                                                            
                                                                <span class="badge badge-warning"><?php echo e($rental->statut); ?><span> <?php endif; ?>
                                            </td>
                                             <td class="dt-time"><span class="date"><?php echo e(date('d F Y',strtotime($rental->creer))); ?></span>
                                                <span class="time"><?php echo e(date('h:i A',strtotime($rental->creer))); ?></span>
                                             </td>
                                             <td class="dt-time"><span class="date"><?php echo e(date('d F Y',strtotime($rental->modifier))); ?></span>
                                                <span class="time"><?php echo e(date('h:i A',strtotime($rental->modifier))); ?></span>
                                             </td>


                                            <td class="action-btn">
                                                <a href="<?php echo e(route('vehicle-rent.show', ['id' => $rental->id])); ?>" class=""
                                                   data-toggle="tooltip" data-original-title="Details"><i
                                                            class="fa fa-eye"></i></a>
                                                <a id="'+val.id+'" class="do_not_delete"
                                                   href="<?php echo e(route('vehicle-rent.delete', ['id' => $rental->id])); ?>"><i
                                                            class="fa fa-trash"></i></a>


                                            </td>


                                        </tr>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                     <?php else: ?>
                                		<tr><td colspan="11" align="center"><?php echo e(trans("lang.no_result")); ?></td></tr>
                                	<?php endif; ?>

                                    </tbody>
                                </table>
                                <nav aria-label="Page navigation example" class="custom-pagination">
                                    <?php echo e($rentals->appends(request()->query())->links()); ?>

                                </nav>
                                <?php echo e($rentals->links('pagination.pagination')); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

    <script type="text/javascript">
        $(document).ready(function () {
            $(".shadow-sm").hide();
        })

        $("#is_active").click(function () {
            $("#example24 .is_open").prop('checked', $(this).prop('checked'));

        });

        $("#deleteAll").click(function () {
            if ($('#example24 .is_open:checked').length) {
                
                if (confirm('Are You Sure want to Delete Selected Data ?')) {
                    var arrayUsers = [];
                    $('#example24 .is_open:checked').each(function () {
                        var dataId = $(this).attr('dataId');
                        arrayUsers.push(dataId);

                    });

                    arrayUsers = JSON.stringify(arrayUsers);
                    var url = "<?php echo e(url('vehicle/vehicle-rent/delete', 'id')); ?>";
                    url = url.replace('id', arrayUsers);

                    $(this).attr('href', url);
                }
            } else {
                alert('Please Select Any One Record .');
            }
        });
       
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/vehicle/vehicle-rent.blade.php ENDPATH**/ ?>