
<style>
    .vehicle-card {
        cursor: pointer;
    }

    .vehicle-radio {
        display: none;
    }

    .vehicle-radio:checked+.card {
        border: 2px solid #007bff;
        box-shadow: 0 0 10px rgba(0, 123, 255, 0.5);
    }
</style>



<?php $__env->startSection('content'); ?>

<div class="page-wrapper">

    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor"><?php echo e(trans('lang.create_rental_ride')); ?></h3>
        </div>

        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                <li class="breadcrumb-item active"><?php echo e(trans('lang.create_rental_ride')); ?></li>
            </ol>
        </div>
    </div>

    <div class="container-fluid">

        <div class="row">
            <div class="col-12">
                <div class="card pb-4">

                    <div class="card-body">

                        <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display:none;">
                            <?php echo e(trans('lang.processing')); ?>

                        </div>

                        <div class="error_top"></div>

                        <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <?php endif; ?>

                        <form action="<?php echo e(route('admin.request.rental.register')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <div class="row restaurant_payout_create">
                                <div class="restaurant_payout_create-inner">

                                    <fieldset>
                                        <legend><?php echo e(trans('lang.create_rental_ride')); ?></legend>


                                        
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label">Source</label>
                                            <div class="col-7">
                                                <input type="text" id="source" name="source" class="form-control" placeholder="Enter source location" autocomplete="off" required>
                                                <input type="hidden" name="lat1" id="source_lat">
                                                <input type="hidden" name="lng1" id="source_lng">
                                            </div>
                                        </div>



                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label">Customer Name</label>
                                            <div class="col-7">
                                                <select name="user_id" id="customer_id" class="form-control" required>
                                                    <option value="">-- Select Customer --</option>
                                                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($customer->id); ?>"
                                                        <?php echo e(old('user_id') == $customer->id ? 'selected' : ''); ?>>
                                                        <!-- <?php echo e($customer->nom); ?> <?php echo e($customer->prenom); ?> -->
                                                          <?php echo e($customer->phone); ?> - <?php echo e($customer->prenom); ?>  <?php echo e($customer->nom); ?>

                                                    </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label">Rental Package</label>
                                            <div class="col-7">
                                                <select name="rental_package_id" id="rental_package_id" class="form-control" required>
                                                    <option value="">-- Select Rental Package --</option>

                                                    <?php $__currentLoopData = $rental_package; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($package->id); ?>"
                                                        <?php echo e(old('rental_package_id') == $package->id ? 'selected' : ''); ?>>
                                                        <?php echo e($package->hours); ?> Hour <?php echo e($package->kilometers); ?> Km
                                                    </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </select>
                                            </div>
                                        </div>

                                        <div class="row" id="vehicle_list"></div>


                                        
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label">Total Amount</label>
                                            <div class="col-7">
                                                <input type="number" name="cout" id="cout" class="form-control" value="<?php echo e(old('cout')); ?>" readonly>
                                            </div>
                                        </div>


                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label">Ride Type</label>
                                            <div class="col-7">
                                                <select name="ride_type" id="ride_type" class="form-control" required>
                                                    <option value="">-- Select Ride Type --</option>
                                                    <option value="instant">Instant Ride</option>
                                                    <option value="scheduled">Scheduled Ride</option>
                                                </select>
                                            </div>
                                        </div>


                                        <div id="normal_section" style="display:none;">

                                            
                                            <div class="form-group row width-50">
                                                <label class="col-3 control-label"> Date </label>
                                                <div class="col-7">
                                                    <input type="date" id="date" name="date" class="form-control" value="<?php echo e(old('date')); ?>">
                                                </div>
                                            </div>

                                            
                                            <div class="form-group row width-50">
                                                <label class="col-3 control-label"> Hour</label>
                                                <div class="col-7">
                                                    <input type="time" id="hour" name="hour" class="form-control" value="<?php echo e(old('hour')); ?>">
                                                </div>
                                            </div>

                                        </div>


                                    </fieldset>

                                </div>
                            </div>

                            <div class="form-group col-12 text-center btm-btn">
                                <button type="submit" class="btn btn-primary save_user_btn">
                                    <i class="fa fa-save"></i> <?php echo e(trans('lang.save')); ?>

                                </button>

                            </div>


                            <input type="hidden" name="cout" id="cout_hidden">

                        </form>

                    </div>

                </div>
            </div>
        </div>

    </div>

</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>

<!-- ADD FLATPICKR LINKS HERE -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script>
    let sourceLat, sourceLng, destinationLat, destinationLng;
    let selectedVehicleData = null;




    function initAutocompleteInit() {
        initAutocomplete();
    }

    /* -----------------------------
       SOURCE & DESTINATION
    ------------------------------ */
    function initAutocomplete() {

        // SOURCE
        const sourceAuto = new google.maps.places.Autocomplete($("#source")[0]);
        sourceAuto.addListener("place_changed", () => {
            let place = sourceAuto.getPlace();
            if (!place.geometry) return;

            sourceLat = place.geometry.location.lat();
            sourceLng = place.geometry.location.lng();
            $("#source_lat").val(sourceLat);
            $("#source_lng").val(sourceLng);

            resetFields();

            if (destinationLat && destinationLng) calculateDistanceDuration();
        });


        $("#source, #destination").on("change", resetFields);

    }

    function resetFields() {
        $("#rental_package_id").val('');
        $("#cout").val('');
        $(".vehicledata").remove();
    }
</script>

<script type="text/javascript">
    $(document).ready(function() {

        $("#rental_package_id").val('');

        function updateSections() {
            let rideType = $("#ride_type").val();
            let roundTrip = $("#round_trip").val();

            // Always show return section only if round trip
            if (roundTrip === "Yes") {
                $("#return_section").show();

                // For round trips → date & hour must ALWAYS be shown
                $("#normal_section").show();
                $("#ride_type").val('scheduled');

            } else {
                $("#return_section").hide();
                $("#return_date, #return_hour").val("");

                // When NOT round trip → follow ride type
                if (rideType === "scheduled") {
                    $("#normal_section").show();
                } else {
                    $("#normal_section").hide();
                    $("#date, #hour").removeAttr("required");
                    pickupDate.clear();
                    pickupTime.clear();
                }
            }
        }

        $("#ride_type, #round_trip").on("change", updateSections);

        $('#customer_id').select2({
            placeholder: "-- Select Customer --",
            allowClear: true,
            width: '100%'
        });


        // MAIN DATE
        let pickupDate = $("#date").flatpickr({
            dateFormat: "Y-m-d",
            minDate: "today",
            onChange: function(selectedDates, dateStr) {
                updateMinTime("#hour", dateStr);
                $("#hour").val("");
            }
        });

        // RETURN DATE
        let returnDate = $("#return_date").flatpickr({
            dateFormat: "Y-m-d",
            minDate: "today",
            onChange: function(selectedDates, dateStr) {
                updateMinTime("#return_hour", dateStr);
                $("#return_hour").val("");
            }
        });

        // MAIN TIME PICKER
        let pickupTime = $("#hour").flatpickr({
            enableTime: true,
            noCalendar: true,
            dateFormat: "H:i",
            time_24hr: true,
            minuteIncrement: 1,
        });

        // RETURN TIME PICKER
        let returnTime = $("#return_hour").flatpickr({
            enableTime: true,
            noCalendar: true,
            dateFormat: "H:i",
            time_24hr: true,
            minuteIncrement: 1,
        });

        function getMinTime() {
            let now = new Date();
            if ($("#round_trip").val() == 'Yes') {
                now.setMinutes(now.getMinutes() + 0);
            } else {
                now.setMinutes(now.getMinutes() + 5);
            }



            let h = now.getHours().toString().padStart(2, "0");
            let m = now.getMinutes().toString().padStart(2, "0");

            return `${h}:${m}`;
        }

        /**
         * Update minTime based on selected date
         */
        function updateMinTime(selector, selectedDate) {
            let today = new Date().toISOString().split("T")[0];

            let fp = $(selector)[0]._flatpickr;

            if (selectedDate === today) {
                fp.set("minTime", getMinTime());
            } else {
                fp.set("minTime", "00:00");
            }
        }


        $(document).on('change', '.vehicle-radio', function() {
            let price = $(this).data('price');

            $('#cout').val(price);
            $('#cout_hidden').val(price);
        });


        $(document).on('change', '#rental_package_id', function() {

            let package_id = $(this).val();
            let latitude = $('#source_lat').val();
            let longitude = $('#source_lng').val();

            if (!package_id || !latitude || !longitude) {
                alert('Please select source & destination first');
                return;
            }

            $.ajax({
                url: "<?php echo e(route('vehicle.by.package')); ?>",
                type: "POST",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    package_id: package_id,
                    latitude: latitude,
                    longitude: longitude
                },
                beforeSend: function() {
                    $('#vehicle_list').html('<p>Loading vehicles...</p>');
                },
                success: function(response) {

                    if (response.success === 'success') {

                        let html = '';

                        $.each(response.data, function(index, vehicle) {

                            html += `
                            <div class="col-md-4 mb-3 vehicledata">
                                <label class="vehicle-card w-100">
                                    <input type="radio"
                                        name="vehicle_id"
                                        value="${vehicle.id}"
                                        data-price="${vehicle.price}"
                                        class="vehicle-radio"
                                        >

                                    <div class="card">
                                        <img src="${vehicle.image}" class="card-img-top" height="150">
                                        <div class="card-body">
                                            <h6>${vehicle.libelle ?? 'Vehicle'}</h6>
                                            <p>${vehicle.description}</p>
                                            <p><strong>Price:</strong> ₹${vehicle.price}</p>
                                            <p><strong>ETA:</strong> ${vehicle.distance}</p>
                                        </div>
                                    </div>
                                </label>
                            </div>`;
                        });

                        $('#vehicle_list').html(html);

                    } else {
                        $('#vehicle_list').html(`<p class="text-danger">${response.error}</p>`);
                    }
                }

            });
        });

    });
</script>



<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBcVT2oJEsWpE6hDKU1M5791Q6jRQ4KUgI&libraries=places&callback=initAutocompleteInit"
    async defer></script>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/admin/request/create_rental.blade.php ENDPATH**/ ?>