<?php $__env->startSection('content'); ?>
        <div class="page-wrapper">

            <div class="row page-titles">

                <div class="col-md-5 align-self-center">

                    <h3 class="text-themecolor"><?php echo e(trans('lang.administration_tools_country')); ?></h3>

                </div>

                <div class="col-md-7 align-self-center">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(trans('lang.administration_tools')); ?></li>
                        <li class="breadcrumb-item active"><?php echo e(trans('lang.administration_tools_country')); ?></li>
                    </ol>
                </div>

            </div>



            <div class="container-fluid">

                <div class="row">

                    <div class="col-12">

                        <div class="card">

                        <div class="card-body">
                        <div class="userlist-topsearch d-flex mb-3">
                                 <div class="userlist-top-left">
                                 <a class="nav-link do_not_create" href="<?php echo e(route('country.create')); ?>" ><i class="fa fa-plus mr-2"></i><?php echo e(trans('lang.country_create')); ?></a>
                                </div>
                            <div id="users-table_filter" class="ml-auto">
                              <label><?php echo e(trans('lang.search_by')); ?>

                                <div class="form-group mb-0">

                                    <form action="<?php echo e(route('country')); ?>" method="get">
                                        <?php if(isset($_GET['selected_search']) &&  $_GET['selected_search'] != ''): ?>
                                        <select name="selected_search" id="selected_search" class="form-control input-sm">
                                        <option value="libelle" <?php if($_GET['selected_search']=='libelle'): ?>
                                    selected="selected" <?php endif; ?>><?php echo e(trans('lang.Name')); ?></option>
                                        <option value="code" <?php if($_GET['selected_search']=='code'): ?>
                                    selected="selected" <?php endif; ?>><?php echo e(trans('lang.code')); ?></option>
                                        </select>
                                        <?php else: ?>
                                        <select name="selected_search" id="selected_search" class="form-control input-sm">
                                        <option value="libelle"><?php echo e(trans('lang.Name')); ?></option>
                                        <option value="code"><?php echo e(trans('lang.code')); ?></option>
                                    </select>
                                    <?php endif; ?>
                                    <div class="search-box position-relative">
                                        <?php if(isset($_GET['search']) &&  $_GET['search'] != ''): ?>
                                        <input type = "text" class="search form-control" name="search" id = "search" value="<?php echo e($_GET['search']); ?>">
                                        <?php else: ?>
                                        <input type = "text" class="search form-control" name="search" id = "search">
                                        <?php endif; ?>
                                        <button type="submit" class="btn-flat position-absolute"><i class="fa fa-search"></i></button>
                                        <a class="btn btn-warning btn-flat" href="<?php echo e(url('administration_tools/country')); ?>">Clear</a>
                                    </div>
                                    </form>
                                </div>
                               </label>
                            </div>
                        </div>

                                <div class="table-responsive m-t-10">

                                    <table id="example24" class="display nowrap table table-hover table-striped table-bordered table table-striped" cellspacing="0" width="100%">

                                        <thead>

                                            <tr>

                                                <th><?php echo e(trans('lang.country_name')); ?></th>
                                                <th><?php echo e(trans('lang.country_code')); ?></th>
                                                <th><?php echo e(trans('lang.country_status')); ?></th>
                                                <th><?php echo e(trans('lang.country_created')); ?></th>
                                                <th><?php echo e(trans('lang.country_modified')); ?></th>
                                                <th><?php echo e(trans('lang.actions')); ?></th>

                                            </tr>

                                        </thead>

                                        <tbody id="append_list1">
                                         <?php if(count($countries) > 0): ?>
                                            <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($country->libelle); ?></td>
                                                <td><?php echo e($country->code); ?></td>
                                                <td>
                                                    <?php if($country->statut=="yes"): ?>
                                                        <label class="switch"><input type="checkbox" checked id="<?php echo e($country->id); ?>" name="publish"><span class="slider round"></span></label>
                                                    <?php else: ?>
                                                        <label class="switch"><input type="checkbox"  id="<?php echo e($country->id); ?>" name="publish"><span class="slider round"></span></label>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <span class="date"><?php echo e(date('d F Y',strtotime($country->creer))); ?></span>
                                                    <span class="time"><?php echo e(date('h:i A',strtotime($country->creer))); ?></span>
                                                </td>
                                                <td>
                                                    <?php if($country->modifier!='0000-00-00 00:00:00'): ?>
                                                    <span class="date"><?php echo e(date('d F Y',strtotime($country->modifier))); ?></span>
                                                    <span class="time"><?php echo e(date('h:i A',strtotime($country->modifier))); ?></span>
                                                    <?php endif; ?>
                                                </td>
                                                <td class="action-btn"><a href="<?php echo e(route('country.show', ['id' => $country->id])); ?>" class="" data-toggle="tooltip" data-original-title="View détails"><i class="fa fa-eye"></i></a>
                                                  <a href="<?php echo e(route('country.edit',$country->id)); ?>" class="do_not_edit"><i class="fa fa-edit"></i></a>
                                                </td>
                                               
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                              <?php else: ?>
                                	<tr><td colspan="11" align="center"><?php echo e(trans("lang.no_result")); ?></td></tr>
                                <?php endif; ?>

                                        </tbody>

                                    </table>

                                    <nav aria-label="Page navigation example" class="custom-pagination">
                                    <?php echo e($countries->appends(request()->query())->links()); ?>

                                    </nav>
                                <?php echo e($countries->Links('pagination.pagination')); ?>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script type="text/javascript">

$(document).ready(function() {
 $(".shadow-sm").hide();
})

/* toggal publish action code start*/
$(document).on("click", "input[name='publish']", function (e) {
  
var ischeck = $(this).is(':checked');
var id = this.id;
console.log(id);
$.ajax({
  headers: {
 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
},
   url : '../country/switch',
   method:"POST",
   data:{'ischeck':ischeck,'id':id},
   success: function(data){

   },
});

});

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/administration_tools/country/index.blade.php ENDPATH**/ ?>