<?php $__env->startSection('content'); ?>
    <div class="page-wrapper">
        <div class="row page-titles">
            <div class="col-md-5 align-self-center">
                <h3 class="text-themecolor"><?php echo e(trans('lang.car_model')); ?></h3>
            </div>
            <div class="col-md-7 align-self-center">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/dashboard')); ?>"><?php echo e(trans('lang.dashboard')); ?></a></li>
                    <li class="breadcrumb-item active"><?php echo e(trans('lang.car_model')); ?></li>
                </ol>
            </div>
            <div>
            </div>
        </div>

        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">

                        <div class="card-body">
                            <div id="data-table_processing" class="dataTables_processing panel panel-default"
                                 style="display: none;"><?php echo e(trans('lang.processing')); ?>

                            </div>
                            <div class="userlist-topsearch d-flex mb-3">
                                <div class="userlist-top-left">
                                    <a class="nav-link do_not_create" href="<?php echo route('car_model.create'); ?>"><i
                                                class="fa fa-plus mr-2"></i><?php echo e(trans('lang.car_model_create')); ?></a>
                                </div>
                                <div id="users-table_filter" class="ml-auto">
                                    <label><?php echo e(trans('lang.search_by')); ?>

                                    <div class="form-group mb-0">
                                        <form action="<?php echo e(route('car_model')); ?>" method="get">
                                            <?php if(isset($_GET['selected_search']) &&  $_GET['selected_search'] != ''): ?>
                                                <?php //dd($_GET['selected_search']);?>
                                                <select name="selected_search" id="selected_search"
                                                        class="form-control input-sm">
                                                    <option value="name" <?php if($_GET['selected_search']=='name'): ?>
                                                    selected="selected" <?php endif; ?> ><?php echo e(trans('lang.model_name')); ?></option>
                                                </select>
                                            <?php else: ?>
                                                <select name="selected_search" id="selected_search"
                                                        class="form-control input-sm">
                                                    <option value="name"><?php echo e(trans('lang.model_name')); ?></option>
                                                </select>
                                            <?php endif; ?>
                                            <div class="search-box position-relative">
                                                <?php if(isset($_GET['search']) &&  $_GET['search'] != ''): ?>
                                                    <input type="text" class="search form-control" name="search"
                                                           id="search" value="<?php echo e($_GET['search']); ?>">
                                                <?php else: ?>
                                                    <input type="text" class="search form-control" name="search"
                                                           id="search">
                                                <?php endif; ?>
                                                <button type="submit" class="btn-flat position-absolute"><i
                                                            class="fa fa-search"></i></button>
                                                <a class="btn btn-warning btn-flat" href="<?php echo e(url('car_model')); ?>">Clear</a>
                                            </div>
                                        </form>
                                    </div>
                                    </label>
                                </div>
                            </div>
                            <div class="table-responsive m-t-10">
                                <table id="example24"
                                       class="display nowrap table table-hover table-striped table-bordered table table-striped"
                                       cellspacing="0" width="100%">
                                    <thead>
                                    <tr>
                                        <th class="delete-all"><input type="checkbox" id="is_active"><label
                                                    class="col-3 control-label" for="is_active"><a id="deleteAll"
                                                                                                   class="do_not_delete"
                                                                                                   href="javascript:void(0)"><i
                                                            class="fa fa-trash"></i> All</a></label></th>
                                        <th><?php echo e(trans('lang.model_name')); ?></th>
                                        <th><?php echo e(trans('lang.brand')); ?></th>
                                        <th><?php echo e(trans('lang.vehicle_type')); ?></th>
                                        <th><?php echo e(trans('lang.status')); ?></th>
                                        <th><?php echo e(trans('lang.actions')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody id="append_list12">
                                    <?php if(count($carModel) > 0): ?>
                                    <?php $__currentLoopData = $carModel; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="delete-all"><input type="checkbox"
                                                                          id="is_open_<?php echo e($value->id); ?>"
                                                                          class="is_open"
                                                                          dataid="<?php echo e($value->id); ?>"><label
                                                        class="col-3 control-label"
                                                        for="is_open_<?php echo e($value->id); ?>"></label></td>
                                            <td><a href="<?php echo e(route('car_model.edit', ['id' => $value->id])); ?>"><?php echo e($value->name); ?></a> </td>

                                            <td><?php $__currentLoopData = $brand; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brandVal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($value->brand_id==$brandVal->id): ?>
                                                    <a href="<?php echo e(route('brand.edit', ['id' => $brandVal->id])); ?>"><?php echo e($brandVal->name); ?></a>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></td>


                                            <td><?php $__currentLoopData = $vehicleType; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brandVal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($value->vehicle_type_id==$brandVal->id): ?>
                                                    <?php echo e($brandVal->libelle); ?>

                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></td>
                                              <td>  <?php if($value->status=="yes"): ?>
                                                    <label class="switch"><input type="checkbox" id="<?php echo e($value->id); ?>" name="publish" checked><span class="slider round"></span></label>
                                                <?php else: ?>
                                                <label class="switch"><input type="checkbox"  id="<?php echo e($value->id); ?>" name="publish"><span class="slider round"></span></label>
                                                <?php endif; ?>
                                            </td>
                                            <td class="action-btn"><a
                                                        href="<?php echo e(route('car_model.edit', ['id' => $value->id])); ?>" class="do_not_edit"><i
                                                            class="fa fa-edit"></i></a><a id="'+val.id+'"
                                                                                          class="do_not_delete"
                                                                                          name="user-delete"
                                                                                          href="<?php echo e(route('car_model.delete', ['id' => $value->id])); ?>"><i
                                                            class="fa fa-trash"></i></a>
                                               </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
		                                		<tr><td colspan="11" align="center"><?php echo e(trans("lang.no_result")); ?></td></tr>
		                                	<?php endif; ?>
                                    </tbody>
                                </table>

                                <nav aria-label="Page navigation example" class="custom-pagination">
                                    <?php echo e($carModel->appends(request()->query())->links()); ?>

                                </nav>
                                <?php echo e($carModel->links('pagination.pagination')); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

    <script type="text/javascript">


        $(document).ready(function () {
            $(".shadow-sm").hide();
        })

        $("#is_active").click(function () {
            $("#example24 .is_open").prop('checked', $(this).prop('checked'));

        });

        $("#deleteAll").click(function () {
            if ($('#example24 .is_open:checked').length) {
                if (confirm('Are You Sure want to Delete Selected Data ?')) {
                    var arrayUsers = [];
                    $('#example24 .is_open:checked').each(function () {
                        var dataId = $(this).attr('dataId');
                        arrayUsers.push(dataId);

                    });

                    arrayUsers = JSON.stringify(arrayUsers);
                    var url = "<?php echo e(url('car_model/delete', 'id')); ?>";
                    url = url.replace('id', arrayUsers);

                   $(this).attr('href', url);
                }
            } else {
                alert('Please Select Any One Record .');
            }
        });
        /* toggal publish action code start*/
$(document).on("click", "input[name='publish']", function (e) {
    
    var ischeck = $(this).is(':checked');
    var id = this.id;
    console.log(id);
    $.ajax({
      headers: {
     'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
   },
       url : 'carModel/switch',
       method:"POST",
       data:{'ischeck':ischeck,'id':id},
       success: function(data){

       },
    });

});

    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/b2ctaxiapp/webadmin/resources/views/carModel/index.blade.php ENDPATH**/ ?>