@extends('layouts.app')

@section('content')


<div class="page-wrapper">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor">{{trans('lang.vehicle_type')}}</h3>
        </div>

        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/dashboard')}}">{{trans('lang.dashboard')}}</a></li>
                <li class="breadcrumb-item"><a href="{{ url('vehicle/index') }}">{{trans('lang.vehicle_type')}}</a>
                </li>
                <li class="breadcrumb-item active">{{trans('lang.edit_vehicle_type')}}</li>
            </ol>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card pb-4">

                    <div class="card-body">

                        <div id="data-table_processing" class="dataTables_processing panel panel-default"
                            style="display: none;">{{trans('lang.processing')}}</div>
                        <div class="error_top"></div>
                        @if($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                        @endif
                        <form method="post" action="{{ route('vehicle-type.update', $type->id) }}"
                            enctype="multipart/form-data">
                            @csrf
                            @method("PUT")
                            <div class="row restaurant_payout_create">
                                <div class="restaurant_payout_create-inner">

                                    <fieldset>
                                        <legend>{{trans('lang.edit_vehicle_type')}}</legend>
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label">{{trans('lang.vehicle_type')}}</label>
                                            <div class="col-7">
                                                <input type="text" class="form-control" name="libelle"
                                                    value="{{$type->libelle}}">
                                                <!-- <div class="form-text text-muted"></div> -->
                                            </div>
                                        </div>

                                        <!-- <div class="form-group row width-50">
              <label class="col-3 control-label">{{trans('lang.price')}}</label>
              <div class="col-7">
                <input type="text" class="form-control" name="prix" value="{{$type->prix}}">
               <div class="form-text text-muted"></div>-->
                                        <!--</div>
                                         </div> -->

                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label">{{trans('lang.Image')}}</label>
                                            <div class="col-7">
                                                <input type="file" class="form-control" name="image"
                                                    onchange="readURL(this);">
                                                @if (file_exists(public_path('assets/images/type_vehicle' . '/' . $type->image)) && !empty($type->image))
                                                <img class="rounded" style="width:50px" id="uploding_image"
                                                    src="{{asset('assets/images/type_vehicle') . '/' . $type->image}}"
                                                    alt="image">
                                                @else
                                                <img class="rounded" style="width:50px" id="uploding_image"
                                                    src="{{asset('assets/images/placeholder_image.jpg')}}" alt="image">
                                                @endif
                                            </div>
                                        </div>
                                        <div class="form-group row width-50">
                                            <div class="form-check">
                                                <input type="checkbox" class="user_active" id="user_active"
                                                    name="status" value="Yes" {{ $type->status == 'Yes' ? 'checked' : '' }}>
                                                <label class="col-3 control-label"
                                                    for="user_active">{{trans('lang.active')}}</label>

                                            </div>
                                        </div>

                                    </fieldset>
                                    <fieldset>
                                        <legend>{{trans('lang.delivery_charge')}}</legend>

                                        <div class="form-group row width-100">
                                            <label
                                                class="col-3 control-label">Base fare
                                            </label>
                                            <div class="col-7">
                                                @if(!empty($delivery_charges))
                                                <input type="number" class="form-control"
                                                    name="minimum_delivery_charge_within_km"
                                                    value="{{ $delivery_charges->minimum_delivery_charges_within_km }}">
                                                @else
                                                <input type="number" class="form-control"
                                                    name="minimum_delivery_charge_within_km" value="">

                                                @endif
                                            </div>
                                        </div>

                                        <div class="form-group row width-100">
                                            <label
                                                class="col-3 control-label">Minimum KM for Base Fare</label>
                                            <div class="col-7">
                                                @if(!empty($delivery_charges))
                                                <input type="number" class="form-control" name="minimum_delivery_charge"
                                                    value="{{ $delivery_charges->minimum_delivery_charges }}">
                                                @else
                                                <input type="number" class="form-control" name="minimum_delivery_charge"
                                                    value="">

                                                @endif
                                            </div>
                                        </div>

                                        <div class="form-group row width-100">
                                            <label class="col-3 control-label">OutStation KM</label>
                                            <div class="col-7">
                                                @if(!empty($delivery_charges))
                                                <input type="number"
                                                    value="{{ $delivery_charges->outstation_radius }}"
                                                    class="form-control"
                                                    name="outstation_radius">
                                                @else
                                                <input type="number" value="" class="form-control"
                                                    name="outstation_radius">
                                                @endif
                                            </div>
                                        </div>

                                        <div class="form-group row width-100">
                                            <label class="col-3 control-label">Local Rate PER KM
                                            </label>
                                            <div class="col-7">
                                                @if(!empty($delivery_charges))
                                                <input type="number" class="form-control"
                                                    value="{{ $delivery_charges->delivery_charges_per_km }}"
                                                    name="delivery_charge_per_km">
                                                @else
                                                <input type="number" class="form-control" value=""
                                                    name="delivery_charge_per_km">

                                                @endif
                                            </div>
                                        </div>

                                        <div class="form-group row width-100">
                                            <label class="col-3 control-label">OutStation Rate Per KM</label>
                                            <div class="col-7">
                                                @if(!empty($delivery_charges))
                                                <input type="number" class="form-control"
                                                    value="{{ $delivery_charges->outstation_delivery_charge_per_km }}"
                                                    name="outstation_delivery_charge_per_km">
                                                @else
                                                <input type="number" class="form-control"
                                                    value=""
                                                    name="outstation_delivery_charge_per_km">
                                                @endif
                                            </div>
                                        </div>

                                        <!-- <div class="form-group row width-100">
                                            <label class="col-3 control-label">Commission</label>
                                            <div class="col-7">
                                                <select class="form-control" name="commission_type" id="commission_type_select">
                                                    <option value="default">Default</option>
                                                    <option value="custom">Custom</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div id="custom_commission_fields" style="display: none;">
                                            <div class="form-group row width-100">
                                                <div class="col-md-12">
                                                    <label class="control-label">Commission Type</label>
                                                    <select class="form-control" name="custom_commission_type">
                                                        <option value="" disabled selected>Select Type</option>
                                                        <option value="percentage">Percentage</option>
                                                        <option value="fixed">Fixed</option>
                                                    </select>
                                                </div>

                                                <div class="col-md-12">
                                                    <label class="control-label">Admin Commission</label>
                                                    <input type="number" step="any" class="form-control" name="admin_commission" placeholder="Enter Commission">
                                                </div>
                                            </div>
                                        </div> -->
                                        <div class="form-group row width-100">
                                            <label class="col-3 control-label">Commission</label>
                                            <div class="col-7">
                                                <select class="form-control" name="commission_type" id="commission_type_select">
                                                    <option value="default" {{ $type->commission_type == 'default' ? 'selected' : '' }}>Default</option>
                                                    <option value="custom" {{ $type->commission_type == 'custom' ? 'selected' : '' }}>Custom</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div id="custom_commission_fields" style="display: {{ $type->commission_type == 'custom' ? 'block' : 'none' }};">
                                            <div class="form-group row width-100">
                                                <!-- Commission Type -->
                                                <div class="col-md-12">
                                                    <label class="control-label">Commission Type</label>
                                                    <select class="form-control" name="custom_commission_type">
                                                        <option value="" disabled selected>Select Type</option>
                                                        <option value="percentage" {{ $type->custom_commission_type == 'percentage' ? 'selected' : '' }}>Percentage</option>
                                                        <option value="fixed" {{ $type->custom_commission_type == 'fixed' ? 'selected' : '' }}>Fixed</option>
                                                    </select>
                                                </div><br>

                                                <!-- Admin Commission -->
                                                <div class="col-md-12">
                                                    <label class="control-label">Admin Commission</label>
                                                    <input type="number" step="any" class="form-control" name="admin_commission" placeholder="Enter Commission" value="{{ $type->admin_commission }}">
                                                </div>
                                            </div>
                                        </div>


                                    </fieldset>
                                    <fieldset>

                                        <legend>{{trans('lang.rental_packages')}}</legend>
                                        <div class="row repeter">

                                            @if(sizeof($rental_packages) > 0)
                                            @foreach ($rental_packages as $k => $r)
                                            <div>
                                                <div class="form-group row width-50">
                                                    <label class="col-3 control-label">{{trans('lang.hours')}}</label>
                                                    <div class="col-7">
                                                        <select class="form-control hours_{{$k}}" id="hours" name="hours[]"
                                                            onchange="setval(0)">
                                                            <option>Select</option>
                                                            @foreach ($packages as $p)
                                                            <option data-value="{{$p->kilometers}}" value="{{$p->id}}"
                                                                @php if($p->id == $r->package_id){echo 'selected';} @endphp
                                                                >
                                                                {{$p->hours}}
                                                            </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="form-group row width-50">
                                                    <label
                                                        class="col-3 control-label">{{trans('lang.kilometers')}}</label>
                                                    <div class="col-7">
                                                        <input type="number" class="form-control kilometers_{{$k}}"
                                                            name="kilometers[]" value="{{$r->kilometers}}" readonly>
                                                    </div>
                                                </div>

                                                <div class="form-group row width-50">
                                                    <label class="col-3 control-label">{{trans('lang.price')}}</label>
                                                    <div class="col-7">
                                                        <input type="number" class="form-control" name="price[]" value="{{$r->price}}">
                                                    </div>
                                                </div>
                                                <div class="form-group row width-50">
                                                    <label class="col-3 control-label"></label>
                                                    <div class="col-7">


                                                        <button type="button" class="btn btn-primary "
                                                            onclick="add_rentals({{$k}})"><i class="fa fa-plus"></i></button>

                                                        @if($k != 0)
                                                        <button type="button" class="btn btn-danger delete_repeter "><i class="fa fa-trash"></i></button>

                                                        @endif
                                                    </div>
                                                </div>

                                                @endforeach
                                                @else
                                                <div class="form-group row width-50">
                                                    <label class="col-3 control-label">{{trans('lang.hours')}}</label>
                                                    <div class="col-7">
                                                        <select class="form-control hours_0" id="hours" name="hours[]"
                                                            onchange="setval(0)">
                                                            <option>Select</option>
                                                            @foreach ($packages as $p)
                                                            <option data-value="{{$p->kilometers}}" value="{{$p->id}}">
                                                                {{$p->hours}}
                                                            </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="form-group row width-50">
                                                    <label
                                                        class="col-3 control-label">{{trans('lang.kilometers')}}</label>
                                                    <div class="col-7">
                                                        <input type="number" class="form-control kilometers_0"
                                                            name="kilometers[]" readonly>
                                                    </div>
                                                </div>

                                                <div class="form-group row width-50">
                                                    <label class="col-3 control-label">{{trans('lang.price')}}</label>
                                                    <div class="col-7">
                                                        <input type="number" class="form-control" name="price[]">
                                                    </div>
                                                </div>
                                                <div class="form-group row width-50">
                                                    <label class="col-3 control-label"></label>
                                                    <div class="col-7">

                                                        <button type="button" class="btn btn-primary "
                                                            onclick="add_rentals(0)"><i class="fa fa-plus"></i></button>


                                                    </div>
                                                </div>
                                                @endif
                                            </div>
                                    </fieldset>

                                </div>
                            </div>
                    </div>
                    <div class="form-group col-12 text-center btm-btn">
                        <button type="submit" class="btn btn-primary  save_user_btn"><i
                                class="fa fa-save"></i>{{ trans('lang.save')}}</button>
                        <a href="{{ url('vehicle/index') }}" class="btn btn-default"><i
                                class="fa fa-undo"></i>{{ trans('lang.cancel')}}</a>
                    </div>

                </div>
                </form>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')

<script type="text/javascript">
    console.log('yes');

    $(document).ready(function() {
        $(".shadow-sm").hide();
    })

    function readURL(input) {
        console.log(input.files);
        if (input.files && input.files[0]) {
            var reader = new FileReader();

            reader.onload = function(e) {
                $('#image_preview').show();
                $('#uploding_image').attr('src', e.target.result);


            }

            reader.readAsDataURL(input.files[0]);
        }
    }

    function add_rentals(count) {

        count++;
        var html = `<div><div class="form-group row width-50">
                                        <label class="col-3 control-label">{{trans('lang.hours')}}</label>
                                        <div class="col-7">
                                            <select class="form-control hours_` + count + `" id="hours" name="hours[]" onchange="setval(` + count + `)">
                                                <option>Select</option>
                                                @foreach ($packages as $p)
                                                    <option data-value="{{$p->kilometers}}" value="{{$p->id}}">{{$p->hours}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-group row width-50">
                                        <label class="col-3 control-label">{{trans('lang.kilometers')}}</label>
                                        <div class="col-7">
                                            <input type="number" class="form-control kilometers_` + count + `" name="kilometers[]" readonly>
                                        </div>
                                    </div>

                                    <div class="form-group row width-50">
                                        <label class="col-3 control-label">{{trans('lang.price')}}</label>
                                        <div class="col-7">
                                            <input type="number" class="form-control" name="price[]">
                                        </div>
                                    </div>
                                    <div class="form-group row width-50">
                                        <label class="col-3 control-label"></label>
                                        <div class="col-7">

                                            <button type="button" class="btn btn-primary "
                                                onclick="add_rentals(` + count + `)"><i class="fa fa-plus"></i></button>

                                                
                                            <button type="button" class="btn btn-danger delete_repeter "
                                                ><i class="fa fa-trash"></i></button>

                                        </div>
                                    </div></div>`;

        $('.repeter').append(html);



    }

    $(document).on("click", ".delete_repeter", function() {
        $(this).parent().parent().parent().remove();
    });

    function setval(count) {
        var val = $('.hours_' + count).find(':selected').data('value');
        $('.kilometers_' + count).val(val);
    }

    document.getElementById('commission_type_select').addEventListener('change', function() {
        const selectedValue = this.value;
        const customFields = document.getElementById('custom_commission_fields');

        const commissionTypeField = document.querySelector('[name="custom_commission_type"]');
        const adminCommissionField = document.querySelector('[name="admin_commission"]');

        if (selectedValue === 'custom') {
            customFields.style.display = 'block';
            commissionTypeField.setAttribute('required', true);
            adminCommissionField.setAttribute('required', true);
        } else {
            customFields.style.display = 'none';

            // Clear values
            commissionTypeField.value = '';
            adminCommissionField.value = '';

            // Remove required attributes
            commissionTypeField.removeAttribute('required');
            adminCommissionField.removeAttribute('required');
        }
    });
</script>

@endsection