@extends('layouts.app')


@section('content')
<div class="page-wrapper">
	<div class="row page-titles">
		<div class="col-md-5 align-self-center">
			<h3 class="text-themecolor">{{trans('lang.rental_package_edit')}}</h3>
		</div>
		<div class="col-md-7 align-self-center">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><a href="{{url('/dashboard')}}">{{trans('lang.dashboard')}}</a></li>
				<li class="breadcrumb-item"><a href= "{!! route('users') !!}" >{{trans('lang.all_rental_packages')}}</a></li>
				<li class="breadcrumb-item active">{{trans('lang.rental_package_edit')}}</li>
			</ol>
		</div>

	</div>
	<div class="container-fluid">

              
             <div class="card pb-4">
		<div class="card-body">

			<div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;">{{trans('lang.processing')}}</div>
			<div class="error_top"></div>
			@if($errors->any())
				<div class="alert alert-danger">
					<ul>
					@foreach($errors->all() as $error)
						<li>{{ $error }}</li>
					@endforeach
					</ul>
				</div>
			@endif
				<form method="post" action="{{ route('rental-packages.update',$package->id) }}" enctype="multipart/form-data">
					@csrf
					@method("PUT")
			<div class="row restaurant_payout_create">
				<div class="restaurant_payout_create-inner">

					<fieldset>
						<legend>{{trans('lang.package_details')}}</legend>
						<div class="form-group row width-50">
							<label class="col-3 control-label">{{trans('lang.hours')}}</label>
							<div class="col-7">
								<input type="number" class="form-control hours" name="hours" value="{{$package->hours}}">
								<div class="form-text text-muted">
									{{ trans("lang.hours") }}
								</div>
							</div>
						</div>

						<div class="form-group row width-50">
							<label class="col-3 control-label">{{trans('lang.kilometers')}}</label>
							<div class="col-7">
								<input type="number" class="form-control kilometers" name="kilometers" value="{{$package->kilometers}}">
								<div class="form-text text-muted">
									{{ trans("lang.kilometers") }}
								</div>
							</div>
						</div>
					
						<div class="form-group row width-50">

							<div class="form-check">

								 @if ($package->status === "yes")
									 <input type="checkbox" class="package_active" name="status" id="package_active" checked="checked"  value="yes"/>
       							@else
          							<input type="checkbox" class="package_active" name="status" id="package_active" value="no"/>
       							@endif
								<label class="col-3 control-label" for="package_active">{{trans('lang.active')}}</label>
							</div>

						</div>

						</div>
					</fieldset>

			
				</div>
<div class="form-group col-12 text-center btm-btn" >
			<button type="submit" class="btn btn-primary  save_user_btn" ><i class="fa fa-save"></i> {{ trans('lang.save')}}</button>
			<a href="{!! route('rental-packages') !!}" class="btn btn-default"><i class="fa fa-undo"></i>{{ trans('lang.cancel')}}</a>
		</div>
			</div>
		</div>
		

</div>
</form>

</div>



            </div>

@endsection

@section('scripts')
<script type="text/javascript">
    function readURL(input) {
		console.log(input.files);
        if (input.files && input.files[0]) {
            var reader = new FileReader();

            reader.onload = function (e) {
                $('#uploding_image').attr('src', e.target.result);

				
            }

            reader.readAsDataURL(input.files[0]);
        }
    }

	function readURLNic(input) {
		console.log(input.files);
        if (input.files && input.files[0]) {
            var reader = new FileReader();

            reader.onload = function (e) {
				$('#user_nic_image').attr('src', e.target.result);
            }

            reader.readAsDataURL(input.files[0]);
        }
    }
</script>
@endsection
