@extends('layouts.app')

@section('content')
<div class="page-wrapper">
	<div class="row page-titles">
		<div class="col-md-5 align-self-center">
			<h3 class="text-themecolor">{{trans('lang.rental_package_create')}}</h3>
		</div>

		<div class="col-md-7 align-self-center">
			<ol class="breadcrumb">
				<li class="breadcrumb-item"><a href="{{url('/dashboard')}}">{{trans('lang.dashboard')}}</a></li>
				<li class="breadcrumb-item"><a
						href="{!! route('rental-packages') !!}">{{trans('lang.all_rental_packages')}}</a></li>
				<li class="breadcrumb-item active">{{trans('lang.rental_package_create')}}</li>
			</ol>
		</div>
	</div>

	<div class="container-fluid">
		<div class="row">
			<div class="col-12">
				<div class="card pb-4">

					<div class="card-body">

						<div id="data-table_processing" class="dataTables_processing panel panel-default"
							style="display: none;">
							{{trans('lang.processing')}}
						</div>
						<div class="error_top"></div>
						@if($errors->any())
						<div class="alert alert-danger">
							<ul>
								@foreach($errors->all() as $error)
								<li>{{ $error }}</li>
								@endforeach
							</ul>
						</div>
						@endif

						<form action="{{route('rental-packages.storepackage')}}" method="post"
							enctype="multipart/form-data" id="create_driver">
							@csrf
							<div class="row restaurant_payout_create">
								<div class="restaurant_payout_create-inner">
									<fieldset>
										<legend>{{trans('lang.package_details')}}</legend>

										<div class="form-group row width-50">
											<label class="col-3 control-label">{{trans('lang.hours')}}</label>
											<div class="col-7">
												<input type="number" class="form-control" name="hours"
													value="{{ Request::old('hours')}}">
												<div class="form-text text-muted">
													{{ trans("lang.hours") }}
												</div>
											</div>
										</div>

										<div class="form-group row width-50">
											<label class="col-3 control-label">{{trans('lang.kilometers')}}</label>
											<div class="col-7">
												<input type="number" class="form-control " name="kilometers"
													value="{{ Request::old('kilometers')}}">
												<div class="form-text text-muted">
													{{ trans("lang.kilometers") }}
												</div>
											</div>
										</div>
									

										<div class="form-group row width-50">
											<div class="form-check">
												<input type="checkbox" class="package_active" id="package_active"
													name="status">
												<label class="col-3 control-label"
													for="package_active">{{trans('lang.active')}}</label>

											</div>
										</div>
									</fieldset>

								</div>
							</div>


							<div class="form-group col-12 text-center btm-btn">
								<button type="submit" class="btn btn-primary"><i
										class="fa fa-save"></i> {{ trans('lang.save')}}</button>
								<a href="{!! route('rental-packages') !!}" class="btn btn-default"><i class="fa fa-undo"></i>{{
									trans('lang.cancel')}}</a>
							</div>

						</form>

					</div>
				</div>
			</div>
		</div>
	</div>

	@endsection

	@section('scripts')
	<script src="https://cdnjs.cloudflare.com/ajax/libs/crypto-js/3.1.9-1/crypto-js.js"></script>
	<script type="text/javascript">
		function readURL(input) {
			if (input.files && input.files[0]) {
				var reader = new FileReader();
				reader.onload = function (e) {
					$('#image_preview').show();
					$('#uploding_image').attr('src', e.target.result);
				}
				reader.readAsDataURL(input.files[0]);
			}
		}

		function readURLNic(input) {
			console.log(input.files);
			if (input.files && input.files[0]) {
				var reader = new FileReader();

				reader.onload = function (e) {
					$('#placeholder_img_thumb').show();
					$('#user_nic_image').attr('src', e.target.result);
				}

				reader.readAsDataURL(input.files[0]);
			}
		}
	</script>
	@endsection