@extends('layouts.app')

@section('content')
<div class="page-wrapper">
  <div class="row page-titles">
    <div class="col-md-5 align-self-center">
      <h3 class="text-themecolor">{{trans('lang.coupon_plural')}}</h3>
    </div>

    <div class="col-md-7 align-self-center">
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="{{url('/dashboard')}}">{{trans('lang.dashboard')}}</a></li>
        <?php if (isset($_GET['eid']) && $_GET['eid'] != '') { ?>
          <li class="breadcrumb-item"><a href="{{route('restaurants.coupons',$_GET['eid'])}}">{{trans('lang.coupon_plural')}}</a></li>
        <?php } else { ?>
          <li class="breadcrumb-item"><a href="{!! route('coupons') !!}">{{trans('lang.coupon_plural')}}</a></li>
        <?php } ?>
        <li class="breadcrumb-item active">{{trans('lang.coupon_edit')}}</li>
      </ol>
    </div>

  </div>
  <div class="container-fluid">
    <div class="row">
      <div class="col-12">
        <div class="card pb-4">
          <div class="card-body">

            <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display: none;">{{trans('lang.processing')}}</div>

            <div class="error_top" style="display:none"></div>
            @if($errors->any())
            <div class="alert alert-danger">
              <ul>
                @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
              </ul>
            </div>
            @endif
            <form method="post" action="{{ route('coupons.update',$discount->id) }}" enctype="multipart/form-data">
              @csrf
              @method("PUT")
              <div class="row restaurant_payout_create">

                <div class="restaurant_payout_create-inner">

                  <!-- <div class="col-md-6"> -->
                  <fieldset>
                    <legend>{{trans('lang.coupon_edit')}}</legend>

                    <div class="form-group row width-50">
                      <label class="col-3 control-label">{{trans('lang.coupon_code')}}</label>
                      <div class="col-7">
                        <input type="text" type="text" class="form-control coupon_code" name="code" value="{{$discount->code}}">
                        <div class="form-text text-muted">{{ trans("lang.coupon_code_help") }} </div>
                      </div>
                    </div>

                    <div class="form-group row width-50">
                      <label class="col-3 control-label">{{trans('lang.coupon_discount_type')}}</label>
                      <div class="col-7">
                        <select id="coupon_discount_type" class="form-control" name="type">
                          <option value="Percentage" {{ $discount->type == 'Percentage' ? 'selected' : '' }}>{{trans('lang.coupon_percent')}}</option>
                          <option value="Fix Price" {{ $discount->type == 'Fix Price' ? 'selected' : '' }}>{{trans('lang.coupon_fixed')}}</option>
                        </select>
                        <div class="form-text text-muted">{{ trans("lang.coupon_discount_type_help") }}</div>

                      </div>
                    </div>

                    <div class="form-group row width-50" id="discount" style="{{ $discount->apply_for == 'normal' ? '' : 'display:none;' }}">
                      <label class="col-3 control-label">{{trans('lang.coupon_discount')}}</label>
                      <div class="col-7">

                        <input type="number" type="text" class="form-control coupon_discount" name="discount" value="{{$discount->discount}}">
                        <div class="form-text text-muted">{{ trans("lang.coupon_discount_help") }}</div>

                      </div>
                    </div>

                    <div class="form-group row width-100" id="discount_slab" style="{{ $discount->apply_for == 'completed' ? '' : 'display:none;' }}">

                      <label class="col-3 control-label">Discount Slabs</label>
                      <div class="col-7">

                        <table class="table table-bordered" id="slab_table">
                          <thead>
                            <tr>
                              <th>Minimum Ride Amount</th>
                              <th>Discount</th>
                              <th></th>
                            </tr>
                          </thead>
                          <tbody>
                            @foreach($slabs as $i => $slab)
                            <tr>
                              <td>
                                <input type="number" name="slabs[{{ $i }}][min]" class="form-control"
                                  value="{{ $slab->min_ride_amount }}" required>
                              </td>
                              <td>
                                <input type="number" name="slabs[{{ $i }}][discount]" class="form-control"
                                  value="{{ $slab->discount_amount }}" required>
                              </td>
                              <!-- <td>
                                <select name="slabs[{{ $i }}][discount_type]" class="form-control">
                                  <option value="flat" {{ $slab->discount_type=='flat'?'selected':'' }}>Flat</option>
                                  <option value="percent" {{ $slab->discount_type=='percent'?'selected':'' }}>Percent</option>
                                </select>
                              </td> -->
                              <td>
                                <button type="button" class="btn btn-sm btn-danger remove_slab">X</button>
                              </td>
                            </tr>
                            @endforeach
                          </tbody>
                        </table>

                        <button type="button" class="btn btn-sm btn-secondary" id="add_slab">+ Add slab</button>
                      </div>
                    </div>


                    <div class="form-group row width-50">
                      <label class="col-3 control-label">{{trans('lang.coupon_expires_at')}}</label>
                      <div class="col-7">
                        <!-- <div class="form-group"> -->
                        <div class='input-group date' id='datetimepicker1'>

                          <input type='date' class="form-control date_picker input-group-addon" name="expire_at" min="{{ now()->format('Y-m-d') }}" value="{{ date('Y-m-d', strtotime($discount->expire_at)) }}" />
                          <span class="">
                            <!-- <span class="glyphicon glyphicon-calendar fa fa-calendar"></span> -->
                          </span>
                        </div>
                        <div class="form-text text-muted">
                          {{ trans("lang.coupon_expires_at_help") }}
                        </div>
                        <!-- </div> -->
                      </div>
                    </div>
                    <div class="form-group row width-50">
                      <label class="col-3 control-label">{{trans('lang.coupon_type')}}</label>
                      <div class="col-7">
                        <select id="coupon_type" class="form-control" name="coupon_type">
                          <option value="Ride" {{ $discount->coupon_type == 'Ride' ? 'selected' : '' }}>{{trans('lang.ride')}}</option>
                          <option value="Parcel" {{ $discount->coupon_type == 'Parcel' ? 'selected' : '' }}>{{trans('lang.parcel')}}</option>

                        </select>
                        <div class="form-text text-muted">
                          {{ trans("lang.coupon_type_help") }}
                        </div>
                      </div>
                    </div>

                    <div class="form-group row width-50" id="minimun_amount" style="{{ $discount->apply_for == 'normal' ? '' : 'display:none;' }}">

                      <label class="col-3 control-label">{{trans('Minimun amount')}}</label>
                      <div class="col-7">
                        <input type="number" type="text" class="form-control minimun_amount" name="minimun_amount" value="{{ $discount->minimum_amount}}">
                        <div class="form-text text-muted">{{ trans("insert minimun amount") }}</div>
                      </div>
                    </div>

                    <!-- <div class="form-group row width-50">
                      <label class="col-3 control-label">{{trans('Number of times allowed')}}</label>
                      <div class="col-7">
                        <input type="number" type="text" class="form-control number_time_allowed" name="number_time_allowed" value="{{ $discount->number_time_allowed}}">
                        <div class="form-text text-muted">{{ trans("insert number of times for use") }}</div>
                      </div>
                    </div> -->


                    <!-- <div class="form-group row width-50">
              <label class="col-3 control-label">{{trans('lang.coupon_restaurant_id')}}</label>
              <div class="col-7">
                <select id="vendor_restaurant_select" class="form-control">
                  <option value="">{{trans('lang.select_restaurant')}}</option>
                </select>
                <div class="form-text text-muted">
                  {{ trans("lang.coupon_restaurant_id_help") }}
                </div> 
              </div>
            </div> -->

                    {{-- Apply For --}}
                    <div class="form-group row width-50">
                      <label class="col-3 control-label">Apply For</label>
                      <div class="col-7">
                        <select class="form-control" name="apply_for">
                          <option value="normal" {{ $discount->apply_for == 'normal' ? 'selected' : '' }}>Normal</option>
                          <option value="completed" {{ $discount->apply_for == 'completed' ? 'selected' : '' }}>Completed</option>
                        </select>
                      </div>
                    </div>

                    {{-- Number of times allowed (show only if apply_for is normal) --}}
                    <div class="form-group row width-50" id="number_of_time" style="{{ $discount->apply_for == 'completed' ? 'display:none;' : '' }}">
                      <label class="col-3 control-label">Number of times allowed</label>
                      <div class="col-7">
                        <input type="number" class="form-control number_time_allowed" name="number_time_allowed" value="{{ $discount->number_time_allowed }}">
                      </div>
                    </div>

                    {{-- Rating (show only if apply_for is completed) --}}
                    <div class="form-group row width-50" id="rating_div" style="{{ $discount->apply_for == 'completed' ? '' : 'display:none;' }}">
                      <label class="col-3 control-label">Rating</label>
                      <div class="col-7">
                        <select class="form-control" name="rating" id="rating_select">
                          <option value="">Select Rating</option>
                          @for($i = 1; $i <= 5; $i++)
                            <option value="{{ $i }}" {{ $discount->rating == $i ? 'selected' : '' }}>{{ $i }}</option>
                            @endfor
                        </select>
                      </div>
                    </div>


                    <div class="form-group row width-50">
                      <label class="col-3 control-label">{{trans('lang.coupon_title')}}</label>
                      <div class="col-7">
                        <input type="text" type="text" class="form-control coupon_code" name="title" value="{{$discount->title}}">
                        <div class="form-text text-muted">{{ trans("lang.coupon_title_help") }} </div>
                      </div>
                    </div>

                    <div class="form-group row width-100">
                      <label class="col-3 control-label">{{trans('lang.coupon_description')}}</label>
                      <div class="col-7">
                        <textarea rows="12" class="form-control coupon_description" name="discription" id="coupon_description">{{$discount->discription}}</textarea>
                        <div class="form-text text-muted">{{ trans("lang.coupon_description_help") }}</div>
                      </div>
                    </div>

                    <div class="form-group row width-100">
                      <div class="form-check">
                        @if ($discount->statut === "yes")
                        <input type="checkbox" class="coupon_enabled" id="coupon_enabled" name="statut" checked="checked">

                        @else
                        <input type="checkbox" class="coupon_enabled" id="coupon_enabled" name="statut">
                        @endif
                        <label class="col-3 control-label" for="coupon_enabled">{{trans('lang.coupon_enabled')}}</label>

                      </div>
                    </div>
                  </fieldset>
                </div>

              </div>

          </div>
          <div class="form-group col-12 text-center btm-btn">
            <button type="submit" class="btn btn-primary save_coupon_btn"><i class="fa fa-save"></i> {{ trans('lang.save')}}</button>
          </div>
          </form>
        </div>
      </div>
    </div>
  </div>

  @endsection

  @section('scripts')
  <script>
    let slabIndex = {{ count($slabs) }};

    $('#add_slab').click(function() {
      $('#slab_table tbody').append(`
    <tr>
      <td><input type="number" name="slabs[${slabIndex}][min]" class="form-control" required></td>
      <td><input type="number" name="slabs[${slabIndex}][discount]" class="form-control" required></td>     
      <td><button type="button" class="btn btn-sm btn-danger remove_slab">X</button></td>
    </tr>
  `);
      slabIndex++;
    });

    $(document).on('click', '.remove_slab', function() {
      $(this).closest('tr').remove();
    });


    function toggleRating() {
      var applyFor = $('select[name="apply_for"]').val();
      // if (applyFor === 'completed') {
      //   $('#rating_div').show();
      //   $('#number_of_time').hide();
      // } else {
      //   $('#rating_div').hide();
      //   $('#number_of_time').show();
      // }

      if (applyFor === 'completed') {
        $('#rating_div').show();        
        $('#discount_slab').show();
        $('#discount').hide();
        $('#number_of_time').hide();
        $('#minimun_amount').hide();
      } else {
        $('#rating_div').hide();
        $('#rating_select').val('');
        $('#discount_slab').hide();
        $('#discount').show();
        $('#number_of_time').show();
        $('#minimun_amount').show();
      }


    }

    // On page load
    toggleRating();

    // On change of Apply For dropdown
    $('select[name="apply_for"]').change(function() {
      toggleRating();
    });
  </script>

  @endsection