@extends('layouts.app')



@section('content')

<div class="page-wrapper">

    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h3 class="text-themecolor">{{ trans('lang.create_ride') }}</h3>
        </div>

        <div class="col-md-7 align-self-center">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ url('/dashboard') }}">{{ trans('lang.dashboard') }}</a></li>
                <li class="breadcrumb-item active">{{ trans('lang.create_ride') }}</li>
            </ol>
        </div>
    </div>

    <div class="container-fluid">

        <div class="row">
            <div class="col-12">
                <div class="card pb-4">

                    <div class="card-body">

                        <div id="data-table_processing" class="dataTables_processing panel panel-default" style="display:none;">
                            {{ trans('lang.processing') }}
                        </div>

                        <div class="error_top"></div>

                        @if($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                        @endif

                        <form action="{{ route('admin.request.register') }}" method="post" enctype="multipart/form-data">
                            @csrf

                            <div class="row restaurant_payout_create">
                                <div class="restaurant_payout_create-inner">

                                    <fieldset>
                                        <legend>{{ trans('lang.create_ride') }}</legend>


                                        {{-- SOURCE --}}
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label">Source</label>
                                            <div class="col-7">
                                                <input type="text" id="source" name="source" class="form-control" placeholder="Enter source location" autocomplete="off" required>
                                                <input type="hidden" name="lat1" id="source_lat">
                                                <input type="hidden" name="lng1" id="source_lng">
                                            </div>
                                        </div>

                                        {{-- DESTINATION --}}
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label">Destination</label>
                                            <div class="col-7">
                                                <input type="text" id="destination" name="destination" class="form-control" placeholder="Enter destination location" autocomplete="off" required>
                                                <input type="hidden" name="lat2" id="destination_lat">
                                                <input type="hidden" name="lng2" id="destination_lng">
                                            </div>
                                        </div>

                                        <hr>
                                        <h4><b>Stops (Optional)</b></h4>

                                        <div id="stops_wrapper"></div>

                                        <div style="display: flex;">
                                            <button type="button" id="add_stop_btn" class="btn btn-success" style="margin: auto;">
                                                + Add Stop
                                            </button>

                                        </div>

                                        <br>

                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label">Customer Name</label>
                                            <div class="col-7">
                                                <select name="user_id" id="customer_id" class="form-control" required>
                                                    <option value="">-- Select Customer --</option>
                                                    @foreach($customers as $customer)
                                                    <option value="{{ $customer->id }}"
                                                        {{ old('user_id') == $customer->id ? 'selected' : '' }}>
                                                        <!-- {{ $customer->nom }} {{ $customer->prenom }} -->
                                                           {{ $customer->phone }} - {{ $customer->prenom }}  {{ $customer->nom }}
                                                    </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>


                                        {{-- COUT + DUREE + DISTANCE --}}
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label">Total Amount</label>
                                            <div class="col-7">
                                                <input type="number" name="cout" id="cout" class="form-control" value="{{ old('cout') }}" readonly>
                                            </div>
                                        </div>


                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label">Duration</label>
                                            <div class="col-7">
                                                <input type="text" name="duree" class="form-control" id="duration" value="{{ old('duree') }}" disabled>
                                            </div>
                                        </div>

                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label">Distance</label>
                                            <div class="col-7">
                                                <input type="text" name="distance" class="form-control" id="distance" value="{{ old('distance') }}" disabled>

                                            </div>
                                        </div>

                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label">Select Vehicle</label>
                                            <div class="col-7">
                                                <select name="vehicle_id" id="vehicle_id" class="form-control" required>
                                                    <option value="">-- Select Vehicle --</option>
                                                    @foreach($output as $vehicle)
                                                    <option
                                                        value="{{ $vehicle->id }}"
                                                        data-delivery-charges="{{ $vehicle->delivery_charges }}"
                                                        data-minimum-delivery-charges="{{ $vehicle->minimum_delivery_charges }}"
                                                        data-minimum-delivery-charges-within="{{ $vehicle->minimum_delivery_charges_within }}"
                                                        data-outstation-radius="{{ $vehicle->outstation_radius }}"
                                                        data-outstation-delivery-charge-per-km="{{ $vehicle->outstation_delivery_charge_per_km }}">
                                                        {{ $vehicle->libelle }}
                                                    </option>
                                                    @endforeach

                                                </select>
                                            </div>
                                        </div>

                                        {{-- ROUND TRIP --}}
                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label">Round Trip</label>
                                            <div class="col-7">
                                                <select name="round_trip" id="round_trip" class="form-control" required>
                                                    <option value="">-- Select Trip --</option>
                                                    <option value="No">No</option>
                                                    <option value="Yes">Yes</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group row width-50">
                                            <label class="col-3 control-label">Ride Type</label>
                                            <div class="col-7">
                                                <select name="ride_type" id="ride_type" class="form-control" required>
                                                    <option value="">-- Select Ride Type --</option>
                                                    <option value="instant">Instant Ride</option>
                                                    <option value="scheduled">Scheduled Ride</option>
                                                </select>
                                            </div>
                                        </div>


                                        <div id="normal_section" style="display:none;">

                                            {{-- DATE --}}
                                            <div class="form-group row width-50">
                                                <label class="col-3 control-label"> Date </label>
                                                <div class="col-7">
                                                    <input type="date" id="date" name="date" class="form-control" value="{{ old('date') }}">
                                                </div>
                                            </div>

                                            {{-- HOUR --}}
                                            <div class="form-group row width-50">
                                                <label class="col-3 control-label"> Hour</label>
                                                <div class="col-7">
                                                    <input type="time" id="hour" name="hour" class="form-control" value="{{ old('hour') }}">
                                                </div>
                                            </div>

                                        </div>


                                        <div id="return_section" style="display:none;">

                                            {{-- RETURN DATE --}}
                                            <div class="form-group row width-50">
                                                <label class="col-3 control-label">Return Date</label>
                                                <div class="col-7">
                                                    <input type="text" name="return_date" id="return_date" class="form-control" value="{{ old('return_date') }}">
                                                </div>
                                            </div>

                                            {{-- RETURN HOUR --}}
                                            <div class="form-group row width-50">
                                                <label class="col-3 control-label">Return Hour</label>
                                                <div class="col-7">
                                                    <input type="text" name="return_hour" id="return_hour" class="form-control" value="{{ old('return_hour') }}">
                                                </div>
                                            </div>

                                        </div>

                                    </fieldset>

                                </div>
                            </div>

                            <div class="form-group col-12 text-center btm-btn">
                                <button type="submit" class="btn btn-primary save_user_btn">
                                    <i class="fa fa-save"></i> {{ trans('lang.save') }}
                                </button>

                            </div>


                            <input type="hidden" name="cout" id="cout_hidden">
                            <input type="hidden" name="distance" id="distance_hidden">
                            <input type="hidden" name="duree" id="duration_hidden">

                        </form>

                    </div>

                </div>
            </div>
        </div>

    </div>

</div>

@endsection


@section('scripts')

<!-- ADD FLATPICKR LINKS HERE -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

<script type="text/javascript">
    $(document).ready(function() {

        $(".shadow-sm").hide();
        let rideType = $("#ride_type").val('');
        let roundTrip = $("#round_trip").val('');

        // $("#ride_type").on("change", function() {
        //     let type = $(this).val();

        //     if (type === "scheduled") {
        //         $("#normal_section").show(); // Show date & time
        //         $("#date, #hour").attr("required", true);
        //     } else {
        //         $("#normal_section").hide(); // Hide date & time
        //         $("#date, #hour").removeAttr("required");
        //         $("#date").val("");
        //         $("#hour").val("");
        //     }
        // });

        // $("#round_trip").on("change", function() {
        //     if ($(this).val() === "Yes") {
        //         $("#return_section").show();
        //     } else {
        //         $("#return_section").hide();
        //         $("#return_date").val("");
        //         $("#return_hour").val("");
        //         $("#date").val("");
        //         $("#hour").val("");
        //     }
        // });

        function updateSections() {
            let rideType = $("#ride_type").val();
            let roundTrip = $("#round_trip").val();

            // Always show return section only if round trip
            if (roundTrip === "Yes") {
                $("#return_section").show();

                // For round trips → date & hour must ALWAYS be shown
                $("#normal_section").show();
                $("#ride_type").val('scheduled');

            } else {
                $("#return_section").hide();
                $("#return_date, #return_hour").val("");


                // When NOT round trip → follow ride type
                if (rideType === "scheduled") {
                    $("#normal_section").show();
                } else {
                    $("#normal_section").hide();
                    $("#date, #hour").removeAttr("required");                
                    pickupDate.clear();
                    pickupTime.clear();
                }
            }
        }

        // Trigger on both dropdowns
        $("#ride_type, #round_trip").on("change", updateSections);

        $('#customer_id').select2({
            placeholder: "-- Select Customer --",
            allowClear: true,
            width: '100%'
        });



        // MAIN DATE
        let pickupDate = $("#date").flatpickr({
            dateFormat: "Y-m-d",
            minDate: "today",
            onChange: function(selectedDates, dateStr) {
                updateMinTime("#hour", dateStr);
                $("#hour").val("");
            }
        });

        // RETURN DATE
        let returnDate = $("#return_date").flatpickr({
            dateFormat: "Y-m-d",
            minDate: "today",
            onChange: function(selectedDates, dateStr) {
                updateMinTime("#return_hour", dateStr);
                $("#return_hour").val("");
            }
        });

        // MAIN TIME PICKER
        let pickupTime = $("#hour").flatpickr({
            enableTime: true,
            noCalendar: true,
            dateFormat: "H:i",
            time_24hr: true,
            minuteIncrement: 1,
        });

        // RETURN TIME PICKER
        let returnTime = $("#return_hour").flatpickr({
            enableTime: true,
            noCalendar: true,
            dateFormat: "H:i",
            time_24hr: true,
            minuteIncrement: 1,
        });

        /**
         * Get minimum time (current + 30 minutes)
         */




        function getMinTime() {
            let now = new Date();
            if ($("#round_trip").val() == 'Yes') {
                now.setMinutes(now.getMinutes() + 0);
            } else {
                now.setMinutes(now.getMinutes() + 5);
            }



            let h = now.getHours().toString().padStart(2, "0");
            let m = now.getMinutes().toString().padStart(2, "0");

            return `${h}:${m}`;
        }

        /**
         * Update minTime based on selected date
         */
        function updateMinTime(selector, selectedDate) {
            let today = new Date().toISOString().split("T")[0];

            let fp = $(selector)[0]._flatpickr;

            if (selectedDate === today) {
                fp.set("minTime", getMinTime());
            } else {
                fp.set("minTime", "00:00");
            }
        }

    });
</script>

<script>
    let sourceLat, sourceLng, destinationLat, destinationLng;
    let selectedVehicleData = null;


    function initAutocompleteInit() {
        initAutocomplete();
    }

    /* -----------------------------
       SOURCE & DESTINATION
    ------------------------------ */
    function initAutocomplete() {

        // SOURCE
        const sourceAuto = new google.maps.places.Autocomplete($("#source")[0]);
        sourceAuto.addListener("place_changed", () => {
            let place = sourceAuto.getPlace();
            if (!place.geometry) return;

            sourceLat = place.geometry.location.lat();
            sourceLng = place.geometry.location.lng();
            $("#source_lat").val(sourceLat);
            $("#source_lng").val(sourceLng);

            resetFields();

            if (destinationLat && destinationLng) calculateDistanceDuration();
        });

        // DESTINATION
        const destAuto = new google.maps.places.Autocomplete($("#destination")[0]);
        destAuto.addListener("place_changed", () => {
            let place = destAuto.getPlace();
            if (!place.geometry) return;

            destinationLat = place.geometry.location.lat();
            destinationLng = place.geometry.location.lng();
            $("#destination_lat").val(destinationLat);
            $("#destination_lng").val(destinationLng);

            resetFields();

            if (sourceLat && sourceLng) calculateDistanceDuration();
        });

        $("#source, #destination").on("change", resetFields);

        // VEHICLE CHANGE
        $("#vehicle_id").on("change", function() {
            const selected = $(this).find(":selected");
            if (!selected.val()) {
                selectedVehicleData = null;
                return;
            }

            if (!$("#distance").val()) {
                $("#vehicle_id").val('');
                alert("Please select both locations");
                return;
            }

            selectedVehicleData = {
                minimumDeliveryChargesWithin: parseFloat(selected.data("minimum-delivery-charges-within")),
                deliveryCharges: parseFloat(selected.data("delivery-charges")),
                outstationRadius: parseFloat(selected.data("outstation-radius")),
                outstationDeliveryChargePerKm: parseFloat(selected.data("outstation-delivery-charge-per-km")),
            };

            calculateCout(parseFloat($("#distance").val()), selectedVehicleData);
        });
    }

    function resetFields() {
        $("#distance").val('');
        $("#duration").val('');
        $("#cout").val(''); 
    }

    let stopIndex = 0;
    const maxStops = 5;

    $("#add_stop_btn").on("click", function() {
        if (stopIndex >= maxStops) {
            alert("Maximum 5 stops allowed.");
            return;
        }

        let html = `
            <div class="form-group row width-50 stop-block" id="stop_block_${stopIndex}">
                <label class="col-3 control-label">Stop ${stopIndex + 1}</label>
                <div class="col-7" style="margin-bottom: 5px;">
                    <input type="text"
                        name="stops[${stopIndex}][location]"
                        id="stop_location_${stopIndex}"
                        class="form-control stop-input"
                        placeholder="Enter stop location">

                    <input type="hidden" name="stops[${stopIndex}][latitude]" id="stop_lat_${stopIndex}">
                    <input type="hidden" name="stops[${stopIndex}][longitude]" id="stop_lng_${stopIndex}">
                </div>

                <div class="col-2">
                    <button type="button" class="btn btn-danger remove-stop" data-id="${stopIndex}">
                        X
                    </button>
                </div>
            </div>
        `;

        $("#stops_wrapper").append(html);

        initSingleStopAutocomplete(stopIndex);

        stopIndex++;
    });

    $(document).on("click", ".remove-stop", function() {

        // Remove the block
        $(this).closest(".stop-block").remove();

        // Renumber ALL stops
        $(".stop-block").each(function(i) {

            // Update label
            $(this).find("label.control-label").text("Stop " + (i + 1));

            // Update input names / IDs
            $(this).find("input.stop-input").attr("name", `stops[${i}][location]`)
                .attr("id", `stop_location_${i}`);

            $(this).find("input[id^='stop_lat_']").attr("name", `stops[${i}][latitude]`)
                .attr("id", `stop_lat_${i}`);

            $(this).find("input[id^='stop_lng_']").attr("name", `stops[${i}][longitude]`)
                .attr("id", `stop_lng_${i}`);

            // Update remove button ID
            $(this).find(".remove-stop").attr("data-id", i);

            // Update block ID
            $(this).attr("id", `stop_block_${i}`);
        });

        // Update stopIndex based on new count
        stopIndex = $(".stop-block").length;

        calculateDistanceDuration();
    });


    /* -----------------------------
       STOP AUTOCOMPLETE
    ------------------------------ */

    function initSingleStopAutocomplete(index) {
        let input = document.getElementById("stop_location_" + index);
        if (!input) return;

        let auto = new google.maps.places.Autocomplete(input);

        auto.addListener("place_changed", function() {
            let place = auto.getPlace();

            if (!place.geometry) {
                $("#stop_lat_" + index).val("");
                $("#stop_lng_" + index).val("");
                return;
            }

            $("#stop_lat_" + index).val(place.geometry.location.lat());
            $("#stop_lng_" + index).val(place.geometry.location.lng());

            if (sourceLat && destinationLat) calculateDistanceDuration();
        });
    }

    /* -----------------------------
       MULTI-LEG DISTANCE
    ------------------------------ */
    function calculateDistanceDuration() {

        let points = [];

        // SOURCE
        points.push({
            lat: sourceLat,
            lng: sourceLng
        });

        // STOPS
        $(".stop-block").each(function() {
            let index = $(this).attr("id").replace("stop_block_", "");
            let lat = $("#stop_lat_" + index).val();
            let lng = $("#stop_lng_" + index).val();

            if (lat && lng) {
                points.push({
                    lat: parseFloat(lat),
                    lng: parseFloat(lng)
                });
            }
        });


        // DESTINATION
        points.push({
            lat: destinationLat,
            lng: destinationLng
        });

        const service = new google.maps.DistanceMatrixService();

        let totalDistance = 0;
        let totalDuration = 0;

        let jobs = [];

        for (let i = 0; i < points.length - 1; i++) {
            jobs.push(
                new Promise((resolve, reject) => {
                    service.getDistanceMatrix({
                        origins: [points[i]],
                        destinations: [points[i + 1]],
                        travelMode: google.maps.TravelMode.DRIVING,
                    }, (response, status) => {

                        if (status !== "OK") return reject(status);
                        let result = response.rows[0].elements[0];
                        if (result.status !== "OK") return reject(result.status);

                        totalDistance += result.distance.value / 1000; // km
                        totalDuration += result.duration.value; // sec

                        resolve();
                    });
                })
            );
        }

        Promise.all(jobs).then(() => {

            let mins = Math.round(totalDuration / 60);
            let hrs = Math.floor(mins / 60);
            mins = mins % 60;

            $("#distance").val(totalDistance.toFixed(2));
            $("#distance_hidden").val(totalDistance.toFixed(2));

            $("#duration").val(`${hrs}h ${mins}m`);
            $("#duration_hidden").val(`${hrs}h ${mins}m`);
            if (selectedVehicleData) calculateCout(totalDistance, selectedVehicleData);

        }).catch(err => alert("Route error: " + err));
    }

    /* -----------------------------
       COST CALCULATION
    ------------------------------ */
    function calculateCout(distanceKm, vehicle) {
        let cout = 0;

        let baseKm = vehicle.outstationRadius;
        let baseCharge = vehicle.minimumDeliveryChargesWithin;
        let perKm = vehicle.deliveryCharges;
        let outKmRate = vehicle.outstationDeliveryChargePerKm;

        if (distanceKm <= baseKm) {
            cout = baseCharge + (distanceKm * perKm);
        } else {
            cout = baseCharge + (baseKm * perKm) + ((distanceKm - baseKm) * outKmRate);
        }

        $("#cout").val(cout.toFixed(2));
        $("#cout_hidden").val(cout.toFixed(2));
    }
</script>


<!-- <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBcVT2oJEsWpE6hDKU1M5791Q6jRQ4KUgI&libraries=places&callback=initAutocomplete"
    async defer></script> -->
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBcVT2oJEsWpE6hDKU1M5791Q6jRQ4KUgI&libraries=places&callback=initAutocompleteInit"
    async defer></script>


@endsection