<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tj_type_vehicule', function (Blueprint $table) {
            if (!Schema::hasColumn('tj_type_vehicule', 'commission_type')) {
                $table->string('commission_type')->nullable();
            }

            if (!Schema::hasColumn('tj_type_vehicule', 'custom_commission_type')) {
                $table->string('custom_commission_type')->nullable();
            }

            if (!Schema::hasColumn('tj_type_vehicule', 'admin_commission')) {
                $table->string('admin_commission')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tj_type_vehicule', function (Blueprint $table) {
            if (Schema::hasColumn('tj_type_vehicule', 'commission_type')) {
                $table->dropColumn('commission_type');
            }

            if (Schema::hasColumn('tj_type_vehicule', 'custom_commission_type')) {
                $table->dropColumn('custom_commission_type');
            }

            if (Schema::hasColumn('tj_type_vehicule', 'admin_commission')) {
                $table->dropColumn('admin_commission');
            }
        });
    }
};
