<?php

// namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
// use Illuminate\Database\Eloquent\Factories\HasFactory;
// use Illuminate\Foundation\Auth\User as Authenticatable;
// use Illuminate\Notifications\Notifiable;
// use Laravel\Sanctum\HasApiTokens;
// use Illuminate\Database\Eloquent\SoftDeletes;

// class Driver extends Authenticatable
// {
//     use HasApiTokens, HasFactory, Notifiable;
//     public $timestamps = false;
//     protected $table = 'tj_conducteur';
//     protected $fillable = [
//         'nom',
//         'email',
//         'prenom',
//         'phone',
//         'parcel_delivery'
//     ];
    
//     protected $casts = [
//     'id' => 'string',
//   ];

// }


namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\SoftDeletes;

class Driver extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    public $timestamps = false;

    protected $table = 'tj_conducteur';

    protected $fillable = [
        'nom',
        'email',
        'prenom',
        'phone',
        'parcel_delivery',
        'photo_path' // Add photo_path here if it is fillable
    ];

    protected $casts = [
        'id' => 'string',
    ];

    protected $appends = ['driver_name', 'photo_url'];

    public function getDriverNameAttribute()
    {
        return trim($this->nom . ' ' . $this->prenom);
    }

    public function getPhotoUrlAttribute()
    {
        if (empty($this->photo_path)) {
            return null;
        }
      return url('/assets/images/driver/' . ltrim($this->photo_path, '/'));
    }
}
