<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Log;
use App\Models\Complaints;
use App\Models\UserNote;
use App\Http\Controllers\API\v1\GcmController;
use App\Models\DriverAssignSetting;
use App\Jobs\SendNotificationJob;
use App\Models\Note;
use App\Models\Currency;
use App\Models\Requests;
use Illuminate\Support\Facades\Bus;
use App\Models\Rides;
use App\Models\Driver;
use App\Models\Zone;
use App\Models\Vehicle;
use App\Models\Settings;
use App\Models\Rentalpackages;
use App\Models\RequestToDriver;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\DateTime;
use Carbon\Carbon;


use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use Exception;

class SeatSharingRideController extends Controller
{
  
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function all(Request $request, $id = null)
    {

        // dd($request->all());         

        $currency = Currency::where('statut', 'yes')->first();
        if ($request->has('datepicker_from') && $request->datepicker_from != '' && $request->has('datepicker_to') && $request->datepicker_to != '') {
            $fromDate = $request->input('datepicker_from');
            $toDate = $request->input('datepicker_to');

            $rides = Requests::query()
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->leftjoin('tj_type_vehicule', 'tj_type_vehicule.id', '=', 'tj_requete.vehicle_id')
                ->select('tj_requete.id', 'tj_requete.advance_payment', 'tj_requete.remaining_payment', 'tj_requete.statut', 'tj_requete.ride_type', 'tj_requete.dispatcher_id', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.user_info', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image','tj_requete.heure_retour' ,'tj_requete.date_retour','tj_requete.return_date','tj_requete.return_hour','tj_type_vehicule.libelle as vehicle_name')
                ->whereDate('tj_requete.creer', '>=', $fromDate)
                ->whereDate('tj_requete.creer', '<=', $toDate)
                ->where('tj_requete.deleted_at', '=', NULL);
            if ($id != '' || $id != null) {
                $rides->where('tj_requete.id_conducteur', '=', $id);
            }

            $rides = $rides->whereNull('tj_requete.rental_package_id')->orderBy('tj_requete.id', 'desc')->paginate(20);
        } else if ($request->has('datepicker_from') && $request->datepicker_from != '') {
            $fromDate = $request->input('datepicker_from');

            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->leftjoin('tj_type_vehicule', 'tj_type_vehicule.id', '=', 'tj_requete.vehicle_id')
                ->select('tj_requete.id', 'tj_requete.advance_payment', 'tj_requete.remaining_payment', 'tj_requete.ride_type', 'tj_requete.dispatcher_id', 'tj_requete.user_info', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image','tj_requete.heure_retour' ,'tj_requete.date_retour','tj_requete.return_date','tj_requete.return_hour','tj_type_vehicule.libelle as vehicle_name')
                ->whereDate('tj_requete.creer', '>=', $fromDate)
                ->where('tj_requete.deleted_at', '=', NULL);
            if ($id != '' || $id != null) {
                $rides->where('tj_requete.id_conducteur', '=', $id);
            }

            $rides = $rides->whereNull('tj_requete.rental_package_id')->orderBy('tj_requete.id', 'desc')->paginate(20);
        } else if ($request->has('datepicker_to') && $request->datepicker_to != '') {
            $toDate = $request->input('datepicker_to');

            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->leftjoin('tj_type_vehicule', 'tj_type_vehicule.id', '=', 'tj_requete.vehicle_id')
                ->select('tj_requete.id', 'tj_requete.advance_payment', 'tj_requete.remaining_payment', 'tj_requete.ride_type', 'tj_requete.dispatcher_id', 'tj_requete.user_info', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image','tj_requete.heure_retour' ,'tj_requete.date_retour','tj_requete.return_date','tj_requete.return_hour','tj_type_vehicule.libelle as vehicle_name')
                ->whereDate('tj_requete.creer', '<=', $toDate)
                ->where('tj_requete.deleted_at', '=', NULL);
            if ($id != '' || $id != null) {
                $rides->where('tj_requete.id_conducteur', '=', $id);
            }

            $rides = $rides->whereNull('tj_requete.rental_package_id')->orderBy('tj_requete.id', 'desc')->paginate(20);
        } else if ($request->selected_search == 'userName' && $request->has('search') && $request->search != '') {


            $search = $request->input('search');
            //$searchs = explode(" ", $search);
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->leftjoin('tj_type_vehicule', 'tj_type_vehicule.id', '=', 'tj_requete.vehicle_id')
                ->select('tj_requete.id', 'tj_requete.advance_payment', 'tj_requete.remaining_payment', 'tj_requete.statut', 'tj_requete.ride_type', 'tj_requete.dispatcher_id', 'tj_requete.user_info', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image' , 'tj_user_app.phone as user_phone',    'tj_requete.razorpay_transaction_id',   'tj_conducteur.phone as driver_phone',   'tj_requete.id_payment_method','tj_requete.heure_retour' ,'tj_requete.date_retour','tj_requete.return_date','tj_requete.return_hour','tj_type_vehicule.libelle as vehicle_name');
            if ($id != '' || $id != null) {
                $rides->where('tj_user_app.prenom', 'LIKE', '%' . $search . '%')->where('tj_requete.id_conducteur', '=', $id);
                $rides->orwhere('tj_user_app.nom', 'LIKE', '%' . $search . '%')->where('tj_requete.id_conducteur', '=', $id);
                $rides->orWhere(DB::raw('CONCAT(tj_user_app.prenom, " ",tj_user_app.nom)'), 'LIKE', '%' . $search . '%')->where('tj_requete.id_conducteur', '=', $id);
            } else {
                $rides->where('tj_user_app.prenom', 'LIKE', '%' . $search . '%');
                $rides->orwhere('tj_user_app.nom', 'LIKE', '%' . $search . '%');
                $rides->orWhere(DB::raw('CONCAT(tj_user_app.prenom, " ",tj_user_app.nom)'), 'LIKE', '%' . $search . '%');
            }
            $rides->where('tj_requete.deleted_at', '=', NULL);
            if ($id != '' || $id != null) {
                $rides->where('tj_requete.id_conducteur', '=', $id);
            }

            // dd($rides->toSql());
            
            $rides = $rides->whereNull('tj_requete.rental_package_id')->orderBy('tj_requete.id', 'desc')->paginate(20);
            // dd($rides);


        } else if ($request->selected_search == 'driverName' && $request->has('search') && $request->search != '') {
            $search = $request->input('search');
            //$searchs = explode(" ", $search);
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->leftjoin('tj_type_vehicule', 'tj_type_vehicule.id', '=', 'tj_requete.vehicle_id')
                ->select('tj_requete.id', 'tj_requete.advance_payment', 'tj_requete.remaining_payment', 'tj_requete.statut', 'tj_requete.ride_type', 'tj_requete.dispatcher_id', 'tj_requete.user_info', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image' ,  'tj_user_app.phone as user_phone',    'tj_requete.razorpay_transaction_id',   'tj_conducteur.phone as driver_phone',   'tj_requete.id_payment_method','tj_requete.heure_retour' ,'tj_requete.date_retour','tj_requete.return_date','tj_requete.return_hour','tj_type_vehicule.libelle as vehicle_name');
            if ($id != '' || $id != null) {
                $rides->where('tj_conducteur.prenom', 'LIKE', '%' . $search . '%')->where('tj_requete.id_conducteur', '=', $id);
                $rides->orwhere('tj_conducteur.nom', 'LIKE', '%' . $search . '%')->where('tj_requete.id_conducteur', '=', $id);
                $rides->orWhere(DB::raw('CONCAT(tj_conducteur.prenom, " ",tj_conducteur.nom)'), 'LIKE', '%' . $search . '%')->where('tj_requete.id_conducteur', '=', $id);
            } else {
                $rides->where('tj_conducteur.prenom', 'LIKE', '%' . $search . '%');
                $rides->orwhere('tj_conducteur.nom', 'LIKE', '%' . $search . '%');
                $rides->orWhere(DB::raw('CONCAT(tj_conducteur.prenom, " ",tj_conducteur.nom)'), 'LIKE', '%' . $search . '%');
            }
            $rides->where('tj_requete.deleted_at', '=', NULL);
            if ($id != '' || $id != null) {
                $rides->where('tj_requete.id_conducteur', '=', $id);
            }

            $rides = $rides->whereNull('tj_requete.rental_package_id')->orderBy('tj_requete.id', 'desc')->paginate(20);
        } else if ($request->selected_search == 'status' && $request->has('ride_status') && $request->ride_status != '') {
            $search = $request->input('ride_status');

            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->leftjoin('tj_type_vehicule', 'tj_type_vehicule.id', '=', 'tj_requete.vehicle_id')
                ->select(
                    'tj_requete.id',
                    'tj_requete.advance_payment',
                    'tj_requete.remaining_payment',
                    'tj_requete.statut',
                    'tj_requete.ride_type',
                    'tj_requete.dispatcher_id',
                    'tj_requete.user_info',
                    'tj_requete.tip_amount',
                    'tj_requete.admin_commission',
                    'tj_requete.tax',
                    'tj_requete.discount',
                    'tj_requete.statut_paiement',
                    'tj_requete.depart_name',
                    'tj_requete.destination_name',
                    'tj_requete.distance',
                    'tj_requete.montant',
                    'tj_requete.creer',
                    'tj_conducteur.id as driver_id',
                    'tj_conducteur.prenom as driverPrenom',
                    'tj_conducteur.nom as driverNom',
                    'tj_user_app.id as user_id',
                    'tj_user_app.prenom as userPrenom',
                    'tj_user_app.nom as userNom',
                    'tj_payment_method.libelle',
                    'tj_payment_method.image',
                     'tj_user_app.phone as user_phone',    
                     'tj_requete.razorpay_transaction_id',  
                      'tj_conducteur.phone as driver_phone',  
                       'tj_requete.id_payment_method',
                       'tj_requete.heure_retour' ,'tj_requete.date_retour','tj_requete.return_date','tj_requete.return_hour','tj_type_vehicule.libelle as vehicle_name'
                )
                ->where('tj_requete.statut', 'LIKE', '%' . $search . '%')
                ->where('tj_requete.deleted_at', '=', NULL)
                ->whereNull('tj_requete.rental_package_id');
            if ($id != '' || $id != null) {
                $rides->where('tj_requete.id_conducteur', '=', $id);
            }

            $rides = $rides->orderBy('tj_requete.id', 'desc')->paginate(20);
        } else if ($request->selected_search == 'type' && $request->has('ride_type') && $request->ride_type != '') {
            $search = $request->input('ride_type');

            $query = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->leftjoin('tj_type_vehicule', 'tj_type_vehicule.id', '=', 'tj_requete.vehicle_id')
                ->select('tj_requete.id', 'tj_requete.advance_payment', 'tj_requete.remaining_payment', 'tj_requete.statut', 'tj_requete.ride_type', 'tj_requete.dispatcher_id', 'tj_requete.user_info', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image', 'tj_user_app.phone as user_phone',    'tj_requete.razorpay_transaction_id',   'tj_conducteur.phone as driver_phone',   'tj_requete.id_payment_method','tj_requete.heure_retour' ,'tj_requete.date_retour','tj_requete.return_date','tj_requete.return_hour','tj_type_vehicule.libelle as vehicle_name')
                ->whereNull('tj_requete.rental_package_id');
            // ->where('tj_requete.deleted_at', '=', NULL);
            if ($id != '' || $id != null) {
                $query->where('tj_requete.id_conducteur', '=', $id);
            }
            if ($search == "dispatcher") {
                $query->where('tj_requete.ride_type', 'dispatcher');
            } elseif ($search == "driver_created") {
                $query->where('tj_requete.ride_type', 'driver');
            } else {
                $query->where('tj_requete.ride_type', NULL);
            }

            $rides = $query->orderBy('tj_requete.id', 'desc')->paginate(20);
        } else if ($request->selected_search == 'tripType' && $request->has('trip_type') && $request->trip_type != '') {
            $search = $request->input('trip_type');

            $query = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->leftjoin('tj_type_vehicule', 'tj_type_vehicule.id', '=', 'tj_requete.vehicle_id')
                ->select('tj_requete.id', 'tj_requete.advance_payment', 'tj_requete.remaining_payment', 'tj_requete.statut', 'tj_requete.ride_type', 'tj_requete.dispatcher_id', 'tj_requete.user_info', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image', 'tj_user_app.phone as user_phone',    'tj_requete.razorpay_transaction_id',   'tj_conducteur.phone as driver_phone',   'tj_requete.id_payment_method','tj_requete.heure_retour' ,'tj_requete.date_retour','tj_requete.return_date','tj_requete.return_hour','tj_type_vehicule.libelle as vehicle_name')
                ->whereNull('tj_requete.rental_package_id');
            // ->where('tj_requete.deleted_at', '=', NULL);
            if ($id != '' || $id != null) {
                $query->where('tj_requete.id_conducteur', '=', $id);
            }
            if ($search == "one_way") {
                $query->where('tj_requete.statut_round', 'no');
            } elseif ($search == "two_way") {
                $query->where('tj_requete.statut_round', 'yes');
            } else {
                $query->where('tj_requete.statut_round', NULL);
            }

            $rides = $query->orderBy('tj_requete.id', 'desc')->paginate(20);
        } else {

            // dd('come');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->leftjoin('tj_type_vehicule', 'tj_type_vehicule.id', '=', 'tj_requete.vehicle_id')
                ->select(
                    'tj_user_app.phone as user_phone',
                    'tj_conducteur.phone as driver_phone',
                    'tj_requete.id',
                    'tj_requete.advance_payment',
                    'tj_requete.remaining_payment',
                    'tj_requete.statut',
                    'tj_requete.ride_type',
                    'tj_requete.dispatcher_id',
                    'tj_requete.user_info',
                    'tj_requete.tip_amount',
                    'tj_requete.admin_commission',
                    'tj_requete.tax',
                    'tj_requete.discount',
                    'tj_requete.statut_paiement',
                    'tj_requete.depart_name',
                    'tj_requete.destination_name',
                    'tj_requete.distance',
                    'tj_requete.montant',
                    'tj_requete.creer',
                    'tj_conducteur.id as driver_id',
                    'tj_conducteur.prenom as driverPrenom',
                    'tj_conducteur.nom as driverNom',
                    'tj_requete.razorpay_transaction_id',
                    'tj_user_app.id as user_id',
                    'tj_user_app.prenom as userPrenom',
                    'tj_user_app.nom as userNom',
                    'tj_payment_method.libelle',
                    'tj_payment_method.image',
                    'tj_requete.transaction_id',
                    'tj_requete.id_payment_method',
                    'tj_requete.heure_retour'  ,'tj_requete.date_retour','tj_requete.return_date','tj_requete.return_hour','tj_type_vehicule.libelle as vehicle_name'
                )
                ->where('tj_requete.deleted_at', '=', NULL)
                ->whereNull('tj_requete.rental_package_id');
            if ($id != '' || $id != null) {
                $rides->where('tj_requete.id_conducteur', '=', $id);
            }
            $rides = $rides->orderBy('tj_requete.id', 'desc')->paginate(20);
        }

        return view("seat_sharing_rides.all")->with("rides", $rides)->with('currency', $currency)->with('id', $id);
    }

   
}