<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Log;
use App\Models\Complaints;
use App\Models\UserNote;
use App\Http\Controllers\API\v1\GcmController;
use App\Models\DriverAssignSetting;
use App\Jobs\SendNotificationJob;
use App\Models\Note;
use App\Models\Currency;
use App\Models\Requests;
use Illuminate\Support\Facades\Bus;
use App\Models\Rides;
use App\Models\Driver;
use App\Models\Zone;
use App\Models\Vehicle;
use App\Models\Settings;
use App\Models\Rentalpackages;
use App\Models\RequestToDriver;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\DateTime;
use Carbon\Carbon;


use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use Exception;

class RidesController extends Controller
{
  
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function all(Request $request, $id = null)
    {

        // dd($request->all());         

        $currency = Currency::where('statut', 'yes')->first();
        if ($request->has('datepicker_from') && $request->datepicker_from != '' && $request->has('datepicker_to') && $request->datepicker_to != '') {
            $fromDate = $request->input('datepicker_from');
            $toDate = $request->input('datepicker_to');

            $rides = Requests::query()
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->leftjoin('tj_type_vehicule', 'tj_type_vehicule.id', '=', 'tj_requete.vehicle_id')
                ->select('tj_requete.id', 'tj_requete.advance_payment', 'tj_requete.remaining_payment', 'tj_requete.statut', 'tj_requete.ride_type', 'tj_requete.dispatcher_id', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.user_info', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image','tj_requete.heure_retour' ,'tj_requete.date_retour','tj_requete.return_date','tj_requete.return_hour','tj_type_vehicule.libelle as vehicle_name')
                ->whereDate('tj_requete.creer', '>=', $fromDate)
                ->whereDate('tj_requete.creer', '<=', $toDate)
                ->where('tj_requete.deleted_at', '=', NULL);
            if ($id != '' || $id != null) {
                $rides->where('tj_requete.id_conducteur', '=', $id);
            }

            $rides = $rides->whereNull('tj_requete.rental_package_id')->orderBy('tj_requete.id', 'desc')->paginate(20);
        } else if ($request->has('datepicker_from') && $request->datepicker_from != '') {
            $fromDate = $request->input('datepicker_from');

            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->leftjoin('tj_type_vehicule', 'tj_type_vehicule.id', '=', 'tj_requete.vehicle_id')
                ->select('tj_requete.id', 'tj_requete.advance_payment', 'tj_requete.remaining_payment', 'tj_requete.ride_type', 'tj_requete.dispatcher_id', 'tj_requete.user_info', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image','tj_requete.heure_retour' ,'tj_requete.date_retour','tj_requete.return_date','tj_requete.return_hour','tj_type_vehicule.libelle as vehicle_name')
                ->whereDate('tj_requete.creer', '>=', $fromDate)
                ->where('tj_requete.deleted_at', '=', NULL);
            if ($id != '' || $id != null) {
                $rides->where('tj_requete.id_conducteur', '=', $id);
            }

            $rides = $rides->whereNull('tj_requete.rental_package_id')->orderBy('tj_requete.id', 'desc')->paginate(20);
        } else if ($request->has('datepicker_to') && $request->datepicker_to != '') {
            $toDate = $request->input('datepicker_to');

            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->leftjoin('tj_type_vehicule', 'tj_type_vehicule.id', '=', 'tj_requete.vehicle_id')
                ->select('tj_requete.id', 'tj_requete.advance_payment', 'tj_requete.remaining_payment', 'tj_requete.ride_type', 'tj_requete.dispatcher_id', 'tj_requete.user_info', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image','tj_requete.heure_retour' ,'tj_requete.date_retour','tj_requete.return_date','tj_requete.return_hour','tj_type_vehicule.libelle as vehicle_name')
                ->whereDate('tj_requete.creer', '<=', $toDate)
                ->where('tj_requete.deleted_at', '=', NULL);
            if ($id != '' || $id != null) {
                $rides->where('tj_requete.id_conducteur', '=', $id);
            }

            $rides = $rides->whereNull('tj_requete.rental_package_id')->orderBy('tj_requete.id', 'desc')->paginate(20);
        } else if ($request->selected_search == 'userName' && $request->has('search') && $request->search != '') {


            $search = $request->input('search');
            //$searchs = explode(" ", $search);
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->leftjoin('tj_type_vehicule', 'tj_type_vehicule.id', '=', 'tj_requete.vehicle_id')
                ->select('tj_requete.id', 'tj_requete.advance_payment', 'tj_requete.remaining_payment', 'tj_requete.statut', 'tj_requete.ride_type', 'tj_requete.dispatcher_id', 'tj_requete.user_info', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image' , 'tj_user_app.phone as user_phone',    'tj_requete.razorpay_transaction_id',   'tj_conducteur.phone as driver_phone',   'tj_requete.id_payment_method','tj_requete.heure_retour' ,'tj_requete.date_retour','tj_requete.return_date','tj_requete.return_hour','tj_type_vehicule.libelle as vehicle_name');
            if ($id != '' || $id != null) {
                $rides->where('tj_user_app.prenom', 'LIKE', '%' . $search . '%')->where('tj_requete.id_conducteur', '=', $id);
                $rides->orwhere('tj_user_app.nom', 'LIKE', '%' . $search . '%')->where('tj_requete.id_conducteur', '=', $id);
                $rides->orWhere(DB::raw('CONCAT(tj_user_app.prenom, " ",tj_user_app.nom)'), 'LIKE', '%' . $search . '%')->where('tj_requete.id_conducteur', '=', $id);
            } else {
                $rides->where('tj_user_app.prenom', 'LIKE', '%' . $search . '%');
                $rides->orwhere('tj_user_app.nom', 'LIKE', '%' . $search . '%');
                $rides->orWhere(DB::raw('CONCAT(tj_user_app.prenom, " ",tj_user_app.nom)'), 'LIKE', '%' . $search . '%');
            }
            $rides->where('tj_requete.deleted_at', '=', NULL);
            if ($id != '' || $id != null) {
                $rides->where('tj_requete.id_conducteur', '=', $id);
            }

            // dd($rides->toSql());
            
            $rides = $rides->whereNull('tj_requete.rental_package_id')->orderBy('tj_requete.id', 'desc')->paginate(20);
            // dd($rides);


        } else if ($request->selected_search == 'driverName' && $request->has('search') && $request->search != '') {
            $search = $request->input('search');
            //$searchs = explode(" ", $search);
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->leftjoin('tj_type_vehicule', 'tj_type_vehicule.id', '=', 'tj_requete.vehicle_id')
                ->select('tj_requete.id', 'tj_requete.advance_payment', 'tj_requete.remaining_payment', 'tj_requete.statut', 'tj_requete.ride_type', 'tj_requete.dispatcher_id', 'tj_requete.user_info', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image' ,  'tj_user_app.phone as user_phone',    'tj_requete.razorpay_transaction_id',   'tj_conducteur.phone as driver_phone',   'tj_requete.id_payment_method','tj_requete.heure_retour' ,'tj_requete.date_retour','tj_requete.return_date','tj_requete.return_hour','tj_type_vehicule.libelle as vehicle_name');
            if ($id != '' || $id != null) {
                $rides->where('tj_conducteur.prenom', 'LIKE', '%' . $search . '%')->where('tj_requete.id_conducteur', '=', $id);
                $rides->orwhere('tj_conducteur.nom', 'LIKE', '%' . $search . '%')->where('tj_requete.id_conducteur', '=', $id);
                $rides->orWhere(DB::raw('CONCAT(tj_conducteur.prenom, " ",tj_conducteur.nom)'), 'LIKE', '%' . $search . '%')->where('tj_requete.id_conducteur', '=', $id);
            } else {
                $rides->where('tj_conducteur.prenom', 'LIKE', '%' . $search . '%');
                $rides->orwhere('tj_conducteur.nom', 'LIKE', '%' . $search . '%');
                $rides->orWhere(DB::raw('CONCAT(tj_conducteur.prenom, " ",tj_conducteur.nom)'), 'LIKE', '%' . $search . '%');
            }
            $rides->where('tj_requete.deleted_at', '=', NULL);
            if ($id != '' || $id != null) {
                $rides->where('tj_requete.id_conducteur', '=', $id);
            }

            $rides = $rides->whereNull('tj_requete.rental_package_id')->orderBy('tj_requete.id', 'desc')->paginate(20);
        } else if ($request->selected_search == 'status' && $request->has('ride_status') && $request->ride_status != '') {
            $search = $request->input('ride_status');

            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->leftjoin('tj_type_vehicule', 'tj_type_vehicule.id', '=', 'tj_requete.vehicle_id')
                ->select(
                    'tj_requete.id',
                    'tj_requete.advance_payment',
                    'tj_requete.remaining_payment',
                    'tj_requete.statut',
                    'tj_requete.ride_type',
                    'tj_requete.dispatcher_id',
                    'tj_requete.user_info',
                    'tj_requete.tip_amount',
                    'tj_requete.admin_commission',
                    'tj_requete.tax',
                    'tj_requete.discount',
                    'tj_requete.statut_paiement',
                    'tj_requete.depart_name',
                    'tj_requete.destination_name',
                    'tj_requete.distance',
                    'tj_requete.montant',
                    'tj_requete.creer',
                    'tj_conducteur.id as driver_id',
                    'tj_conducteur.prenom as driverPrenom',
                    'tj_conducteur.nom as driverNom',
                    'tj_user_app.id as user_id',
                    'tj_user_app.prenom as userPrenom',
                    'tj_user_app.nom as userNom',
                    'tj_payment_method.libelle',
                    'tj_payment_method.image',
                     'tj_user_app.phone as user_phone',    
                     'tj_requete.razorpay_transaction_id',  
                      'tj_conducteur.phone as driver_phone',  
                       'tj_requete.id_payment_method',
                       'tj_requete.heure_retour' ,'tj_requete.date_retour','tj_requete.return_date','tj_requete.return_hour','tj_type_vehicule.libelle as vehicle_name'
                )
                ->where('tj_requete.statut', 'LIKE', '%' . $search . '%')
                ->where('tj_requete.deleted_at', '=', NULL)
                ->whereNull('tj_requete.rental_package_id');
            if ($id != '' || $id != null) {
                $rides->where('tj_requete.id_conducteur', '=', $id);
            }

            $rides = $rides->orderBy('tj_requete.id', 'desc')->paginate(20);
        } else if ($request->selected_search == 'type' && $request->has('ride_type') && $request->ride_type != '') {
            $search = $request->input('ride_type');

            $query = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->leftjoin('tj_type_vehicule', 'tj_type_vehicule.id', '=', 'tj_requete.vehicle_id')
                ->select('tj_requete.id', 'tj_requete.advance_payment', 'tj_requete.remaining_payment', 'tj_requete.statut', 'tj_requete.ride_type', 'tj_requete.dispatcher_id', 'tj_requete.user_info', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image', 'tj_user_app.phone as user_phone',    'tj_requete.razorpay_transaction_id',   'tj_conducteur.phone as driver_phone',   'tj_requete.id_payment_method','tj_requete.heure_retour' ,'tj_requete.date_retour','tj_requete.return_date','tj_requete.return_hour','tj_type_vehicule.libelle as vehicle_name')
                ->whereNull('tj_requete.rental_package_id');
            // ->where('tj_requete.deleted_at', '=', NULL);
            if ($id != '' || $id != null) {
                $query->where('tj_requete.id_conducteur', '=', $id);
            }
            if ($search == "dispatcher") {
                $query->where('tj_requete.ride_type', 'dispatcher');
            } elseif ($search == "driver_created") {
                $query->where('tj_requete.ride_type', 'driver');
            } else {
                $query->where('tj_requete.ride_type', NULL);
            }

            $rides = $query->orderBy('tj_requete.id', 'desc')->paginate(20);
        } else if ($request->selected_search == 'tripType' && $request->has('trip_type') && $request->trip_type != '') {
            $search = $request->input('trip_type');

            $query = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->leftjoin('tj_type_vehicule', 'tj_type_vehicule.id', '=', 'tj_requete.vehicle_id')
                ->select('tj_requete.id', 'tj_requete.advance_payment', 'tj_requete.remaining_payment', 'tj_requete.statut', 'tj_requete.ride_type', 'tj_requete.dispatcher_id', 'tj_requete.user_info', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image', 'tj_user_app.phone as user_phone',    'tj_requete.razorpay_transaction_id',   'tj_conducteur.phone as driver_phone',   'tj_requete.id_payment_method','tj_requete.heure_retour' ,'tj_requete.date_retour','tj_requete.return_date','tj_requete.return_hour','tj_type_vehicule.libelle as vehicle_name')
                ->whereNull('tj_requete.rental_package_id');
            // ->where('tj_requete.deleted_at', '=', NULL);
            if ($id != '' || $id != null) {
                $query->where('tj_requete.id_conducteur', '=', $id);
            }
            if ($search == "one_way") {
                $query->where('tj_requete.statut_round', 'no');
            } elseif ($search == "two_way") {
                $query->where('tj_requete.statut_round', 'yes');
            } else {
                $query->where('tj_requete.statut_round', NULL);
            }

            $rides = $query->orderBy('tj_requete.id', 'desc')->paginate(20);
        } else {

            // dd('come');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->leftjoin('tj_type_vehicule', 'tj_type_vehicule.id', '=', 'tj_requete.vehicle_id')
                ->select(
                    'tj_user_app.phone as user_phone',
                    'tj_conducteur.phone as driver_phone',
                    'tj_requete.id',
                    'tj_requete.advance_payment',
                    'tj_requete.remaining_payment',
                    'tj_requete.statut',
                    'tj_requete.ride_type',
                    'tj_requete.dispatcher_id',
                    'tj_requete.user_info',
                    'tj_requete.tip_amount',
                    'tj_requete.admin_commission',
                    'tj_requete.tax',
                    'tj_requete.discount',
                    'tj_requete.statut_paiement',
                    'tj_requete.depart_name',
                    'tj_requete.destination_name',
                    'tj_requete.distance',
                    'tj_requete.montant',
                    'tj_requete.creer',
                    'tj_conducteur.id as driver_id',
                    'tj_conducteur.prenom as driverPrenom',
                    'tj_conducteur.nom as driverNom',
                    'tj_requete.razorpay_transaction_id',
                    'tj_user_app.id as user_id',
                    'tj_user_app.prenom as userPrenom',
                    'tj_user_app.nom as userNom',
                    'tj_payment_method.libelle',
                    'tj_payment_method.image',
                    'tj_requete.transaction_id',
                    'tj_requete.id_payment_method',
                    'tj_requete.heure_retour'  ,'tj_requete.date_retour','tj_requete.return_date','tj_requete.return_hour','tj_type_vehicule.libelle as vehicle_name'
                )
                ->where('tj_requete.deleted_at', '=', NULL)
                ->whereNull('tj_requete.rental_package_id');
            if ($id != '' || $id != null) {
                $rides->where('tj_requete.id_conducteur', '=', $id);
            }
            $rides = $rides->orderBy('tj_requete.id', 'desc')->paginate(20);
        }

        return view("rides.all")->with("rides", $rides)->with('currency', $currency)->with('id', $id);
    }

    public function rental_rides_all(Request $request, $id = null)
    {

        $currency = Currency::where('statut', 'yes')->first();
        if ($request->has('datepicker_from') && $request->datepicker_from != '' && $request->has('datepicker_to') && $request->datepicker_to != '') {
            $fromDate = $request->input('datepicker_from');
            $toDate = $request->input('datepicker_to');

            $rides = Requests::query()
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.advance_payment', 'tj_requete.remaining_payment', 'tj_requete.statut', 'tj_requete.ride_type', 'tj_requete.dispatcher_id', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.user_info', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->whereDate('tj_requete.creer', '>=', $fromDate)
                ->whereDate('tj_requete.creer', '<=', $toDate)
                ->where('tj_requete.deleted_at', '=', NULL)
                ->where('tj_requete.rental_package_id', '!=', NULL);
            if ($id != '' || $id != null) {
                $rides->where('tj_requete.id_conducteur', '=', $id);
            }

            $rides = $rides->orderBy('tj_requete.id', 'desc')->paginate(20);
        } else if ($request->has('datepicker_from') && $request->datepicker_from != '') {
            $fromDate = $request->input('datepicker_from');

            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.advance_payment', 'tj_requete.remaining_payment', 'tj_requete.ride_type', 'tj_requete.dispatcher_id', 'tj_requete.user_info', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->whereDate('tj_requete.creer', '>=', $fromDate)
                ->where('tj_requete.deleted_at', '=', NULL)
                ->where('tj_requete.rental_package_id', '!=', NULL);
            if ($id != '' || $id != null) {
                $rides->where('tj_requete.id_conducteur', '=', $id);
            }

            $rides = $rides->orderBy('tj_requete.id', 'desc')->paginate(20);
        } else if ($request->has('datepicker_to') && $request->datepicker_to != '') {
            $toDate = $request->input('datepicker_to');

            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.advance_payment', 'tj_requete.remaining_payment', 'tj_requete.ride_type', 'tj_requete.dispatcher_id', 'tj_requete.user_info', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->whereDate('tj_requete.creer', '<=', $toDate)
                ->where('tj_requete.deleted_at', '=', NULL)
                ->where('tj_requete.rental_package_id', '!=', NULL);
            if ($id != '' || $id != null) {
                $rides->where('tj_requete.id_conducteur', '=', $id);
            }

            $rides = $rides->orderBy('tj_requete.id', 'desc')->paginate(20);
        } else if ($request->selected_search == 'userName' && $request->has('search') && $request->search != '') {
            $search = $request->input('search');
            //$searchs = explode(" ", $search);
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut',  'tj_requete.advance_payment', 'tj_requete.remaining_payment', 'tj_requete.ride_type', 'tj_requete.dispatcher_id', 'tj_requete.user_info', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image');
            if ($id != '' || $id != null) {
                $rides->where('tj_user_app.prenom', 'LIKE', '%' . $search . '%')->where('tj_requete.id_conducteur', '=', $id);
                $rides->orwhere('tj_user_app.nom', 'LIKE', '%' . $search . '%')->where('tj_requete.id_conducteur', '=', $id);
                $rides->orWhere(DB::raw('CONCAT(tj_user_app.prenom, " ",tj_user_app.nom)'), 'LIKE', '%' . $search . '%')->where('tj_requete.id_conducteur', '=', $id);
            } else {
                $rides->where('tj_user_app.prenom', 'LIKE', '%' . $search . '%');
                $rides->orwhere('tj_user_app.nom', 'LIKE', '%' . $search . '%');
                $rides->orWhere(DB::raw('CONCAT(tj_user_app.prenom, " ",tj_user_app.nom)'), 'LIKE', '%' . $search . '%');
            }
            $rides->where('tj_requete.deleted_at', '=', NULL)
                ->where('tj_requete.rental_package_id', '!=', NULL);
            if ($id != '' || $id != null) {
                $rides->where('tj_requete.id_conducteur', '=', $id);
            }

            $rides = $rides->orderBy('tj_requete.id', 'desc')->paginate(20);
        } else if ($request->selected_search == 'driverName' && $request->has('search') && $request->search != '') {
            $search = $request->input('search');
            //$searchs = explode(" ", $search);
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->leftjoin('tj_requete.id', 'tj_requete.statut', 'tj_requete.ride_type', 'tj_requete.dispatcher_id', 'tj_requete.user_info', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image');
            if ($id != '' || $id != null) {
                $rides->where('tj_conducteur.prenom', 'LIKE', '%' . $search . '%')->where('tj_requete.id_conducteur', '=', $id);
                $rides->orwhere('tj_conducteur.nom', 'LIKE', '%' . $search . '%')->where('tj_requete.id_conducteur', '=', $id);
                $rides->orWhere(DB::raw('CONCAT(tj_conducteur.prenom, " ",tj_conducteur.nom)'), 'LIKE', '%' . $search . '%')->where('tj_requete.id_conducteur', '=', $id);
            } else {
                $rides->where('tj_conducteur.prenom', 'LIKE', '%' . $search . '%');
                $rides->orwhere('tj_conducteur.nom', 'LIKE', '%' . $search . '%');
                $rides->orWhere(DB::raw('CONCAT(tj_conducteur.prenom, " ",tj_conducteur.nom)'), 'LIKE', '%' . $search . '%');
            }
            $rides->where('tj_requete.deleted_at', '=', NULL)
                ->where('tj_requete.rental_package_id', '!=', NULL);
            if ($id != '' || $id != null) {
                $rides->where('tj_requete.id_conducteur', '=', $id);
            }

            $rides = $rides->orderBy('tj_requete.id', 'desc')->paginate(20);
        } else if ($request->selected_search == 'status' && $request->has('ride_status') && $request->ride_status != '') {
            $search = $request->input('ride_status');

            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.advance_payment', 'tj_requete.remaining_payment', 'tj_requete.statut', 'tj_requete.ride_type', 'tj_requete.dispatcher_id', 'tj_requete.user_info', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->where('tj_requete.statut', 'LIKE', '%' . $search . '%')
                ->where('tj_requete.deleted_at', '=', NULL)
                ->where('tj_requete.rental_package_id', '!=', NULL);
            if ($id != '' || $id != null) {
                $rides->where('tj_requete.id_conducteur', '=', $id);
            }

            $rides = $rides->orderBy('tj_requete.id', 'desc')->paginate(20);
        } else if ($request->selected_search == 'type' && $request->has('ride_type') && $request->ride_type != '') {
            $search = $request->input('ride_type');

            $query = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id',  'tj_requete.advance_payment', 'tj_requete.remaining_payment', 'tj_requete.statut', 'tj_requete.ride_type', 'tj_requete.dispatcher_id', 'tj_requete.user_info', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image');
            // ->where('tj_requete.deleted_at', '=', NULL);
            if ($id != '' || $id != null) {
                $query->where('tj_requete.id_conducteur', '=', $id);
            }
            if ($search == "dispatcher") {
                $query->where('tj_requete.ride_type', 'dispatcher');
            } elseif ($search == "driver_created") {
                $query->where('tj_requete.ride_type', 'driver');
            } else {
                $query->where('tj_requete.ride_type', NULL)
                    ->where('tj_requete.rental_package_id', '!=', NULL);
            }

            $rides = $query->orderBy('tj_requete.id', 'desc')->paginate(20);
        } else {
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->join('rental_packages', function ($join) {
                    $join->on('tj_requete.rental_package_id', '=', 'rental_packages.package_id')
                        ->on('tj_requete.vehicle_id', '=', 'rental_packages.vehicle_id');
                })
                ->leftjoin('tj_type_vehicule', 'tj_type_vehicule.id', '=', 'tj_requete.vehicle_id')
                ->distinct('tj_requete.rental_package_id', 'tj_requete.id')
                ->select(
                    'tj_requete.id',
                    'tj_requete.statut',
                    'tj_requete.ride_type',
                    'tj_requete.dispatcher_id',
                    'tj_requete.user_info',
                    'tj_requete.tip_amount',
                    'tj_requete.admin_commission',
                    'tj_requete.tax',
                    'tj_requete.discount',
                    'tj_requete.statut_paiement',
                    'tj_requete.depart_name',
                    'tj_requete.destination_name',
                    'tj_requete.distance',
                    'tj_requete.montant',
                    'tj_requete.creer',
                    'rental_packages.hours',
                    'rental_packages.kilometers',
                    'rental_packages.price',
                    'tj_type_vehicule.libelle as vehicle_libelle',
                    'tj_conducteur.id as driver_id',
                    'tj_conducteur.prenom as driverPrenom',
                    'tj_conducteur.nom as driverNom',
                    'tj_user_app.id as user_id',
                    'tj_user_app.prenom as userPrenom',
                    'tj_user_app.nom as userNom',
                    'tj_payment_method.libelle',
                    'tj_payment_method.image',
                    'tj_requete.advance_payment',
                    'tj_requete.remaining_payment',
                    'tj_user_app.phone as user_phone',
                    'tj_conducteur.phone as driver_phone',
                    'tj_requete.razorpay_transaction_id',
                    'tj_requete.transaction_id',
                    'tj_requete.id_payment_method',
                )
                ->where('tj_requete.deleted_at', '=', NULL)
                ->whereNotNull('tj_requete.rental_package_id');
            if ($id != '' || $id != null) {
                $rides->where('tj_requete.id_conducteur', '=', $id);
            }     

            $rides = $rides->groupBy('tj_requete.id')->orderBy('tj_requete.id', 'desc')->paginate(20);

            // dd($rides);
        }

        return view("rides.all_rental_rides")->with("rides", $rides)->with('currency', $currency)->with('id', $id);
    }
    public function new(Request $request)
    {
        $currency = Currency::where('statut', 'yes')->first();
        if ($request->has('datepicker_from') && $request->datepicker_from != '' && $request->has('datepicker_to') && $request->datepicker_to != '') {
            $fromDate = $request->input('datepicker_from');
            $toDate = $request->input('datepicker_to');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'new')
                ->whereDate('tj_requete.creer', '>=', $fromDate)
                ->whereDate('tj_requete.creer', '<=', $toDate)
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->has('datepicker_from') && $request->datepicker_from != '') {
            $fromDate = $request->input('datepicker_from');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'new')
                ->whereDate('tj_requete.creer', '>=', $fromDate)
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->has('datepicker_to') && $request->datepicker_to != '') {
            $toDate = $request->input('datepicker_to');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'new')
                ->whereDate('tj_requete.creer', '<=', $toDate)
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->selected_search == 'userPrenom' && $request->has('search') && $request->search != '') {

            $search = $request->input('search');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image', 'tj_user_app.id as id_user_app', 'tj_requete.id_conducteur')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'new')
                ->where(function ($query) use ($search) {
                    $query->where('tj_requete.depart_name', 'LIKE', '%' . $search . '%')
                        ->orWhere('tj_requete.destination_name', 'LIKE', '%' . $search . '%')
                        ->orwhere('tj_user_app.prenom', 'LIKE', '%' . $search . '%')
                        ->orwhere('tj_user_app.nom', 'LIKE', '%' . $search . '%')
                        ->orWhere(DB::raw('CONCAT(tj_user_app.prenom, " ",tj_user_app.nom)'), 'LIKE', '%' . $search . '%');
                })
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->selected_search == 'driverPrenom' && $request->has('search') && $request->search != '') {

            $search = $request->input('search');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image', 'tj_user_app.id as id_user_app', 'tj_requete.id_conducteur')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'new')
                ->where(function ($query) use ($search) {
                    $query->where('tj_requete.depart_name', 'LIKE', '%' . $search . '%')
                        ->orWhere('tj_requete.destination_name', 'LIKE', '%' . $search . '%')
                        ->orWhere('tj_conducteur.prenom', 'LIKE', '%' . $search . '%')
                        ->orwhere('tj_conducteur.nom', 'LIKE', '%' . $search . '%')
                        ->orWhere(DB::raw('CONCAT(tj_conducteur.prenom, " ",tj_conducteur.nom)'), 'LIKE', '%' . $search . '%');
                })
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->selected_search == 'status' && $request->has('ride_status') && $request->ride_status != '') {
            $search = $request->input('ride_status');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image', 'tj_user_app.id as id_user_app', 'tj_requete.id_conducteur')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'new')
                ->where(function ($query) use ($search) {
                    $query->where('tj_requete.depart_name', 'LIKE', '%' . $search . '%')
                        ->orWhere('tj_requete.destination_name', 'LIKE', '%' . $search . '%')
                        ->orwhere('tj_requete.statut', 'LIKE', '%' . $search . '%');
                })
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else {
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.id_user_app', 'tj_requete.id_conducteur', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'new')
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        }

        return view("rides.new")->with("rides", $rides)->with('currency', $currency);
    }

    public function confirmed(Request $request)
    {
        $currency = Currency::where('statut', 'yes')->first();
        if ($request->has('datepicker_from') && $request->datepicker_from != '' && $request->has('datepicker_to') && $request->datepicker_to != '') {
            $fromDate = $request->input('datepicker_from');
            $toDate = $request->input('datepicker_to');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'confirmed')
                ->whereDate('tj_requete.creer', '>=', $fromDate)
                ->whereDate('tj_requete.creer', '<=', $toDate)
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->has('datepicker_from') && $request->datepicker_from != '') {
            $fromDate = $request->input('datepicker_from');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'confirmed')
                ->whereDate('tj_requete.creer', '>=', $fromDate)
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->has('datepicker_to') && $request->datepicker_to != '') {
            $toDate = $request->input('datepicker_to');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'confirmed')
                ->whereDate('tj_requete.creer', '<=', $toDate)
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->selected_search == 'userPrenom' && $request->has('search') && $request->search != '') {

            $search = $request->input('search');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image', 'tj_requete.id_user_app', 'tj_requete.id_conducteur')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'confirmed')
                ->where(function ($query) use ($search) {
                    $query->where('tj_requete.depart_name', 'LIKE', '%' . $search . '%')
                        ->orWhere('tj_requete.destination_name', 'LIKE', '%' . $search . '%')
                        ->orwhere('tj_user_app.prenom', 'LIKE', '%' . $search . '%')
                        ->orwhere('tj_user_app.nom', 'LIKE', '%' . $search . '%')
                        ->orWhere(DB::raw('CONCAT(tj_user_app.prenom, " ",tj_user_app.nom)'), 'LIKE', '%' . $search . '%');
                })
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->selected_search == 'driverPrenom' && $request->has('search') && $request->search != '') {

            $search = $request->input('search');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image', 'tj_requete.id_user_app', 'tj_requete.id_conducteur')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'confirmed')
                ->where(function ($query) use ($search) {
                    $query->where('tj_requete.depart_name', 'LIKE', '%' . $search . '%')
                        ->orWhere('tj_requete.destination_name', 'LIKE', '%' . $search . '%')
                        ->orWhere('tj_conducteur.prenom', 'LIKE', '%' . $search . '%')
                        ->orwhere('tj_conducteur.nom', 'LIKE', '%' . $search . '%')
                        ->orWhere(DB::raw('CONCAT(tj_conducteur.prenom, " ",tj_conducteur.nom)'), 'LIKE', '%' . $search . '%');
                })
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->selected_search == 'status' && $request->has('ride_status') && $request->ride_status != '') {
            $search = $request->input('ride_status');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image', 'tj_requete.id_user_app', 'tj_requete.id_conducteur')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'confirmed')
                ->where(function ($query) use ($search) {
                    $query->where('tj_requete.depart_name', 'LIKE', '%' . $search . '%')
                        ->orWhere('tj_requete.destination_name', 'LIKE', '%' . $search . '%')
                        ->orwhere('tj_requete.statut', 'LIKE', '%' . $search . '%');
                })
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else {
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.id_user_app', 'tj_requete.id_conducteur', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'confirmed')
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        }

        return view("rides.confirmed")->with("rides", $rides)->with('currency', $currency);
    }


    public function onRide(Request $request)
    {

        $currency = Currency::where('statut', 'yes')->first();
        if ($request->has('datepicker_from') && $request->datepicker_from != '' && $request->has('datepicker_to') && $request->datepicker_to != '') {
            $fromDate = $request->input('datepicker_from');
            $toDate = $request->input('datepicker_to');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'on ride')
                ->whereDate('tj_requete.creer', '>=', $fromDate)
                ->whereDate('tj_requete.creer', '<=', $toDate)
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->has('datepicker_from') && $request->datepicker_from != '') {
            $fromDate = $request->input('datepicker_from');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'on ride')
                ->whereDate('tj_requete.creer', '>=', $fromDate)
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->has('datepicker_to') && $request->datepicker_to != '') {
            $toDate = $request->input('datepicker_to');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'on ride')
                ->whereDate('tj_requete.creer', '<=', $toDate)
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->selected_search == 'userPrenom' && $request->has('search') && $request->search != '') {

            $search = $request->input('search');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image', 'tj_requete.id_user_app', 'tj_requete.id_conducteur')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'on ride')
                ->where(function ($query) use ($search) {
                    $query->where('tj_requete.depart_name', 'LIKE', '%' . $search . '%')
                        ->orWhere('tj_requete.destination_name', 'LIKE', '%' . $search . '%')
                        ->orwhere('tj_user_app.prenom', 'LIKE', '%' . $search . '%')
                        ->orwhere('tj_user_app.nom', 'LIKE', '%' . $search . '%')
                        ->orWhere(DB::raw('CONCAT(tj_user_app.prenom, " ",tj_user_app.nom)'), 'LIKE', '%' . $search . '%');
                })
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->selected_search == 'driverPrenom' && $request->has('search') && $request->search != '') {
            $search = $request->input('search');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image', 'tj_requete.id_user_app', 'tj_requete.id_conducteur')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'on ride')
                ->where(function ($query) use ($search) {
                    $query->where('tj_requete.depart_name', 'LIKE', '%' . $search . '%')
                        ->orWhere('tj_requete.destination_name', 'LIKE', '%' . $search . '%')
                        ->orWhere('tj_conducteur.prenom', 'LIKE', '%' . $search . '%')
                        ->orwhere('tj_conducteur.nom', 'LIKE', '%' . $search . '%')
                        ->orWhere(DB::raw('CONCAT(tj_conducteur.prenom, " ",tj_conducteur.nom)'), 'LIKE', '%' . $search . '%');
                })
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->selected_search == 'status' && $request->has('ride_status') && $request->ride_status != '') {
            $search = $request->input('ride_status');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image', 'tj_requete.id_user_app', 'tj_requete.id_conducteur')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'on ride')
                ->where(function ($query) use ($search) {
                    $query->where('tj_requete.depart_name', 'LIKE', '%' . $search . '%')
                        ->orWhere('tj_requete.destination_name', 'LIKE', '%' . $search . '%')
                        ->orwhere('tj_requete.statut', 'LIKE', '%' . $search . '%');
                })
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else {
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.id_user_app', 'tj_requete.id_conducteur', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'on ride')
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        }
        return view("rides.onride")->with("rides", $rides)->with('currency', $currency);
    }

    public function rejected(Request $request)
    {
        $currency = Currency::where('statut', 'yes')->first();
        if ($request->has('datepicker_from') && $request->datepicker_from != '' && $request->has('datepicker_to') && $request->datepicker_to != '') {
            $fromDate = $request->input('datepicker_from');
            $toDate = $request->input('datepicker_to');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->orderBy('tj_requete.creer', 'DESC')
                ->Where(function ($query) {
                    $query->where('tj_requete.statut', 'rejected')
                        ->orwhere('tj_requete.statut', 'canceled');
                })
                ->whereDate('tj_requete.creer', '>=', $fromDate)
                ->whereDate('tj_requete.creer', '<=', $toDate)
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->has('datepicker_from') && $request->datepicker_from != '') {
            $fromDate = $request->input('datepicker_from');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->orderBy('tj_requete.creer', 'DESC')
                ->Where(function ($query) {
                    $query->where('tj_requete.statut', 'rejected')
                        ->orwhere('tj_requete.statut', 'canceled');
                })
                ->whereDate('tj_requete.creer', '>=', $fromDate)
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->has('datepicker_to') && $request->datepicker_to != '') {
            $toDate = $request->input('datepicker_to');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->orderBy('tj_requete.creer', 'DESC')
                ->Where(function ($query) {
                    $query->where('tj_requete.statut', 'rejected')
                        ->orwhere('tj_requete.statut', 'canceled');
                })
                ->whereDate('tj_requete.creer', '<=', $toDate)
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->selected_search == 'userPrenom' && $request->has('search') && $request->search != '') {
            $search = $request->input('search');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image', 'tj_requete.id_user_app', 'tj_requete.id_conducteur')
                ->orderBy('tj_requete.creer', 'DESC')
                ->Where(function ($query) {
                    $query->where('tj_requete.statut', 'rejected')
                        ->orwhere('tj_requete.statut', 'canceled');
                })
                ->where(function ($query) use ($search) {
                    $query->where('tj_requete.depart_name', 'LIKE', '%' . $search . '%')
                        ->orWhere('tj_requete.destination_name', 'LIKE', '%' . $search . '%')
                        //->orwhere('tj_requete.statut', 'LIKE', '%' . $search . '%')
                        //->orWhere('tj_conducteur.prenom', 'LIKE', '%' . $search . '%')
                        //->orwhere('tj_conducteur.nom', 'LIKE', '%' . $search . '%')
                        ->orwhere('tj_user_app.prenom', 'LIKE', '%' . $search . '%')
                        ->orwhere('tj_user_app.nom', 'LIKE', '%' . $search . '%')
                        //->orWhere(DB::raw('CONCAT(tj_conducteur.prenom, " ",tj_conducteur.nom)'), 'LIKE', '%' . $search . '%')
                        ->orWhere(DB::raw('CONCAT(tj_user_app.prenom, " ",tj_user_app.nom)'), 'LIKE', '%' . $search . '%');
                })
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->selected_search == 'driverPrenom' && $request->has('search') && $request->search != '') {
            $search = $request->input('search');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image', 'tj_requete.id_user_app', 'tj_requete.id_conducteur')
                ->orderBy('tj_requete.creer', 'DESC')
                ->Where(function ($query) {
                    $query->where('tj_requete.statut', 'rejected')
                        ->orwhere('tj_requete.statut', 'canceled');
                })
                ->where(function ($query) use ($search) {
                    $query->where('tj_requete.depart_name', 'LIKE', '%' . $search . '%')
                        ->orWhere('tj_requete.destination_name', 'LIKE', '%' . $search . '%')
                        //->orwhere('tj_requete.statut', 'LIKE', '%' . $search . '%')
                        ->orWhere('tj_conducteur.prenom', 'LIKE', '%' . $search . '%')
                        ->orwhere('tj_conducteur.nom', 'LIKE', '%' . $search . '%')
                        //->orwhere('tj_user_app.prenom', 'LIKE', '%' . $search . '%')
                        //->orwhere('tj_user_app.nom', 'LIKE', '%' . $search . '%')
                        ->orWhere(DB::raw('CONCAT(tj_conducteur.prenom, " ",tj_conducteur.nom)'), 'LIKE', '%' . $search . '%');
                    //->orWhere(DB::raw('CONCAT(tj_user_app.prenom, " ",tj_user_app.nom)'), 'LIKE', '%' . $search . '%');
                })
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->selected_search == 'status' && $request->has('ride_status') && $request->ride_status != '') {
            $search = $request->input('ride_status');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image', 'tj_requete.id_user_app', 'tj_requete.id_conducteur')
                ->orderBy('tj_requete.creer', 'DESC')
                ->Where(function ($query) {
                    $query->where('tj_requete.statut', 'rejected')
                        ->orwhere('tj_requete.statut', 'canceled');
                })
                ->where(function ($query) use ($search) {
                    $query->where('tj_requete.depart_name', 'LIKE', '%' . $search . '%')
                        ->orWhere('tj_requete.destination_name', 'LIKE', '%' . $search . '%')
                        ->orwhere('tj_requete.statut', 'LIKE', '%' . $search . '%');
                })
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else {
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.id_user_app', 'tj_requete.id_conducteur', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->orderBy('tj_requete.creer', 'DESC')
                ->Where(function ($query) {
                    $query->where('tj_requete.statut', 'rejected')
                        ->orwhere('tj_requete.statut', 'canceled');
                })
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        }
        return view("rides.rejected")->with("rides", $rides)->with('currency', $currency);
    }

    public function completed(Request $request)
    {
        $currency = Currency::where('statut', 'yes')->first();
        if ($request->has('datepicker_from') && $request->datepicker_from != '' && $request->has('datepicker_to') && $request->datepicker_to != '') {
            $fromDate = $request->input('datepicker_from');
            $toDate = $request->input('datepicker_to');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'completed')
                ->whereDate('tj_requete.creer', '>=', $fromDate)
                ->whereDate('tj_requete.creer', '<=', $toDate)
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->has('datepicker_from') && $request->datepicker_from != '') {
            $fromDate = $request->input('datepicker_from');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'completed')
                ->whereDate('tj_requete.creer', '>=', $fromDate)
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->has('datepicker_to') && $request->datepicker_to != '') {
            $toDate = $request->input('datepicker_to');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'completed')
                ->whereDate('tj_requete.creer', '<=', $toDate)
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->selected_search == 'userPrenom' && $request->has('search') && $request->search != '') {

            $search = $request->input('search');
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image', 'tj_requete.id_user_app', 'tj_requete.id_conducteur')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'completed')
                ->where(function ($query) use ($search) {
                    $query->where('tj_requete.depart_name', 'LIKE', '%' . $search . '%')
                        ->orWhere('tj_requete.destination_name', 'LIKE', '%' . $search . '%')
                        ->orwhere('tj_user_app.prenom', 'LIKE', '%' . $search . '%')
                        ->orwhere('tj_user_app.nom', 'LIKE', '%' . $search . '%')
                        ->orWhere(DB::raw('CONCAT(tj_user_app.prenom, " ",tj_user_app.nom)'), 'LIKE', '%' . $search . '%');
                })
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->selected_search == 'driverPrenom' && $request->has('search') && $request->search != '') {
            $search = $request->input('search');
            $rides = DB::table('tj_requete')
                ->join('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image', 'tj_requete.id_user_app', 'tj_requete.id_conducteur')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'completed')
                ->where(function ($query) use ($search) {
                    $query->where('tj_requete.depart_name', 'LIKE', '%' . $search . '%')
                        ->orWhere('tj_requete.destination_name', 'LIKE', '%' . $search . '%')
                        ->orWhere('tj_conducteur.prenom', 'LIKE', '%' . $search . '%')
                        ->orwhere('tj_conducteur.nom', 'LIKE', '%' . $search . '%')
                        ->orWhere(DB::raw('CONCAT(tj_conducteur.prenom, " ",tj_conducteur.nom)'), 'LIKE', '%' . $search . '%');
                })
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else if ($request->selected_search == 'status' && $request->has('ride_status') && $request->ride_status != '') {
            $search = $request->input('ride_status');
            $rides = DB::table('tj_requete')
                ->join('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image', 'tj_requete.id_user_app', 'tj_requete.id_conducteur')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'completed')
                ->where(function ($query) use ($search) {
                    $query->where('tj_requete.depart_name', 'LIKE', '%' . $search . '%')
                        ->orWhere('tj_requete.destination_name', 'LIKE', '%' . $search . '%')
                        ->orwhere('tj_requete.statut', 'LIKE', '%' . $search . '%');
                })
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        } else {
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.tip_amount', 'tj_requete.admin_commission', 'tj_requete.tax', 'tj_requete.discount', 'tj_requete.id_user_app', 'tj_requete.id_conducteur', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
                ->orderBy('tj_requete.creer', 'DESC')
                ->where('tj_requete.statut', 'completed')
                ->where('tj_requete.deleted_at', '=', NULL)
                ->paginate(20);
        }
        return view("rides.completed")->with("rides", $rides)->with('currency', $currency);
    }

    public function filterRides(Request $request)
    {
        $page = $request->input('pageName');
        $fromDate = $request->input('datepicker-from');
        $toDate = $request->input('datepicker-to');

        if ($page == "allpage") {
            $rides = DB::table('tj_requete')
                ->leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
                ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
                ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
                ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle')
                ->orderBy('tj_requete.id', 'DESC')
                ->whereDate('tj_requete.creer', '>=', $fromDate)
                ->paginate(10);
            return view("rides.all")->with("rides", $rides);
        } else {
        }
    }

    public function deleteRide($id)
    {

        if ($id != "") {

            $id = json_decode($id);


            if (is_array($id)) {

                for ($i = 0; $i < count($id); $i++) {
                    $complaint = Complaints::where('id_ride', $id[$i]);
                    if ($complaint) {
                        $complaint->delete();
                    }
                    $Note = Note::where('ride_id', $id[$i]);
                    if ($Note) {
                        $Note->delete();
                    }
                    $userNote = UserNote::where('ride_id', $id[$i]);
                    if ($userNote) {
                        $userNote->delete();
                    }

                    $user = Requests::find($id[$i]);
                    $user->delete();
                }
            } else {
                $complaint = Complaints::where('id_ride', $id);
                if ($complaint) {
                    $complaint->delete();
                }
                $Note = Note::where('ride_id', $id);
                if ($Note) {
                    $Note->delete();
                }
                $userNote = UserNote::where('ride_id', $id);
                if ($userNote) {
                    $userNote->delete();
                }

                $user = Requests::find($id);
                $user->delete();
            }
        }

        return redirect()->back();
    }

    public function show($id)
    {
        

        $currency = Currency::where('statut', 'yes')->first();

        $ride = Requests::leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
            ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
            ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
            ->leftjoin('tj_vehicule', 'tj_requete.id_conducteur', '=', 'tj_vehicule.id_conducteur')
            ->leftjoin('brands', 'tj_vehicule.brand', '=', 'brands.id')
            ->leftjoin('car_model', 'tj_vehicule.model', '=', 'car_model.id')
            ->select('tj_requete.*')
            ->addSelect('tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_conducteur.phone as driver_phone', 'tj_conducteur.email as driver_email', 'tj_conducteur.photo_path as driver_photo')
            ->addSelect('tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_user_app.phone as user_phone', 'tj_user_app.email as user_email', 'tj_user_app.photo_path')
            ->addSelect('tj_payment_method.libelle', 'tj_payment_method.image')
            ->addSelect('tj_vehicule.brand', 'tj_vehicule.model', 'tj_vehicule.car_make', 'tj_vehicule.numberplate', 'brands.name as brand', 'car_model.name as model')
            ->where('tj_requete.id', $id)->first();

        if (!empty($ride['user_email'])) {
            $ride['user_email'] = $ride['user_email'];
        }
        if (!empty($ride['user_phone'])) {
            $ride['user_phone'] = $ride['user_phone'];
        }

        if (!empty($ride['driver_email'])) {
            $ride['driver_email'] = $ride['driver_email'];
        }
        if (!empty($ride['driver_phone'])) {
            $ride['driver_phone'] = $ride['driver_phone'];
        }

        $id_conducteur = $ride->id_conducteur;
        $montant = $ride->montant;
        $tax = json_decode($ride->tax, true);
        $discount = $ride->discount;
        $tip = $ride->tip_amount;
        $totalAmount = floatval($montant) - floatval($discount);
        $totalTaxAmount = 0;
        $taxHtml = '';
        if (!empty($tax)) {
            for ($i = 0; $i < sizeof($tax); $i++) {
                $data = $tax[$i];
                if ($data['type'] == "Percentage") {
                    $taxValue = (floatval($data['value']) * $totalAmount) / 100;
                    $taxlabel = $data['libelle'];
                    $value = $data['value'] . "%";
                } else {
                    $taxValue = floatval($data['value']);
                    $taxlabel = $data['libelle'];
                    if ($currency->symbol_at_right == "true") {
                        $value = number_format($data['value'], $currency->decimal_digit) . "" . $currency->symbole;
                    } else {
                        $value = $currency->symbole . "" . number_format($data['value'], $currency->decimal_digit);
                    }
                }
                $totalTaxAmount += floatval(number_format($taxValue, $currency->decimal_digit));
                if ($currency->symbol_at_right == "true") {
                    $taxValueAmount = number_format($taxValue, $currency->decimal_digit) . "" . $currency->symbole;
                } else {
                    $taxValueAmount = $currency->symbole . "" . number_format($taxValue, $currency->decimal_digit);
                }
                $taxHtml = $taxHtml . "<tr><td class='label'>" . $taxlabel . "(" . $value . ")</td><td><span style='color:green'>+" . $taxValueAmount . "<span></td></tr>";
            }
            $totalAmount = floatval($totalAmount) + floatval($totalTaxAmount);
        }
        $totalAmount = floatval($totalAmount) + floatval($tip);
        $customer_review = DB::table('tj_note')->where('tj_note.ride_id', $id)->select('comment', 'niveau')->get();
        $driver_review = DB::table('tj_user_note')->where('tj_user_note.ride_id', $id)->select('comment', 'niveau_driver')->get();

        $driverRating = "0.0";

        $driver_rating = DB::table('tj_note')
            ->select(DB::raw("COUNT(id) as ratingCount"), DB::raw("SUM(niveau) as ratingSum"))
            ->where('id_conducteur', '=', $id_conducteur)
            ->first();
        if (!empty($driver_rating)) {
            if ($driver_rating->ratingCount > 0) {
                $driverRating = number_format(($driver_rating->ratingSum / $driver_rating->ratingCount), 1);
            }
        }
        $userRating = "0.0";

        if (!empty($ride->id_user_app)) {
            $id_user = $ride->id_user_app;
            $user_rating = DB::table('tj_user_note')
                ->select(DB::raw("COUNT(id) as ratingCount"), DB::raw("SUM(niveau_driver) as ratingSum"))
                ->where('id_user_app', '=', $id_user)
                ->first();
            if (!empty($user_rating)) {
                if ($user_rating->ratingCount > 0) {
                    $userRating = number_format(($user_rating->ratingSum / $user_rating->ratingCount));
                }
            }
        }
        $complaints = Complaints::select('title', 'description', 'user_type')->where('id_ride', $id)->get();

        $ride->zone_name = '';
        if ($ride->id_conducteur) {
            $zone_name = '';
            $driver = Driver::find($ride->id_conducteur);
            $zone_id = explode(',', $driver->zone_id);
            $zones = Zone::whereIn('id', $zone_id)->get();
            foreach ($zones as $zone) {
                $zone_name .= $zone->name . ', ';
            }
            $ride->zone_name = rtrim($zone_name, ', ');
        }
        // if ($ride->id_conducteur) {
        //     $ride->zone_name = '';

        //     $driver = Driver::find($ride->id_conducteur);

        //     if ($driver && !empty($driver->zone_id)) {

        //         // Convert string to array and clean empty values
        //         $zoneIds = array_filter(array_map('trim', explode(',', $driver->zone_id)));

        //         if (!empty($zoneIds)) {
        //             $zones = Zone::whereIn('id', $zoneIds)->get();
        //             $ride->zone_name = $zones->pluck('name')->implode(', ');
        //         }

        //     } else {
        //         // zone_id is NULL or empty
        //         $ride->zone_name = null; // OR '' if you want empty string
        //     }
        // }


        $assigned_driver = RequestToDriver::join('tj_conducteur', 'request_to_driver.driver_id', '=', 'tj_conducteur.id')
        ->where('request_to_driver.request_id', $id)
        ->select(
            'request_to_driver.status as request_status',
            'tj_conducteur.nom as driver_first_name',
            'tj_conducteur.prenom as driver_last_name',
            'tj_conducteur.phone as driver_phone',
            'tj_conducteur.email as driver_email',
            'tj_conducteur.statut as driver_status'
        )
        ->get();
    
        
        // dd($assigned_driver);


        // return view("rides.show")->with("ride", $ride)->with("currency", $currency)
        //     ->with("customer_review", $customer_review)
        //     ->with("driver_review", $driver_review)
        //     ->with("complaints", $complaints)
        //     ->with('taxHtml', $taxHtml)
        //     ->with('totalAmount', $totalAmount)
        //     ->with('driverRating', $driverRating)
        //     ->with('userRating', $userRating)
        //     ->with("assigned_driver", $assigned_driver); 

        return view("rides.show", [
            "ride" => $ride,
            "currency" => $currency,
            "customer_review" => $customer_review,
            "driver_review" => $driver_review,
            "complaints" => $complaints,
            "taxHtml" => $taxHtml,
            "totalAmount" => $totalAmount,
            "driverRating" => $driverRating,
            "userRating" => $userRating,
            "assigned_driver" => $assigned_driver, 
        ]);
        
    }

    public function assign_driver($id)
    {
        

        $currency = Currency::where('statut', 'yes')->first();


        $ride = Requests::leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
            ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
            ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
            ->leftjoin('tj_vehicule', 'tj_requete.id_conducteur', '=', 'tj_vehicule.id_conducteur')
            ->leftjoin('brands', 'tj_vehicule.brand', '=', 'brands.id')
            ->leftjoin('car_model', 'tj_vehicule.model', '=', 'car_model.id')
            ->select('tj_requete.*')
            ->addSelect('tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_conducteur.phone as driver_phone', 'tj_conducteur.email as driver_email', 'tj_conducteur.photo_path as driver_photo')
            ->addSelect('tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_user_app.phone as user_phone', 'tj_user_app.email as user_email', 'tj_user_app.photo_path')
            ->addSelect('tj_payment_method.libelle', 'tj_payment_method.image')
            ->addSelect('tj_vehicule.brand', 'tj_vehicule.model', 'tj_vehicule.car_make', 'tj_vehicule.numberplate', 'brands.name as brand', 'car_model.name as model')
            ->where('tj_requete.id', $id)->first();

        if (!empty($ride['user_email'])) {
            $ride['user_email'] = $ride['user_email'];
        }
        if (!empty($ride['user_phone'])) {
            $ride['user_phone'] = $ride['user_phone'];
        }

        if (!empty($ride['driver_email'])) {
            $ride['driver_email'] = $ride['driver_email'];
        }
        if (!empty($ride['driver_phone'])) {
            $ride['driver_phone'] = $ride['driver_phone'];
        }


        $id_conducteur = $ride->id_conducteur ?? "";
        $montant = $ride->montant ?? "";
        $tax = json_decode($ride->tax, true);
        $discount = $ride->discount;
        $tip = $ride->tip_amount;
        $totalAmount = floatval($montant) - floatval($discount);
        $totalTaxAmount = 0;
        $taxHtml = '';
        if (!empty($tax)) {
            for ($i = 0; $i < sizeof($tax); $i++) {
                $data = $tax[$i];
                if ($data['type'] == "Percentage") {
                    $taxValue = (floatval($data['value']) * $totalAmount) / 100;
                    $taxlabel = $data['libelle'];
                    $value = $data['value'] . "%";
                } else {
                    $taxValue = floatval($data['value']);
                    $taxlabel = $data['libelle'];
                    if ($currency->symbol_at_right == "true") {
                        $value = number_format($data['value'], $currency->decimal_digit) . "" . $currency->symbole;
                    } else {
                        $value = $currency->symbole . "" . number_format($data['value'], $currency->decimal_digit);
                    }
                }
                $totalTaxAmount += floatval(number_format($taxValue, $currency->decimal_digit));
                if ($currency->symbol_at_right == "true") {
                    $taxValueAmount = number_format($taxValue, $currency->decimal_digit) . "" . $currency->symbole;
                } else {
                    $taxValueAmount = $currency->symbole . "" . number_format($taxValue, $currency->decimal_digit);
                }
                $taxHtml = $taxHtml . "<tr><td class='label'>" . $taxlabel . "(" . $value . ")</td><td><span style='color:green'>+" . $taxValueAmount . "<span></td></tr>";
            }
            $totalAmount = floatval($totalAmount) + floatval($totalTaxAmount);
        }
        $totalAmount = floatval($totalAmount) + floatval($tip);
        $customer_review = DB::table('tj_note')->where('tj_note.ride_id', $id)->select('comment', 'niveau')->get();
        $driver_review = DB::table('tj_user_note')->where('tj_user_note.ride_id', $id)->select('comment', 'niveau_driver')->get();

        $driverRating = "0.0";

        $driver_rating = DB::table('tj_note')
            ->select(DB::raw("COUNT(id) as ratingCount"), DB::raw("SUM(niveau) as ratingSum"))
            ->where('id_conducteur', '=', $id_conducteur)
            ->first();
        if (!empty($driver_rating)) {
            if ($driver_rating->ratingCount > 0) {
                $driverRating = number_format(($driver_rating->ratingSum / $driver_rating->ratingCount), 1);
            }
        }
        $userRating = "0.0";

        if (!empty($ride->id_user_app)) {
            $id_user = $ride->id_user_app;
            $user_rating = DB::table('tj_user_note')
                ->select(DB::raw("COUNT(id) as ratingCount"), DB::raw("SUM(niveau_driver) as ratingSum"))
                ->where('id_user_app', '=', $id_user)
                ->first();
            if (!empty($user_rating)) {
                if ($user_rating->ratingCount > 0) {
                    $userRating = number_format(($user_rating->ratingSum / $user_rating->ratingCount));
                }
            }
        }
        $complaints = Complaints::select('title', 'description', 'user_type')->where('id_ride', $id)->get();

        $ride->zone_name = '';
        if ($ride->id_conducteur) {
            $zone_name = '';
            $driver = Driver::find($ride->id_conducteur);
            $zone_id = explode(',', $driver->zone_id);
            $zones = Zone::whereIn('id', $zone_id)->get();
            foreach ($zones as $zone) {
                $zone_name .= $zone->name . ', ';
            }
            $ride->zone_name = rtrim($zone_name, ', ');
        }

        $rental_package_id = $ride->rental_package_id;
        $vehicle_id = $ride->vehicle_id;

        // dd($vehicle_id);

        $vahicle = DB::table('rental_packages')
        ->where('package_id', $rental_package_id)
        //    ->where('vehicle_id', $vehicle_id)
            ->get()->pluck('vehicle_id')->toArray();

        $driver_id = DB::table('tj_vehicule')
        ->whereIn('id_type_vehicule', $vahicle)
        ->get()->pluck('id_conducteur')->toArray();


        $lat1 = $ride->latitude_depart;
        $lng1 = $ride->longitude_depart;

        $settings = Settings::where('id', 1)->first();

        $under_radious = $settings->driver_radios;
        $minumum_wallet = $settings->minimum_deposit_amount;

        $driver_list = DB::table('tj_conducteur')->selectRaw("id,phone, fcm_id,nom, latitude, longitude,
                 ( 6371 * acos( cos( radians(?) ) *
                   cos( radians( latitude ) )
                   * cos( radians( longitude ) - radians(?)
                   ) + sin( radians(?) ) *
                   sin( radians( latitude ) ) )
                 ) AS distance", [$lat1, $lng1, $lat1])
            ->where('fcm_id', '!=', '')
            ->whereIn('id', $driver_id)
            // ->where('amount','>=',$minumum_wallet)
            ->where('online', 'yes')
            //->where('statut', 'yes')
            // ->having("distance", "<", $under_radious)

            ->orderBy("distance", 'asc')
            //->limit(10)
            ->get();

        return view("rides.assign_driver")->with("ride", $ride)->with("currency", $currency)
            ->with("customer_review", $customer_review)
            ->with("driver_review", $driver_review)
            ->with("complaints", $complaints)
            ->with('taxHtml', $taxHtml)
            ->with('totalAmount', $totalAmount)
            ->with('driverRating', $driverRating)
            ->with('userRating', $userRating)
            ->with('driver_list', $driver_list);            
    }

    public function assign_driver_limit($id)
    {            
                
        $minutes = DriverAssignSetting::get()->first()->minutes;    
        $ride_id = $id;
        
        $today = date('Y-m-d');
        $request = Requests::find($id); 

        if ($request && $request->date_retour != $today) {
            return redirect()->back()->withErrors(['error' => 'Ride date is in the future. So you can not assign driver.']);
        }
       
        // $currentTime = new DateTime(date('H:i:s'));
        // $heureRetour = new DateTime($request->heure_retour);

        // $interval = $currentTime->diff($heureRetour);
        // $diffInMinutes = ($interval->h * 60) + $interval->i;

        // dd($diffInMinutes);

        $currentTime = Carbon::now();
        
        // $rideStartHour = Carbon::createFromFormat('Y-m-d H:i:s', date('Y-m-d') . ' ' . $request->heure_retour);
        $rideStartHour = Carbon::createFromFormat('Y-m-d H:i:s', $request->date_retour . ' ' . $request->heure_retour);
        

        // $rideStartHour = $request->heure_retour;    

        // $diffInMinutes = $currentTime->diffInMinutes($ridestarthour);
        if ($rideStartHour->greaterThan($currentTime)) {
            $diffInMinutes = $currentTime->diffInMinutes($rideStartHour);  
            if($diffInMinutes >= $minutes){
                return redirect()->back()->withErrors(['error' => 'Assign driver time is not start']);
            }         
        }
        //  else {                        
        //     return redirect()->back()->withErrors(['error' => 'The ride start time has already passed.']);
        // }

        // dd($diffInMinutes);


        $currency = Currency::where('statut', 'yes')->first();

        $ride = Requests::leftjoin('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
            ->leftjoin('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
            ->leftjoin('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
            ->leftjoin('tj_vehicule', 'tj_requete.id_conducteur', '=', 'tj_vehicule.id_conducteur')
            ->leftjoin('brands', 'tj_vehicule.brand', '=', 'brands.id')
            ->leftjoin('car_model', 'tj_vehicule.model', '=', 'car_model.id')
            ->select('tj_requete.*')
            ->addSelect('tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_conducteur.phone as driver_phone', 'tj_conducteur.email as driver_email', 'tj_conducteur.photo_path as driver_photo')
            ->addSelect('tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_user_app.phone as user_phone', 'tj_user_app.email as user_email', 'tj_user_app.photo_path')
            ->addSelect('tj_payment_method.libelle', 'tj_payment_method.image')
            ->addSelect('tj_vehicule.brand', 'tj_vehicule.model', 'tj_vehicule.car_make', 'tj_vehicule.numberplate', 'brands.name as brand', 'car_model.name as model')
            ->where('tj_requete.id', $id)->first();

        // dd($ride);

        if (!empty($ride['user_email'])) {
            $ride['user_email'] = $ride['user_email'];
        }
        if (!empty($ride['user_phone'])) {
            $ride['user_phone'] = $ride['user_phone'];
        }

        if (!empty($ride['driver_email'])) {
            $ride['driver_email'] = $ride['driver_email'];
        }
        if (!empty($ride['driver_phone'])) {
            $ride['driver_phone'] = $ride['driver_phone'];
        }


        $id_conducteur = $ride->id_conducteur ?? "";
        $montant = $ride->montant ?? "";
        $tax = json_decode($ride->tax, true);
        $discount = $ride->discount;
        $tip = $ride->tip_amount;
        $totalAmount = floatval($montant) - floatval($discount);
        $totalTaxAmount = 0;
        $taxHtml = '';
        if (!empty($tax)) {
            for ($i = 0; $i < sizeof($tax); $i++) {
                $data = $tax[$i];
                if ($data['type'] == "Percentage") {
                    $taxValue = (floatval($data['value']) * $totalAmount) / 100;
                    $taxlabel = $data['libelle'];
                    $value = $data['value'] . "%";
                } else {
                    $taxValue = floatval($data['value']);
                    $taxlabel = $data['libelle'];
                    if ($currency->symbol_at_right == "true") {
                        $value = number_format($data['value'], $currency->decimal_digit) . "" . $currency->symbole;
                    } else {
                        $value = $currency->symbole . "" . number_format($data['value'], $currency->decimal_digit);
                    }
                }
                $totalTaxAmount += floatval(number_format($taxValue, $currency->decimal_digit));
                if ($currency->symbol_at_right == "true") {
                    $taxValueAmount = number_format($taxValue, $currency->decimal_digit) . "" . $currency->symbole;
                } else {
                    $taxValueAmount = $currency->symbole . "" . number_format($taxValue, $currency->decimal_digit);
                }
                $taxHtml = $taxHtml . "<tr><td class='label'>" . $taxlabel . "(" . $value . ")</td><td><span style='color:green'>+" . $taxValueAmount . "<span></td></tr>";
            }
            $totalAmount = floatval($totalAmount) + floatval($totalTaxAmount);
        }
        $totalAmount = floatval($totalAmount) + floatval($tip);
        $customer_review = DB::table('tj_note')->where('tj_note.ride_id', $id)->select('comment', 'niveau')->get();
        $driver_review = DB::table('tj_user_note')->where('tj_user_note.ride_id', $id)->select('comment', 'niveau_driver')->get();
     
        $userRating = "0.0";

        if (!empty($ride->id_user_app)) {
            $id_user = $ride->id_user_app;
            $user_rating = DB::table('tj_user_note')
                ->select(DB::raw("COUNT(id) as ratingCount"), DB::raw("SUM(niveau_driver) as ratingSum"))
                ->where('id_user_app', '=', $id_user)
                ->first();
            if (!empty($user_rating)) {
                if ($user_rating->ratingCount > 0) {
                    $userRating = number_format(($user_rating->ratingSum / $user_rating->ratingCount));
                }
            }
        }     
        
        $vehicle_id = $ride->vehicle_id;
        // dd($vehicle_id);


        // $driver_id = DB::table('tj_vehicule')
        // ->where('id_type_vehicule', $vehicle_id)
        // ->get()->pluck('id_conducteur')->toArray();

        // dd($driver_id);

        $lat1 = $ride->latitude_depart;
        $lng1 = $ride->longitude_depart;

        $settings = Settings::where('id', 1)->first();

        $under_radious = $settings->driver_radios;
        $minumum_wallet = $settings->minimum_deposit_amount;

        $driver_id = DB::table('tj_vehicule')
            ->where('id_type_vehicule', $vehicle_id)->get()
            ->pluck('id_conducteur')->toArray();

        $busy_drivers =  Requests::whereIn('statut', ["on ride", "confirmed"])
        ->whereNotnull('id_conducteur')
        ->where('id_conducteur','!=','')
        ->where('id_conducteur','!=',null)
        //->whereIn('id_conducteur',$driver_id)
        ->get()->pluck("id_conducteur")->toArray();

        // dd($busy_drivers);

        array_unique($busy_drivers);

        $driver_list = DB::table('tj_conducteur')->selectRaw("id, fcm_id, latitude, longitude,nom, phone, driver_type,
            ( 6371 * acos( cos( radians(?) ) *
            cos( radians( latitude ) )
            * cos( radians( longitude ) - radians(?)
            ) + sin( radians(?) ) *
            sin( radians( latitude ) ) )
            ) AS distance", [$lat1, $lng1, $lat1])
                ->where('fcm_id', '!=', '')
                // ->where('driver_type', 'In house driver') 
                ->where('amount', '>=', $minumum_wallet)
                ->where('online', 'yes')
                ->where('statut', 'yes');
            if (is_array($busy_drivers) &&  sizeof($busy_drivers) > 0) {
                $driver_list =  $driver_list->whereNotIn("id", $busy_drivers);
            }

        $driver_list = $driver_list->having("distance", "<", $under_radious)
            ->orderBy("distance", 'asc')
            //->limit(10)
            ->get();
        
        // dd($driver_list);

        return view("rides.assign_driver_instead_rental")->with("ride", $ride)->with("currency", $currency)                      
            ->with('driver_list', $driver_list);            
    }

    public function assign_driver_instead_rental_post(Request $request)
    {

        
        $id = $request->post('ride_id');
        
        $driver_id = $request->post('driver');
        $driver_data = Driver::find($driver_id);
        // $fcm_tokens = Driver::where('id' ,$driver_id)->get();
        // $fcm_tokens = Driver::where('id', $driver_id)->first();

        $fcm_tokens = DB::table('tj_conducteur')->selectRaw("id, fcm_id, latitude, longitude,nom, phone, driver_type")               
                ->where('id', $driver_id)
                ->get(); 
                
        // dd($fcm_tokens);

        $rides = Rides::find($id);

        if ($rides) {
            $rides->id_conducteur = $driver_id;
            $rides->statut = 'new';
            $rides->distance_unit = 'KM';
            $rides->save();
        }
                      
        $tmsg = '';
        $terrormsg = '';

        $title = str_replace("'", "\'", "New ride");
        $msg = str_replace("'", "\'", "You have just received a request from a client");

        $tab[] = array();
        $tab = explode("\\", $msg);
        $msg_ = "";
        for ($i = 0; $i < count($tab); $i++) {
            $msg_ = $msg_ . "" . $tab[$i];
        }


        $message = array("body" => $msg_, "title" => $title, "sound" => "order_received", "tag" => "ridenewrider");

        // if ($request->has('version')) {
        //     $version = $request->get('version');            
        // }else{
        //     $version = null;
        // }
                    
        $ride = ['ride_id' => $id, 'status' => 'new'];

        // dd($driver_id);
            
        $check = RequestToDriver::create(['driver_id' => $driver_id, 'request_id' => $id]);  

        if (empty($driver_data->fcm_id)) {
            Log::error("FCM ID is missing for driver", ['driver_id' => $driver_id]);
            return back()->withErrors(['error' => 'Driver FCM ID not available.']);
        }
        
        if ($driver_data->driver_type == 'In house driver') {            
            // if ($version) {  
               
            //    GcmController::sendNotification_new($driver_id, $message, $ride);
            // GcmController::sendNotification($driver_id, $message);
            // Log::info("Sending new type of notification", [
            //     'method' => 'sendNotsendNotification_newification',
            //     'fcm_id' => $driver_data->fcm_id,
            //     'message' => $message,
            //     'ride_id' => $id ?? null,
            //     'driver_id' => $driver_id ?? null,
            // ]);

            
            // GcmController::sendNotification_new($driver_data->fcm_id, $message, $ride);

            try {
                GcmController::sendNotification_new($driver_data->fcm_id, $message, $ride);
                // GcmController::sendNotification_new($driver_data->fcm_id, $message);
            } catch (\Throwable $e) {
                Log::error('FCM Notification failed', [
                    'driver_id' => $driver_data->id ?? null,
                    'fcm_id' => $driver_data->fcm_id ?? null,
                    'message_payload' => $message ?? null,
                    'ride_data' => $ride ?? null,
                    'error' => $e->getMessage(),
                ]);
            }   



            Log::info("Sending new type of notification", [
                'method' => 'sendNotsendNotification_newification',
                'fcm_id' => $driver_data->fcm_id,
                'message' => $message, 
                'ride_id' => $rides->id ?? null
            ]);

            //  return redirect('/rides/all');      

            // } else {                
            //     Log::info("Sending legacy notification", [
            //         'method' => 'sendNotification',
            //         'fcm_id' => $driver_data->fcm_id,
            //         'message' => $message,
            //         'ride_id' => $id ?? null,
            //         'driver_id' => $driver_id ?? null,
            //     ]);
            //     GcmController::sendNotification($driver_id, $message, $ride);
            // }
        }

        if($driver_data->driver_type == 'Outside driver'){
        

            if ($driver_data && $driver_data->fcm_id) {
                try {
                    // dispatch((new SendNotificationJob($driver_data->fcm_id, $message, $id, $ride))
                    //     ->delay(now()->addSeconds(30)));
                    
                              
                    // GcmController::sendNotification($driver_data->fcm_id, $message, $ride); 

                    //  Bus::queueable(function () use ($driver_data, $message, $ride) {
                    //     GcmController::sendNotification($driver_data->fcm_id, $message, $ride);

                    //     Log::info("Successfully dispatched notification job to outside driver", [
                    //         'method'   => 'sendNotification_new',
                    //         'fcm_id'   => $driver_data->fcm_id,
                    //         'message'  => $message,
                    //         'ride_id'  => $ride->id ?? null,
                    //     ]);
                    // })->delay(now()->addSeconds(3))->dispatch();

                    SendNotificationJob::dispatch($fcm_tokens, $message, $id, $ride)->delay(now()->addSeconds(30));   
                    Log::info("Successfully dispatched notification job to outside driver", [
                        'method'   => 'sendNotification_new',
                        'fcm_id'   => $driver_data->fcm_id,
                        'message'  => $message,
                        'ride_id'  => $rides->id ?? null,
                    ]);
                } catch (\Exception $e) {
                    Log::error("Failed to dispatch notification job", [
                        'method'     => 'sendNotification_new',
                        'driver_id'  => $driver_id,
                        'error'      => $e->getMessage(),
                    ]);
                }
            } else {
                Log::warning("Driver not found or missing FCM ID", [
                    'method'     => 'sendNotification_new',
                    'driver_id'  => $driver_id,
                ]);
            }
             
        }
         
        return redirect('/rides/all');
       
    }

    public function assign_driver_post(Request $request)
    {

        $id = $request->post('ride_id');
        
        $driver_id = $request->post('driver');
        $rides = Rides::find($id);
        if ($rides) {

            // ASSIGN AMOUNT //
            $vehicles = Vehicle::where('id_conducteur', $driver_id)->first();
            // $vehicle_id = $vehicles->id_type_vehicule;
            $vehicle_id = $request->post('vehical_id');
            // dd($vehicle_id);

            $rentalpackage = Rentalpackages::where('package_id', $rides->rental_package_id)->where('vehicle_id', $vehicle_id)->first();

            // END ASSIGN AMOUNT //

            $rides->id_conducteur = $driver_id;
            $rides->statut = 'new';
            $rides->distance_unit = 'KM';
            $rides->distance = $rentalpackage->hours;
            $rides->duree = $rentalpackage->hours . ' hours';
            $rides->montant = $rentalpackage->price;
            $rides->save();
        }






        $check = RequestToDriver::create(['driver_id' => $driver_id, 'request_id' => $id]);
        //SEND NOTIFICATION DRIVER

        $title = str_replace("'", "\'", "New ride");
        $msg_ = str_replace("'", "\'", "You have just received a request from a client");


        $message = array("body" => $msg_, "title" => $title, "sound" => "order_received", "tag" => "ridenewrider");
        $ride = ['ride_id' => $id, 'status' => 'new'];

        $driver = DB::table('tj_conducteur')->where('id', $driver_id)->first();
        GcmController::sendNotification($driver->fcm_id, $message, $ride);

        //END SEND NOTIFICATION DRIVER


        //CUSTOMER SEND NOFICATION

        $title = str_replace("'", "\'", "Confirmation of your ride");
        $msg = str_replace("'", "\'", $driver->nom . " is Confirmed your ride.");

        $tab[] = array();
        $tab = explode("\\", $msg);
        $msg_ = "";
        for ($i = 0; $i < count($tab); $i++) {
            $msg_ = $msg_ . "" . $tab[$i];
        }

        $sound = $driver->latitude . "_" . $driver->longitude . "_" . $rides->latitude_depart . "_" . $rides->latitude_depart;

        $message = array("body" => $msg_, "title" => $title, "sound" => 'ipl_horn', "tag" => "rideconfirmed");

        $customer = DB::table('tj_user_app')->where('id', $rides->id_user_app)->first();

        GcmController::sendNotification($customer->fcm_id, $message, $ride);


        return redirect('/rental/rides/all');
    }


    public function updateRide(Request $request, $id)
    {

        $rides = Rides::find($id);
        if ($rides) {
            $rides->statut = $request->input('order_status');
            $rides->save();
        }


        return redirect()->back();
    }
}