<?php

namespace App\Http\Controllers;

use App\Models\Currency;
use App\Models\FavoriteRide;
use App\Models\ParcelOrder;
use App\Models\Referral;
use App\Models\Requests;
use App\Models\Transaction;
use App\Models\User;
use App\Models\UserApp;
use App\Models\VehicleLocation;
use App\Models\AllRentalPackages;
use File;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Image;
use Validator;

class RentalPackagesController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {

        if ($request->has('search') && $request->search != '' && $request->selected_search == 'prenom') {
            $search = $request->input('search');
            $packages = DB::table('all_rental_packages')
                ->where('hours', 'LIKE', '%' . $search . '%')
                ->paginate(20);
        
        } else {

            $packages = AllRentalPackages::orderBy('id', 'desc')->paginate(20);
        }

        
        return view("settings.all_rental_packages.index")->with("packages", $packages);
    }


    public function create()
    {
        return view("settings.all_rental_packages.create");
    }

    public function storepackage(Request $request)
    {

        $validator = Validator::make($request->all(), $rules = [
            'hours' => 'required',
            'kilometers' => 'required',  
        ], $messages = [
            'hours.required' => 'The hours field is required!',
            'kilometers.required' => 'The kilometers field is required!',
           
        ]);

        if ($validator->fails()) {
            return redirect('rental-packages/create')
                ->withErrors($validator)->with(['message' => $messages])
                ->withInput();
        }

        $package = new AllRentalPackages;
        $package->hours = $request->input('hours');
        $package->kilometers = $request->input('kilometers');       
        $package->status = $request->has('status') ? 'yes' : 'no';        
        $package->save();

        
        return redirect('rental/packages');

    }


    public function appUsers()
    {
        return view("settings.all_rental_packages.index");
    }

    public function edit($id)
    {
        $package = AllRentalPackages::where('id', "=", $id)->first();
          
       
        return view("settings.all_rental_packages.edit")->with("package", $package);
    }

    public function show($id)
    {

        $user = UserApp::where('id', "=", $id)->first();

        if (!empty($user['email'])) { 
            $user['email'] = $user['email'];
        } 
        if (!empty($user['phone'])) { 
            $user['phone'] = $user['phone']; 
        }

        $currency = Currency::where('statut', 'yes')->first();

        $transactions = Transaction::join('tj_payment_method', 'tj_transaction.payment_method', '=', 'tj_payment_method.libelle')
            ->select('tj_transaction.*', 'tj_payment_method.image')
            ->where('id_user_app', "=", $id)->orderBy('tj_transaction.id', 'desc')->paginate(10);

        $rides = Requests::
        join('tj_user_app', 'tj_requete.id_user_app', '=', 'tj_user_app.id')
            ->join('tj_conducteur', 'tj_requete.id_conducteur', '=', 'tj_conducteur.id')
            ->join('tj_payment_method', 'tj_requete.id_payment_method', '=', 'tj_payment_method.id')
            ->select('tj_requete.id', 'tj_requete.statut', 'tj_requete.statut_paiement', 'tj_requete.depart_name', 'tj_requete.destination_name', 'tj_requete.distance', 'tj_requete.montant', 'tj_requete.creer', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom', 'tj_user_app.id as user_id', 'tj_user_app.prenom as userPrenom', 'tj_user_app.nom as userNom', 'tj_payment_method.libelle', 'tj_payment_method.image')
            ->where('tj_requete.id_user_app', $id)
            ->orderBy('tj_requete.id', 'DESC')
            ->paginate(10);

        $parcelOrders = ParcelOrder::
        join('tj_user_app', 'parcel_orders.id_user_app', '=', 'tj_user_app.id')
            ->join('tj_conducteur', 'parcel_orders.id_conducteur', '=', 'tj_conducteur.id')
            ->join('tj_payment_method', 'parcel_orders.id_payment_method', '=', 'tj_payment_method.id')
            ->select('parcel_orders.id', 'parcel_orders.status', 'parcel_orders.created_at', 'tj_conducteur.id as driver_id', 'tj_conducteur.prenom as driverPrenom', 'tj_conducteur.nom as driverNom')
            ->where('parcel_orders.id_user_app', $id)
            ->orderBy('parcel_orders.id', 'DESC')
            ->paginate(10);

        $user_rating = DB::table('tj_user_note')
            ->select(DB::raw("COUNT(id) as ratingCount"), DB::raw("SUM(niveau_driver) as ratingSum"))
            ->where('id_user_app', '=', $id)
            ->first();

        $userRating = "0.0";
        if (!empty($user_rating)) {
            if ($user_rating->ratingCount > 0) {
                $userRating = number_format(($user_rating->ratingSum / $user_rating->ratingCount));
            }
        }


        return view("settings.users.show")->with("user", $user)->with("rides", $rides)->with("transactions", $transactions)->with("currency", $currency)->with('userRating', $userRating)->with('parcelOrders', $parcelOrders);
    }

    public function packageUpdate(Request $request, $id)
    {
       
        $validator = Validator::make($request->all(), $rules = [
            'hours' => 'required',
            'kilometers' => 'required',     

        ], $messages = [
            'hours.required' => 'The Hours field is required!',
            'kilometers.required' => 'The Kilometers field is required!',
           
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)->with(['message' => $messages])
                ->withInput();
        }

        $hours = $request->input('hours');
        $kilometers = $request->input('kilometers');
      
      
        $package = AllRentalPackages::find($id);
        if ($package) {
            $package->hours = $hours;
            $package->kilometers = $kilometers;
            $package->status = $request->has('status') ? 'yes' : 'no';                    
            $package->save();
        }

        return redirect('rental/packages');
    }

    public function deletePackage($id)
    {

        AllRentalPackages::find($id)->delete();
        return redirect()->back();
    }

    public function addWallet(Request $request, $id)
    {
        $user = UserApp::find($id);
        $amount = $request->amount;
        if ($amount == '' || $amount == null) {
            $amount = 0;
        }
        if ($user) {
            $userWallet = floatval($user->amount) + floatval($amount);
            $user->amount = (string)$userWallet;
            $user->save();
        }
        $date = date('Y-m-d H:i:s');

        DB::table('tj_transaction')->insert([
            'amount' => $amount,
            'payment_method' => 'Wallet',
            'id_user_app' => $id,
            'deduction_type' => '1',
            'payment_status' => 'success',
            'creer' => $date
        ]);
        $user = UserApp::find($id);
        $txnId = uniqid(0, 999);
        $email = $user->email;
        $date = date('d F Y');

        if (!empty($email)) {

            $emailsubject = '';
            $emailmessage = '';
            $emailtemplate = DB::table('email_template')->select('*')->where('type', 'wallet_topup')->first();
            if (!empty($emailtemplate)) {
                $emailsubject = $emailtemplate->subject;
                $emailmessage = $emailtemplate->message;
                $send_to_admin = $emailtemplate->send_to_admin;
            }
            $currencyData = DB::table('tj_currency')->select('*')->where('statut', 'yes')->first();
            if ($currencyData->symbol_at_right == "true") {
                $amount = number_format($amount, $currencyData->decimal_digit) . $currencyData->symbole;
                $newBalance = number_format($user['amount'], $currencyData->decimal_digit) . $currencyData->symbole;
            } else {
                $amount = $currencyData->symbole . number_format($amount, $currencyData->decimal_digit);
                $newBalance = $currencyData->symbole . number_format($user['amount'], $currencyData->decimal_digit);

            }
            $contact_us_email = DB::table('tj_settings')->select('contact_us_email')->value('contact_us_email');
            $contact_us_email = $contact_us_email ? $contact_us_email : 'none@none.com';


            $app_name = env('APP_NAME', 'Cabme');
            if ($send_to_admin == "true") {
                $to = $email . "," . $contact_us_email;

            } else {
                $to = $email;
            }

            $emailmessage = str_replace("{AppName}", $app_name, $emailmessage);
            $emailmessage = str_replace("{UserName}", $user['nom'] . " " . $user['prenom'], $emailmessage);
            $emailmessage = str_replace("{Amount}", $amount, $emailmessage);
            $emailmessage = str_replace("{PaymentMethod}", 'Wallet', $emailmessage);
            $emailmessage = str_replace('{TransactionId}', $txnId, $emailmessage);
            $emailmessage = str_replace('{Balance}', $newBalance, $emailmessage);
            $emailmessage = str_replace('{Date}', $date, $emailmessage);

            // Always set content-type when sending HTML email
            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
            $headers .= 'From: ' . $app_name . '<' . $contact_us_email . '>' . "\r\n";
            mail($to, $emailsubject, $emailmessage, $headers);
        }

        return redirect('users/show/' . $id);
    }

    public function profile()
    {
        $user = Auth::user();
        return view('settings.users.profile', compact(['user']));
    }


    public function changeStatus($id)
    {
        $user = UserApp::find($id);
        if ($user->statut == 'no') {
            $user->statut = 'yes';
        } else {
            $user->statut = 'no';
        }
        $user->save();
        return redirect()->back();

    }


    public function update(Request $request, $id)
    {
        $name = $request->input('name');
        $password = $request->input('password');
        $old_password = $request->input('old_password');
        $email = $request->input('email');
        if ($password == '') {
            $validator = Validator::make($request->all(), [
                'name' => 'required|max:255',
                'email' => 'required|email'
            ]);
        } else {
            $user = Auth::user();
            if (password_verify($old_password, $user->password)) {
                $validator = Validator::make($request->all(), [
                    'name' => 'required|max:255',
                    'password' => 'required|min:8',
                    'confirm_password' => 'required|same:password',
                    'email' => 'required|email'
                ]);

            } else {
                return Redirect()->back()->with(['message' => "Please enter correct old password"]);
            }

        }

        if ($validator->fails()) {
            $error = $validator->errors()->first();
            return Redirect()->back()->with(['message' => $error]);
        }

        $user = User::find($id);
        if ($user) {
            $user->name = $name;
            $user->email = $email;
            if ($password != '') {
                $user->password = Hash::make($password);
            }
            $user->save();
        }

        return redirect()->back();
    }

    public function toggalSwitch(Request $request)
    {
        $ischeck = $request->input('ischeck');
        $id = $request->input('id');
        $package = AllRentalPackages::find($id);

        if ($ischeck == "true") {
            $package->status = 'yes';
        } else {
            $package->status = 'no';
        }
        $package->save();

    }

}
