<?php

namespace App\Http\Controllers\api\v1;

use App\Http\Controllers\Controller;
use App\Models\VehicleType;
use App\Models\Commission;
use App\Models\Vehicle;
use App\Models\Driver;
use App\Models\Rentalpackages;
use App\Models\AllRentalPackages;

use Illuminate\Http\Request;
use DB;

class DriversVehicleController extends Controller
{

  public function __construct()
  {
    $this->limit = 20;
  }
  /**
   * Display a listing of the resource.
   *
   * @return \Illuminate\Http\Response
   */

  public function getData(Request $request)
  {

    $file = fopen("driver_v.txt", "a");
    fwrite($file, print_r($request->all(), true));
    fclose($file);

    $id_driver = $request->get('id_driver');


    $sql = Vehicle::where('id_conducteur', $id_driver)->where('tj_vehicule.statut', '=', 'yes')->first();
    $row = $sql;

    if (!empty($sql)) {

      $vehicle_type_id = $sql->id_type_vehicule;

      $delivery_charge = DB::table('delivery_charges')->select('minimum_delivery_charges_within_km', 'minimum_delivery_charges', 'delivery_charges_per_km')
        ->where('id_vehicle_type', '=', $vehicle_type_id)->first();
      if (!empty($delivery_charge)) {
        $row->minimum_delivery_charges_within_km = $delivery_charge->minimum_delivery_charges_within_km;
        $row->minimum_delivery_charges = $delivery_charge->minimum_delivery_charges;
        $row->delivery_charges_per_km = $delivery_charge->delivery_charges_per_km;
      } else {
        $row->minimum_delivery_charges_within_km = '';
        $row->minimum_delivery_charges = '';
        $row->delivery_charges_per_km = '';
      }

      $driver = Driver::find($id_driver);
      $row->zone_id = $driver->zone_id ? explode(',', $driver->zone_id) : [];
    }

    if (!empty($row)) {
      $response['success'] = 'success';
      $response['error'] = null;
      $response['message'] = 'Successfully';
      $response['data'] = $row;
    } else {
      $response['success'] = 'Failed';
      $response['error'] = 'No Data Found';
      $response['message'] = null;
    }

    return response()->json($response);
  }
  public function getRentlPackages(Request $request)
  {


    $data = AllRentalPackages::where('status', 'yes')->orderby('hours', 'ASC')->get();


    $response['success'] = 'success';
    $response['message'] = 'Successfully';
    $response['data'] = $data;

    return response()->json($response);
  }
  function vehicleByPackage(Request $request)
  {
    $package_id = $request->get('package_id');
    $latitude = $request->get('latitude');
    $longitude = $request->get('longitude');
    if ($package_id != '' && $latitude != '' && $longitude != '') {

      $vids = Rentalpackages::where('package_id', $package_id)
        ->pluck('vehicle_id')->toArray();

      $types = VehicleType::wherein('id', $vids)->get();

      $all_types = [];
      foreach ($types as $k => $val) {

        $vehicle = DB::table('tj_vehicule')->where('id_type_vehicule', $val->id)->first();

        if (!empty($vehicle)) {
          $driver = DB::table('tj_conducteur')
            //->where('online', 'yes')
            //->where('statut', 'yes')
            ->selectRaw("latitude, longitude,
                 ( 6371 * acos( cos( radians(?) ) *
                   cos( radians( latitude ) )
                   * cos( radians( longitude ) - radians(?)
                   ) + sin( radians(?) ) *
                   sin( radians( latitude ) ) )
                 ) AS distance", [$latitude, $longitude, $latitude])
            ->where('id', $vehicle->id_conducteur)->first();
          if (!empty($driver)) {
            $distance = ($driver->distance % $vehicle->milage) / $vehicle->milage * 60;
            $types[$k]->distance = $distance . " minutes";
            $rental = Rentalpackages::where('vehicle_id', $val->id)->where('package_id', $package_id)->first();

            $types[$k]->price = $rental->price;
            if (file_exists(public_path('assets/images/type_vehicle' . '/' . $val->image)) && !empty($val->image)) {
              $types[$k]->image = asset('assets/images/type_vehicle') . '/' . $val->image;
            } else {
              $types[$k]->image = asset('assets/images/placeholder_image.jpg');
            }
            $types[$k]->description = 'Comfy, econimacal cars';
            $all_types[] = $val;
          }
        }
      }

      if ($all_types) {
        $response['success'] = 'success';
        $response['data'] = isset($all_types) ? $all_types : [];
      } else {
        $response['success'] = 'Failed';
        $response['error'] = 'No Vehicle Found';
      }
    } else {
      $response['success'] = 'Failed';
      $response['error'] = 'some fields are missing';
    }
    return response()->json($response);
  }
}
