<?php

namespace App\Http\Controllers\api\v1;

use App\Http\Controllers\API\v1\GcmController;
use App\Http\Controllers\Controller;
use App\Models\Notification;
use App\Models\Requests;
use App\Models\RequestToDriver;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Exception;

class SetRejectedRequeteController extends Controller
{

    public function __construct()
    {
        $this->limit = 20;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function rejectedRequest(Request $request)
    {

        // Log::info("come here");

        $file = fopen('rejected.txt', 'a');
        fwrite($file, print_r($request->all(), true));
        fclose($file);

        $id_requete = $request->get('id_ride');
        $id_user = $request->get('id_user');
        $driver_name = $request->get('name');
        $from_id = $request->get('from_id');
        $reason = $request->get('reason');
        $user_cat = $request->get('user_cat');

        if ($request->has('version')) {
            $version = $request->get('version');
        } else {
            $version = null;
        }


        if (!empty($id_requete) && !empty($from_id) && !empty($driver_name) && !empty($id_user)) {

            $driverids = RequestToDriver::where('request_id', $id_requete)->where('status', null)->get()->pluck('driver_id');


            /* $check_status = Requests::where('id', '=', $id_requete)->where('statut', 'confirmed')->first();

            if (!empty($check_status)) {
                $response['success'] = 'Failed';
                $response['error'] = 'Ride already confirmed you cant canceled it';

                return response()->json($response);
            }
            */


            $sql = Requests::where('id', $id_requete)->first();
            $rejectDriverIds = $sql->rejected_driver_id;
            $rejDriverIds = array();
            if ($rejectDriverIds != null) {
                $rejDriverIds = json_decode($rejectDriverIds, true);
            }

            $row_sql = $sql->toArray();
            if ($row_sql['trajet'] != '') {
                if (file_exists(public_path('images/recu_trajet_course' . '/' . $row_sql['trajet']))) {
                    $image_user = asset('images/recu_trajet_course') . '/' . $row_sql['trajet'];
                } else {
                    $image_user = asset('assets/images/placeholder_image.jpg');
                }
                $row_sql['trajet'] = $image_user;
            }

            if ($user_cat == 'driver') {
                
                $tmsg = '';
                $terrormsg = '';

                $title = str_replace("'", "\'", "Rejection of your ride");
                $msg = str_replace("'", "\'", $driver_name . " is cancelled your ride.");
                $reasons = str_replace("'", "\'", "$reason");

                $tab[] = array();
                $tab = explode("\\", $msg);
                $msg_ = "";
                for ($i = 0; $i < count($tab); $i++) {
                    $msg_ = $msg_ . "" . $tab[$i];
                }

                $message = array("body" => $msg_, "reasons" => $reasons, "title" => $title, "sound" => "ipl_horn", "tag" => "riderejected");
                $fcm_token = DB::table('tj_user_app')->where('fcm_id', '!=', '')->where('id', '=', $id_user)->value('fcm_id');

                if (count($driverids) == 1) {
                    if (!empty($fcm_token)) {

                        if ($version == null) {
                            GcmController::sendNotification($fcm_token, $message);
                        } else {
                            GcmController::sendNotification_new($fcm_token, $message);
                        }
                    }
                }

                RequestToDriver::where('request_id', $id_requete)->where('driver_id', $from_id)
                    ->update(['status' => 'rejected_by_driver']);

                $lat = $row_sql['latitude_depart'];
                $long = $row_sql['longitude_depart'];
                $driver_id = $row_sql['id_conducteur'];

                $vehicleType = DB::table('tj_vehicule')->select('id_type_vehicule')->where('id_conducteur', $driver_id)->first();

                // $settings = DB::table('tj_settings')->select('driver_radios','minimum_deposit_amount')->first();
                // $radius=$settings->driver_radios;
                // $minimum_wallet_balance=$settings->minimum_deposit_amount;


                //     $data = DB::table("tj_conducteur")
                //         ->join('tj_vehicule', 'tj_vehicule.id_conducteur', '=', 'tj_conducteur.id')
                //         ->select("tj_conducteur.id"
                //             , DB::raw("3959  * acos(cos(radians(" . $lat . "))
                // * cos(radians(tj_conducteur.latitude))
                // * cos(radians(tj_conducteur.longitude) - radians(" . $long . "))
                // + sin(radians(" . $lat . "))
                // * sin(radians(tj_conducteur.latitude))) AS distance"))
                //         ->having('distance', '<=', $radius)
                //         ->orderBy('distance', 'asc')
                //         ->where('tj_conducteur.statut', 'yes')
                //         ->where('tj_conducteur.id','!=', $driver_id)
                //         ->whereNotIn('tj_conducteur.id', $rejDriverIds)
                //         ->where('tj_conducteur.is_verified', '=', '1')
                //         ->where('tj_conducteur.online', '!=', 'no')
                //         ->where('tj_conducteur.amount', '>=', $minimum_wallet_balance)
                //         ->where('id_type_vehicule', '=', $vehicleType->id_type_vehicule)
                //         ->first();
                //     if (!empty($data)) {

                //             $id = $data->id;

                //             $title = str_replace("'", "\'", "New ride");
                //             $msg = str_replace("'", "\'", "You have just received a request from a client");

                //             $tab[] = array();
                //             $tab = explode("\\", $msg);
                //             $msg_ = "";
                //             for ($i = 0; $i < count($tab); $i++) {
                //                 $msg_ = $msg_ . "" . $tab[$i];
                //             }

                //             $message = array("body" => $msg_, "title" => $title, "sound" => "mySound", "tag" => "ridenewrider");
                //             $fcm_token = DB::table('tj_conducteur')->where('fcm_id','!=','')->where('id','=',$id)->value('fcm_id');
                //             if (!empty($fcm_token)) {
                //                 GcmController::sendNotification($fcm_token, $message);
                //             }

                //             if ($id) {
                //                 $date_heure = date('Y-m-d H:i:s');
                //               if (!in_array($driver_id, $rejDriverIds)) {
                //                 array_push($rejDriverIds, $driver_id);

                //                }

                //                 $updateRejDriverArr=json_encode($rejDriverIds);
                //                 $updatedata = DB::update('update tj_requete set statut = ?,updated_at=?,id_conducteur = ?,rejected_driver_id=? where id = ?', ['new', $date_heure,$id,$updateRejDriverArr,$id_requete]);
                //                 $sql_update = Requests::orderBy('updated_at', 'DESC')->first();
                //                 $row = $sql_update->toArray();
                //                 $row['id']=(string)$row['id'];

                //         }
                //     } else {

                if (!in_array($driver_id, $rejDriverIds)) {
                    array_push($rejDriverIds, $from_id);
                }

                $updateRejDriverArr = json_encode($rejDriverIds);
                if (count($driverids) == 1) {
                    $updatedata = DB::update('update tj_requete set statut = ?,rejected_driver_id=? where id = ?', ['rejected', $updateRejDriverArr, $id_requete]);
                } else {
                    $updatedata = DB::update('update tj_requete set  statut = ?, id_conducteur = ? ,rejected_driver_id=? where id = ?', ['new', null ,$updateRejDriverArr, $id_requete]);
                }
                $sql_update = Requests::where('id', '=', $id_requete)->first();
                $row = $sql_update->toArray();
                $row['id'] = (string) $row['id'];
                //}

            } elseif ($user_cat == 'user_app') {

                $updatedata = DB::update('update tj_requete set statut = ? where id = ?', ['rejected', $id_requete]);
                $sql_update = Requests::where('id', '=', $id_requete)->first();
                $row = $sql_update->toArray();
                $row['id'] = (string) $row['id'];
                $tmsg = '';
                $terrormsg = '';

                $title = str_replace("'", "\'", "Cancellation of  ride");
                $msg = str_replace("'", "\'", $driver_name . " canceled the ride");
                $reasons = str_replace("'", "\'", "$reason");

                $tab[] = array();
                $tab = explode("\\", $msg);
                $msg_ = "";
                for ($i = 0; $i < count($tab); $i++) {
                    $msg_ = $msg_ . "" . $tab[$i];
                }

                $message = array("body" => $msg_, "reasons" => $reasons, "title" => $title, "sound" => "ipl_horn", "tag" => "riderejected");
                $fcm_token = DB::table('tj_conducteur')->where('fcm_id', '!=', '')->where('id', '=', $id_user)->value('fcm_id');
                if (!empty($fcm_token)) {


                    if ($version == null) {
                        GcmController::sendNotification($fcm_token, $message);
                    } else {
                        GcmController::sendNotification_new($fcm_token, $message);
                    }

                    // GcmController::sendNotification($fcm_token, $message);
                }
            }

            if (!empty($fcm_token)) {

                $date_heure = date('Y-m-d H:i:s');
                $from_id = $request->get('from_id');
                $to_id = $request->get('id_user');

                $insertdata = DB::insert("insert into tj_notification(titre,message,statut,creer,modifier,to_id,from_id,type)
                values('" . $title . "','" . $msg . "','yes','" . $date_heure . "','" . $date_heure . "','" . $to_id . "','" . $from_id . "','riderejected')");
                $sql_notification = Notification::orderby('id', 'desc')->first();
                $data = $sql_notification->toArray();
                $row['titre'] = $data['titre'];
                $row['message'] = $data['message'];
                $row['reason'] = $reason;
                $row['statut_notification'] = $data['statut'];
                $row['to_id'] = $data['to_id'];
                $row['from_id'] = $data['from_id'];
                $row['type'] = $data['type'];
            }
            if ($row['deleted_at'] == null) {
                $row['deleted_at'] = '';
            }
            if ($row['updated_at'] == null) {
                $row['updated_at'] = '';
            }
            if ($row['dispatcher_id'] == null) {
                $row['dispatcher_id'] = '';
            }
            if ($row['ride_type'] == null) {
                $row['ride_type'] = '';
            }
            if ($row['user_info'] == null) {
                $row['user_info'] = '';
            }
            if ($row['tax'] == null) {
                $row['tax'] = '';
            }
            if ($row['discount'] == null) {
                $row['discount'] = '';
            }

            //REFUND 

            if ($sql->advance_payment != 0) {
                $this->refund_payment($sql);
            }


            $response['success'] = 'success';
            $response['error'] = null;
            $response['message'] = 'status successfully updated';
            $response['data'] = $row;
        } else {
            $response['success'] = 'Failed';
            $response['error'] = 'some fields are missing';
        }
        return response()->json($response);
    }

    public function rejectedRequestBycustomer(Request $request)
    {

        $file = fopen('rejected.txt', 'a');
        fwrite($file, print_r($request->all(), true));
        fclose($file);

        $id_requete = $request->get('ride_id');
        if ($request->has('version')) {
            $version = $request->get('version');
        } else {
            $version = null;
        }

        $auto_cancel = $request->get('auto_cancel');


        if (!empty($id_requete)) {
                    
            $check_status = Requests::where('id', '=', $id_requete)->where('statut', 'confirmed')->first();

            if (!empty($check_status)) {
                $response['success'] = 'Failed';
                $response['error'] = 'Ride already confirmed you can not canceled it';

                return response()->json($response);
            }

            if ($auto_cancel == "1") {
                $pending_status = Requests::where('id', '=', $id_requete)->where('statut', '!=', 'pending')->first();

                if ($pending_status) {
                    $response['success'] = 'Failed';
                    $response['error'] = 'Ride is not pending so can not cancel it';

                    return response()->json($response);
                }
            }


            $driverids = RequestToDriver::where('request_id', $id_requete)->where('status', null)->get()->pluck('driver_id');



            $sql = Requests::where('id', $id_requete)->first();
            $rejectDriverIds = $sql->rejected_driver_id;
            $rejDriverIds = array();
            if ($rejectDriverIds != null) {
                $rejDriverIds = json_decode($rejectDriverIds, true);
            }

            $row_sql = $sql->toArray();
            if ($row_sql['trajet'] != '') {
                if (file_exists(public_path('images/recu_trajet_course' . '/' . $row_sql['trajet']))) {
                    $image_user = asset('images/recu_trajet_course') . '/' . $row_sql['trajet'];
                } else {
                    $image_user = asset('assets/images/placeholder_image.jpg');
                }
                $row_sql['trajet'] = $image_user;
            }


            $updatedata = DB::update('update tj_requete set statut = ? where id = ?', ['rejected', $id_requete]);
            $sql_update = Requests::where('id', '=', $id_requete)->first();

            $row = $sql_update->toArray();
            $row['id'] = (string) $row['id'];
            $tmsg = '';
            $terrormsg = '';
            $reason = "Customer canceled the ride";
            $title = str_replace("'", "\'", "Cancellation of  ride by customer");
            $msg = str_replace("'", "\'",   "Customer canceled the ride");
            $reasons = str_replace("'", "\'", "$reason");

            $tab[] = array();
            $tab = explode("\\", $msg);  
            $msg_ = "";
            for ($i = 0; $i < count($tab); $i++) {
                $msg_ = $msg_ . "" . $tab[$i];
            }

            $message = array("body" => $msg_, "reasons" => $reasons, "title" => $title, "sound" => "ipl_horn", "tag" => "riderejected");
            $ride = ['status' => 'cancel'];

            $fcm_tokens = DB::table('tj_conducteur')->where('fcm_id', '!=', '')->whereIn('id', $driverids)->get();
            if (sizeof($fcm_tokens) > 0) {
                foreach ($fcm_tokens as $fcm_token) {
                    // GcmController::sendNotification($fcm_token->fcm_id, $message , $ride);

                    if ($version == null) {
                        GcmController::sendNotification($fcm_token->fcm_id, $message, $ride);
                    } else {
                        GcmController::sendNotification_new($fcm_token->fcm_id, $message, $ride);
                    }
                }

                $date_heure = date('Y-m-d H:i:s');
                $from_id = $fcm_token->id;
                $to_id = $sql->id_user_app;

                $insertdata = DB::insert("insert into tj_notification(titre,message,statut,creer,modifier,to_id,from_id,type)
                values('" . $title . "','" . $msg . "','yes','" . $date_heure . "','" . $date_heure . "','" . $to_id . "','" . $from_id . "','riderejected')");
                $sql_notification = Notification::orderby('id', 'desc')->first();
                $data = $sql_notification->toArray();
                $row['titre'] = $data['titre'];
                $row['message'] = $data['message'];
                $row['reason'] = $reason;
                $row['statut_notification'] = $data['statut'];
                $row['to_id'] = $data['to_id'];
                $row['from_id'] = $data['from_id'];
                $row['type'] = $data['type'];
            }
            if ($row['deleted_at'] == null) {
                $row['deleted_at'] = '';
            }
            if ($row['updated_at'] == null) {
                $row['updated_at'] = '';
            }
            if ($row['dispatcher_id'] == null) {
                $row['dispatcher_id'] = '';
            }
            if ($row['ride_type'] == null) {
                $row['ride_type'] = '';
            }
            if ($row['user_info'] == null) {
                $row['user_info'] = '';
            }
            if ($row['tax'] == null) {
                $row['tax'] = '';
            }
            if ($row['discount'] == null) {
                $row['discount'] = '';
            }

            //REFUND

            if ($sql->advance_payment != 0) {
                $this->refund_payment($sql);
            }

            $response['success'] = 'success';
            $response['error'] = null;
            $response['message'] = 'status successfully updated';
            $response['data'] = $row;
        } else {
            $response['success'] = 'Failed';
            $response['error'] = 'some fields are missing';
        }
        return response()->json($response);
    }
    public function refund_payment($request)
    {
        try {
            $sql_rezorpay = DB::table('payment_settings')
                ->crossJoin('tj_payment_method')
                ->select(
                    'payment_settings.id',
                    'payment_settings.key',
                    'payment_settings.secret_key',
                    'payment_settings.isEnabled',
                    'payment_settings.isSandboxEnabled',
                    'payment_settings.id_payment_method',
                    'tj_payment_method.libelle'
                )
                ->where('payment_settings.id_payment_method', '=', DB::raw('tj_payment_method.id'))
                ->where('tj_payment_method.libelle', '=', 'Razorpay')
                ->first();



            $key_id = $sql_rezorpay->key;
            $key_secret = $sql_rezorpay->secret_key;

            $pay_id = $request->razorpay_transaction_id;




            //REFUND PAYMENT

            $url = "https://api.razorpay.com/v1/payments/" . $pay_id . "/refund";

            $amount = ($request->advance_payment * 100);

            $data = [
                "amount" => ($request->advance_payment * 100),
                "speed" => "optimum",
                "receipt" => "Receipt No. " . $request->id,
            ];

            Log::info('Capture API Request Payment ID: ' . $pay_id);
            Log::info('Capture API Request amount: ' . $amount);
            Log::info('Capture API Request url: ' . $url);


            $json_data = json_encode($data);



            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_USERPWD, $key_id . ":" . $key_secret);
            curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $json_data);
            $response = curl_exec($ch);

            if (curl_errno($ch)) {
                echo 'Curl error: ' . curl_error($ch);
            } else {
                $decoded_response = json_decode($response, true);

                if (isset($decoded_response['id'])) {
                    $refund = 1;
                    $updatedata = DB::update('update tj_requete set is_refund = ? where id = ?', [$refund, $request->id]);
                }

                $file = fopen("refund.txt", "a");
                fwrite($file, print_r($decoded_response, true));
                fclose($file);
            }

            curl_close($ch);

            Log::info('Capture API Response: ' . $response);

            return true;
        } catch (Exception $e) {

            Log::info('Capture API Response: ' . $e->getMessage() . ' || ON LINE NO. :' . $e->getLine() . ' || IN FILE: ' . $e->getFile());
            return false;
        }
    }
}
