<?php

namespace App\Http\Controllers\api\v1;

use App\Http\Controllers\API\v1\GcmController;
use App\Http\Controllers\Controller;
use App\Models\Requests;
use App\Models\RequestToDriver;
use App\Jobs\SendNotificationJob;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Log;
use Exception;
use Carbon\Carbon;
class RequeteRegisterController extends Controller
{

    public function __construct()
    {
        $this->limit = 20;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function register(Request $request)
    {

        if ($request->has('version')) {
            $version = $request->get('version');            
        }else{
            $version = null;
        }

        $type = $request->get('type');
        $statut_round = $request->get('statut_round');        
       

        $return_date = $request->get('return_date');   
        $return_hour = $request->get('return_hour');  

        // $return_date_sql = !empty($return_date) ? $return_date : NULL;
        // $return_hour_sql = !empty($return_hour) ? $return_hour : NULL;
    

        //    return response()->json([
        //     'return_date_sql' =>    $return_date_sql  , 
        //     'return_hour_sql' =>    $return_hour_sql  , 
        //    ]);



        $myfile = fopen("enew1.txt", 'a');
        fwrite($myfile, print_r($request->all(), true));
        fclose($myfile);

        $setting = DB::table('tj_settings')->where('id', 1)->first();
        $under_radious = $setting->driver_radios;
        $minumum_wallet = $setting->minimum_deposit_amount;

        $user_id = $request->get('user_id');
        $ride_type = $request->get('ride_type');
        $user_detail = json_encode($request->get('user_detail'));
        $lat1 = $request->get('lat1');
        $lng1 = $request->get('lng1');
        $lat2 = $request->get('lat2');
        $lng2 = $request->get('lng2');
        $cout = $request->get('cout');
        $duree = $request->get('duree');
        $distance = $request->get('distance');
        $distance_unit = $request->get('distance_unit');
        $age_children1 = $request->get('age_children1');
        $age_children2 = $request->get('age_children2');
        $age_children3 = $request->get('age_children3');
        $trip_objective = $request->get('trip_objective');
        $trip_category = $request->get('trip_category');

        // $id_conducteur = $request->get('id_conducteur');
        $id_payment = $request->get('id_payment');
        $depart_name = $request->get('depart_name');
        $destination_name = $request->get('destination_name');
        $image = $request->file('image');
        $place = $request->get('place');
        $place = str_replace("'", "\'", $place);
        $number_poeple = $request->get('number_poeple');
        $number_poeple = str_replace("'", "\'", $number_poeple);
        $statut_round = $request->get('statut_round');
        $stops = json_encode($request->get('stops'));
        $advance_payment = $request->get('advance_payment');
        $time_stamp = $request->get('time_stamp');
        $razorpay_transaction_id = $request->get('transaction_id');
        $vehicle_id = $request->get('vechicle_id');
        if (!empty($request->get('date_retour')))
            $date_retour = $request->get('date_retour');
        else
            $date_retour = date('Y-m-d');
        if (!empty($request->get('heure_retour')))
            $heure_retour = $request->get('heure_retour');
        else
            $heure_retour = date('H:i:s');
        $date_heure = date('Y-m-d H:i:s');

        if (!empty($image)) {
            $file = $request->file('image');
            $extenstion = $file->getClientOriginalExtension();
            $time = time() . '.' . $extenstion;
            $filename = 'requete_images_' . $time;
            $file->move(public_path('images/recu_trajet_course/'), $filename);
        } else {
            $filename = '';
        }
        $remaining_payment = $cout - $advance_payment;
        if (!empty($id_payment)) {
            if ($ride_type != "driver") {

               

                // $insertdata = DB::insert("insert into tj_requete(vehicle_id,razorpay_transaction_id,time_stamp,remaining_payment,date_retour,statut_round,heure_retour,
                // number_poeple,place,id_payment_method,trajet,depart_name,
                // destination_name,id_user_app,latitude_depart,longitude_depart,latitude_arrivee,
                // longitude_arrivee,statut,creer,distance,distance_unit,montant,duree,trip_objective,age_children1,
                // age_children2,age_children3,feel_safe,tip_amount,statut_paiement,
                // modifier,statut_course,id_conducteur_accepter,trip_category,feel_safe_driver,stops,advance_payment,type,return_date,return_hour)
                // values('" . $vehicle_id . "','" . $razorpay_transaction_id . "','" . $time_stamp . "','" . $remaining_payment . "','" . $date_retour . "','" . $statut_round . "','" . $heure_retour . "','" . $number_poeple . "','" . $place . "','" . $id_payment . "','" . $filename . "','" . $depart_name . "','" . $destination_name . "'
                // ,'" . $user_id . "','" . $lat1 . "','" . $lng1 . "','" . $lat2 . "','" . $lng2 . "',
                // 'new','" . $date_heure . "','" . $distance . "', '" . $distance_unit . "', '" . $cout . "','" . $duree . "',
                // '" . $trip_objective . "','" . $age_children1 . "','" . $age_children2 . "',
                // '" . $age_children3 . "',0,0,'','" . $date_heure . "','',0,'',0,'" . $stops . "','" . $advance_payment . "','" . $type . "','" . $return_date . "','" . $return_hour . "')");

                $return_date_sql = $return_date === null ? "NULL" : "'$return_date'";
                $return_hour_sql = $return_hour === null ? "NULL" : "'$return_hour'";

                $insertdata = DB::insert("INSERT INTO tj_requete (
                    vehicle_id, razorpay_transaction_id, time_stamp, remaining_payment, date_retour,
                    statut_round, heure_retour, number_poeple, place, id_payment_method,
                    trajet, depart_name, destination_name, id_user_app, latitude_depart,
                    longitude_depart, latitude_arrivee, longitude_arrivee, statut, creer,
                    distance, distance_unit, montant, duree, trip_objective,
                    age_children1, age_children2, age_children3, feel_safe, tip_amount,
                    statut_paiement, modifier, statut_course, id_conducteur_accepter,
                    trip_category, feel_safe_driver, stops, advance_payment, type,
                    return_date, return_hour
                ) VALUES (
                    '$vehicle_id', '$razorpay_transaction_id', '$time_stamp', '$remaining_payment', '$date_retour',
                    '$statut_round', '$heure_retour', '$number_poeple', '$place', '$id_payment',
                    '$filename', '$depart_name', '$destination_name', '$user_id', '$lat1',
                    '$lng1', '$lat2', '$lng2', 'new', '$date_heure',
                    '$distance', '$distance_unit', '$cout', '$duree', '$trip_objective',
                    '$age_children1', '$age_children2', '$age_children3', 0, 0,
                    '', '$date_heure', '', 0,
                    '', 0, '$stops', '$advance_payment', '$type',
                    $return_date_sql, $return_hour_sql
                )");        
            
                $id = DB::getPdo()->lastInsertId();
                if ($id > 0) {
                    $get_user = Requests::where('id', $id)->first();
                    $rowData = $get_user->toArray();
                }

                $currentTime = Carbon::now();
                $rideStartHour = Carbon::createFromFormat('Y-m-d H:i:s', date('Y-m-d') . ' ' . $heure_retour);
                $diffInMinutes = $currentTime->diffInMinutes($rideStartHour);  
                if($diffInMinutes <= 5){                      
                    $tmsg = '';
                    $terrormsg = '';

                    $title = str_replace("'", "\'", "New ride");
                    $msg = str_replace("'", "\'", "You have just received a request from a client");

                    $tab[] = array();
                    $tab = explode("\\", $msg);
                    $msg_ = "";
                    for ($i = 0; $i < count($tab); $i++) {
                        $msg_ = $msg_ . "" . $tab[$i];
                    }


                    //find busy drivers

                    $driver_id = DB::table('tj_vehicule')
                    ->where('id_type_vehicule', $vehicle_id)->get()
                    ->pluck('id_conducteur')->toArray();

                    $busy_drivers =  Requests::whereIn('statut', ["on ride", "confirmed"])
                    ->whereNotnull('id_conducteur')
                    ->where('id_conducteur','!=','')
                    ->where('id_conducteur','!=',null)
                    //->whereIn('id_conducteur',$driver_id)
                    ->get()->pluck("id_conducteur")->toArray();

                    array_unique($busy_drivers);

                    $message = array("body" => $msg_, "title" => $title, "sound" => "order_received", "tag" => "ridenewrider");

            
                    $fcm_tokens = DB::table('tj_conducteur')->selectRaw("id, fcm_id, latitude, longitude,
                    ( 6371 * acos( cos( radians(?) ) *
                    cos( radians( latitude ) )
                    * cos( radians( longitude ) - radians(?)
                    ) + sin( radians(?) ) *
                    sin( radians( latitude ) ) )
                    ) AS distance", [$lat1, $lng1, $lat1])
                        ->where('fcm_id', '!=', '')
                        ->where('driver_type', 'In house driver')
                        ->where('online', 'yes')
                        ->where('statut', 'yes');
                    if (is_array($busy_drivers) &&  sizeof($busy_drivers) > 0) {
                        $fcm_tokens =  $fcm_tokens->whereNotIn("id", $busy_drivers);
                    }


                    //  ->where('amount','>=',$minumum_wallet)


                    $fcm_tokens =   $fcm_tokens->having("distance", "<", $under_radious)

                        ->orderBy("distance", 'asc')
                        //->limit(10)
                        ->get();

                    
                    $ride = ['ride_id' => $id, 'status' => 'new'];
                    if ($fcm_tokens) {
                        foreach ($fcm_tokens as $fcm_token) {
                            $check = RequestToDriver::create(['driver_id' => $fcm_token->id, 'request_id' => $id]);

                            // GcmController::sendNotification($fcm_token->fcm_id, $message, $ride);

                        

                            if ($version) {
                                Log::info("Sending new type of notification", [
                                    'method' => 'sendNotsendNotification_newification',
                                    'fcm_id' => $fcm_token->fcm_id,
                                    'message' => $message,
                                    'ride_id' => $ride->id ?? null
                                ]);
                                GcmController::sendNotification_new($fcm_token->fcm_id, $message, $ride);
                            } else {
                                Log::info("Sending legacy notification", [
                                    'method' => 'sendNotification',
                                    'fcm_id' => $fcm_token->fcm_id,
                                    'message' => $message,
                                    'ride_id' => $ride->id ?? null
                                ]);
                                GcmController::sendNotification($fcm_token->fcm_id, $message, $ride);
                            }
                            

                        }
                    }

                    $fcm_tokens = DB::table('tj_conducteur')->selectRaw("id, fcm_id, latitude, longitude,
                    ( 6371 * acos( cos( radians(?) ) *
                    cos( radians( latitude ) )
                    * cos( radians( longitude ) - radians(?)
                    ) + sin( radians(?) ) *
                    sin( radians( latitude ) ) )
                    ) AS distance", [$lat1, $lng1, $lat1])
                        ->where('fcm_id', '!=', '')
                        ->where('driver_type', 'Outside driver')
                        ->where('amount', '>=', $minumum_wallet)
                        ->where('online', 'yes')
                        ->where('statut', 'yes');
                        
                    if (is_array($busy_drivers) && sizeof($busy_drivers) > 0) {
                        $fcm_tokens =  $fcm_tokens->whereNotIn("id", $busy_drivers);
                    }
                    $fcm_tokens =   $fcm_tokens->having("distance", "<", $under_radious)

                        ->orderBy("distance", 'asc')
                        //->limit(10)
                        ->get();

                        SendNotificationJob::dispatch($fcm_tokens, $message, $id, $ride)->delay(now()->addSeconds(30));
                }   
                
                // if ($rideStartHour->greaterThan($currentTime)) {
                          
                // } else {              
                //     $response['success'] = 'Failed';
                //     $response['error'] = 'Your time is wrong please enter future time';          
                //     return response()->json($response);
                // }

                
            } else {
                $date_heure = date('Y-m-d H:i:s');


                $driver_id = $request->id_conducteur;

                $insertdata = DB::insert("insert into tj_requete(vehicle_id,razorpay_transaction_id,time_stamp,remaining_payment,date_retour,statut_round,heure_retour,
                number_poeple,place,id_payment_method,trajet,depart_name,
                destination_name,id_user_app,latitude_depart,longitude_depart,latitude_arrivee,
                longitude_arrivee,statut,creer,distance,distance_unit,montant,duree,trip_objective,age_children1,
                age_children2,age_children3,feel_safe,tip_amount,statut_paiement,
                modifier,statut_course,id_conducteur_accepter,trip_category,feel_safe_driver,stops,ride_type,user_info,advance_payment,id_conducteur)
                values('" . $vehicle_id . "','" . $razorpay_transaction_id . "','" . $time_stamp . "','" . $remaining_payment . "','" . $date_retour . "','" . $statut_round . "','" . $heure_retour . "','" . $number_poeple . "','" . $place . "','" . $id_payment . "','" . $filename . "','" . $depart_name . "','" . $destination_name . "'
                ,'" . $user_id . "','" . $lat1 . "','" . $lng1 . "','" . $lat2 . "','" . $lng2 . "',
                'confirmed','" . $date_heure . "','" . $distance . "', '" . $distance_unit . "', '" . $cout . "','" . $duree . "',
                '" . $trip_objective . "','" . $age_children1 . "','" . $age_children2 . "',
                '" . $age_children3 . "',0,0,'','" . $date_heure . "','',0,'',0,'" . $stops . "','" . $ride_type . "','" . $user_detail . "','" . $advance_payment . "','" . $driver_id . "')");

                

             

                $id = DB::getPdo()->lastInsertId();
            }

            if ($id > 0) {
                $get_user = Requests::where('id', $id)->first();
                $row = $get_user->toArray();

                $row['stops'] = json_decode($row['stops'], true);
                $row['user_info'] = json_decode($row['user_info'], true);
                if ($row['trajet'] != '') {
                    if (file_exists(public_path('images/recu_trajet_course/' . '/' . $row['trajet']))) {
                        $image_user = asset('images/recu_trajet_course/') . '/' . $row['trajet'];
                    } else {
                        $image_user = asset('assets/images/placeholder_image.jpg');
                    }
                    $row['trajet'] = $image_user;
                }
                $row['remaining_payment'] = $row['montant'] - $row['advance_payment'];

                //AUTO CAPTURE PAYMENT

                $sql = Requests::where('id', $id)->first();

                if ($sql->advance_payment != 0 && ($sql->razorpay_transaction_id != NULL || $sql->razorpay_transaction_id != "")) {
                    $this->capture_payment($sql);
                }

                //END

                $output[] = $row;
                $response['success'] = 'success';
                $response['error'] = null;
                $response['message'] = 'Successfully created';
                $response['data'] = $output;
            } else {
                $response['success'] = 'Failed';
                $response['error'] = 'Failed';
            }
        } else {
            $response['success'] = 'Failed';
            $response['error'] = 'some field required';
        }


        return response()->json($response);
    }

    public function register_rental(Request $request)
    {

        $myfile = fopen("request.txt", 'a');
        fwrite($myfile, print_r($request->all(), true));
        fclose($myfile);

        $setting = DB::table('tj_settings')->where('id', 1)->first();
        $under_radious = $setting->driver_radios;

        $user_id = $request->get('user_id');
        $rental_package_id = $request->get('rental_package_id');
        $user_detail = json_encode($request->get('user_detail'));
        $lat1 = $request->get('latitude');
        $lng1 = $request->get('longitude');
        $lat2 = $request->get('lat2');
        $lng2 = $request->get('lng2');
        $cout = $request->get('cout');
        $duree = $request->get('duree');
        $distance = $request->get('distance');
        $distance_unit = $request->get('distance_unit');
        $age_children1 = $request->get('age_children1');
        $age_children2 = $request->get('age_children2');
        $age_children3 = $request->get('age_children3');
        $trip_objective = $request->get('trip_objective');
        $trip_category = $request->get('trip_category');

        // $id_conducteur = $request->get('id_conducteur');
        $id_payment = 15;//$request->get('id_payment');
        $depart_name = $request->get('depart_name');
        $destination_name = $request->get('destination_name');
        $image = $request->file('image');
        $place = $request->get('place');
        $place = str_replace("'", "\'", $place);
        $number_poeple = $request->get('number_poeple');
        $number_poeple = str_replace("'", "\'", $number_poeple);
        

        if($request->get('statut_round') == ""){
            $statut_round = 'no';
        }else{
            $statut_round = $request->get('statut_round');
        }
        $stops = json_encode($request->get('stops'));
        $ride_type = $request->get('ride_type');
        $advance_payment = $request->get('advance_payment');
        $razorpay_transaction_id = $request->get('id_payment');
        if (!empty($request->get('date_retour')))
            $date_retour = $request->get('date_retour');
        else
            $date_retour = date('Y-m-d');
        if (!empty($request->get('heure_retour')))
            $heure_retour = $request->get('heure_retour');
        else
            $heure_retour = date('H:i:s');
        $date_heure = date('Y-m-d H:i:s');

        if (!empty($image)) {
            $file = $request->file('image');
            $extenstion = $file->getClientOriginalExtension();
            $time = time() . '.' . $extenstion;
            $filename = 'requete_images_' . $time;
            $file->move(public_path('images/recu_trajet_course/'), $filename);
        } else {
            $filename = '';
        }

        $vehicle_id = $request->get('vehicle_id');
        $remaining_payment = $cout - $advance_payment;

        if (!empty($rental_package_id)) {

            $vehicle = DB::table('rental_packages')->where('package_id',$rental_package_id)
            ->where('vehicle_id',$vehicle_id)
            ->first();

            $cout = $vehicle->price ?? 0;
            $settings = DB::table('tj_settings')->first();
            $intial_payment_percentage = $settings->intial_payment_percentage;            

            if($intial_payment_percentage != 0)
            {
                $advance_payment = ($cout * $intial_payment_percentage ) / 100;
                $remaining_payment = $cout - $advance_payment;
            }else{
                $remaining_payment = $cout;
            }

            $id_payment = 15;

            
            
            $date_heure = date('Y-m-d H:i:s');

            $insertdata = DB::insert("insert into tj_requete(vehicle_id,
            razorpay_transaction_id,remaining_payment,date_retour,statut_round,heure_retour,
             number_poeple,place,id_payment_method,trajet,depart_name,
             destination_name,id_user_app,latitude_depart,longitude_depart,latitude_arrivee,
             longitude_arrivee,statut,creer,distance,distance_unit,montant,duree,trip_objective,age_children1,
             age_children2,age_children3,feel_safe,tip_amount,statut_paiement,
             modifier,statut_course,id_conducteur_accepter,trip_category,feel_safe_driver,stops,ride_type,user_info,rental_package_id,type,advance_payment)
             values('" . $vehicle_id . "','" . $razorpay_transaction_id . "','" . $remaining_payment . "','" . $date_retour . "','" . $statut_round . "','" . $heure_retour . "','" . $number_poeple . "','" . $place . "','" . $id_payment . "','" . $filename . "','" . $depart_name . "','" . $destination_name . "'
             ,'" . $user_id . "','" . $lat1 . "','" . $lng1 . "','" . $lat2 . "','" . $lng2 . "',
             'confirmed','" . $date_heure . "','" . $distance . "', '" . $distance_unit . "', '" . $cout . "','" . $duree . "',
             '" . $trip_objective . "','" . $age_children1 . "','" . $age_children2 . "',
             '" . $age_children3 . "',0,0,'','" . $date_heure . "','',0,'',0,'" . $stops . "','" . $ride_type . "','" . $user_detail . "','" . $rental_package_id . "','rental_ride','" . $advance_payment . "' )");


            $id = DB::getPdo()->lastInsertId();


            if ($id > 0) {
                $get_user = Requests::where('id', $id)->first();
                $row = $get_user->toArray();

                $row['stops'] = json_decode($row['stops'], true);
                $row['user_info'] = json_decode($row['user_info'], true);
                if ($row['trajet'] != '') {
                    if (file_exists(public_path('images/recu_trajet_course/' . '/' . $row['trajet']))) {
                        $image_user = asset('images/recu_trajet_course/') . '/' . $row['trajet'];
                    } else {
                        $image_user = asset('assets/images/placeholder_image.jpg');
                    }
                    $row['trajet'] = $image_user;
                }

                $row['remaining_payment'] = (float)$row['montant'] - $row['advance_payment'];

                //AUTO CAPTURE PAYMENT

                $sql = Requests::where('id', $id)->first();

                if ($sql->advance_payment != 0 && ($sql->razorpay_transaction_id != NULL || $sql->razorpay_transaction_id != "")) {
                    $this->capture_payment($sql);
                }


                //END



                $output[] = $row;
                $response['success'] = 'success';
                $response['error'] = null;
                $response['message'] = 'Successfully created';
                $response['data'] = $output;
            } else {
                $response['success'] = 'Failed';
                $response['error'] = 'Failed';
            }
        } else {
            $response['success'] = 'Failed';
            $response['error'] = 'some field required';
        }


        return response()->json($response);
    }

    public function capture_payment($request)
    {
        try {


            $sql_rezorpay = DB::table('payment_settings')
                ->crossJoin('tj_payment_method')
                ->select(
                    'payment_settings.id',
                    'payment_settings.key',
                    'payment_settings.secret_key',
                    'payment_settings.isEnabled',
                    'payment_settings.isSandboxEnabled',
                    'payment_settings.id_payment_method',
                    'tj_payment_method.libelle'
                )
                ->where('payment_settings.id_payment_method', '=', DB::raw('tj_payment_method.id'))
                ->where('tj_payment_method.libelle', '=', 'Razorpay')
                ->first();



            $key_id = $sql_rezorpay->key;
            $key_secret = $sql_rezorpay->secret_key;

            $pay_id = $request->razorpay_transaction_id;

            //CAPTURE PAYMENT

            $url = "https://api.razorpay.com/v1/payments/" . $pay_id . "/capture";

            $amount = ($request->advance_payment * 100);

            $data = [
                "amount" => $amount,
            ];

            Log::info('Capture API Request Payment ID: ' . $pay_id);
            Log::info('Capture API Request amount: ' . $amount);
            Log::info('Capture API Request url: ' . $url);


            $json_data = json_encode($data);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_USERPWD, $key_id . ":" . $key_secret);
            curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $json_data);

            $response = curl_exec($ch);

            if (curl_errno($ch)) {
                echo 'Curl error: ' . curl_error($ch);
            } else {
                $decoded_response = json_decode($response, true);

                $file = fopen("refund.txt", "a");
                fwrite($file, 'CAPTURE PAYMENT');
                fwrite($file, print_r($decoded_response, true));
                fclose($file);
            }
            curl_close($ch);

            Log::info('Capture API Response: ' . $response);

            return true;
        } catch (Exception $e) {

            Log::info('Capture API Response: ' . $e->getMessage() . ' || ON LINE NO. :' . $e->getLine() . ' || IN FILE: ' . $e->getFile());
            return false;
        }
    }
}
