<?php

namespace App\Http\Controllers\api\v1;

use App\Http\Controllers\Controller;
use App\Models\Note;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use DB;
use Carbon\Carbon;

class NoteController extends Controller
{

  public function __construct()
  {
    $this->limit = 20;
  }
  /** 
   * Display a listing of the resource.
   *
   * @return \Illuminate\Http\Response
   */

  public function register(Request $request)
  {

    $id_user_app = $request->get('id_user_app');
    $id_conducteur = $request->get('id_conducteur');
    $note_value = $request->get('note_value');
    $comment = $request->get('comment');
    $ride_id = $request->get('ride_id');
    $date_heure = date('Y-m-d H:i:s');
    $ride_type = $request->get('ride_type');
    if ($id_user_app && $id_conducteur && $note_value && $comment) {

      if (!empty($ride_type) && $ride_type == 'parcel') {
        $chknote = DB::table('tj_note')
          ->select('id')
          ->where('id_user_app', '=', $id_user_app)
          ->where('id_conducteur', '=', $id_conducteur)
          ->where('parcel_id', '=', $ride_id)
          ->get();
      } else {
        $chknote = DB::table('tj_note')
          ->select('id')
          ->where('id_user_app', '=', $id_user_app)
          ->where('id_conducteur', '=', $id_conducteur)
          ->where('ride_id', '=', $ride_id)
          ->get();
      }

      if ($chknote->count() > 0) {
        if (!empty($ride_type) && $ride_type == 'parcel') {

          $updatedata = DB::update('update tj_note set niveau = ?,parcel_id = ?,modifier = ?,comment = ? where id_conducteur = ? AND id_user_app = ?', [$note_value, $ride_id, $date_heure, $comment, $id_conducteur, $id_user_app]);
        } else {
          $updatedata = DB::update('update tj_note set niveau = ?,ride_id = ?,modifier = ?,comment = ? where id_conducteur = ? AND id_user_app = ?', [$note_value, $ride_id, $date_heure, $comment, $id_conducteur, $id_user_app]);
        }

        // Nb avis conducteur
        $sql_nb_avis = DB::table('tj_note')
          ->select(DB::raw("COUNT(id) as nb_avis"), DB::raw("SUM(niveau) as somme"))
          ->where('id_user_app', '=', $id_user_app)
          ->get();

        foreach ($sql_nb_avis as $row_nb_avis) {
          $somme = $row_nb_avis->somme;
          $nb_avis = $row_nb_avis->nb_avis;
        }
        $moyenne = $somme / $nb_avis;

        // Note conducteur
        $sql_note = DB::table('tj_note')
          ->select('niveau', 'comment')
          ->where('id_conducteur', '=', $id_conducteur)
          ->where('id_user_app', '=', $id_user_app)
          ->get();
        foreach ($sql_note as $row_note)

          $row['nb_avis'] = $row_nb_avis->nb_avis;
        if (!empty($sql_note)) {
          $row['niveau'] = $row_note->niveau;
          $row['comment'] = $row_note->comment;
        } else {
          $row['niveau'] = "";
          $row['comment'] = "";
        }
        $row['moyenne'] = $moyenne;
        $response['success'] = 'Success';
        $response['error'] = null;
        $response['message'] = 'Note Added Successfully';
        $response['data'] = $row;
      } else {
        if (!empty($ride_type) && $ride_type == 'parcel') {
          $insertdata = DB::insert("insert into tj_note(niveau,parcel_id,id_conducteur,id_user_app,statut,creer,modifier,comment)
              values('" . $note_value . "','" . $ride_id . "','" . $id_conducteur . "','" . $id_user_app . "','yes','" . $date_heure . "','" . $date_heure . "','" . $comment . "')");
        } else {
          $insertdata = DB::insert("insert into tj_note(niveau,ride_id,id_conducteur,id_user_app,statut,creer,modifier,comment)
                values('" . $note_value . "','" . $ride_id . "','" . $id_conducteur . "','" . $id_user_app . "','yes','" . $date_heure . "','" . $date_heure . "','" . $comment . "')");
        }

        $id = DB::getPdo()->lastInsertId();
        if ($insertdata > 0) {
          $row = [];

          // Nb avis conducteur
          $sql_nb_avis = DB::table('tj_note')
            ->select(DB::raw("COUNT(id) as nb_avis"), DB::raw("SUM(niveau) as somme"))
            ->where('id_user_app', '=', $id_user_app)
            ->get();
          foreach ($sql_nb_avis as $row_nb_avis) {
            $somme = $row_nb_avis->somme;
            $nb_avis = $row_nb_avis->nb_avis;
          }
          $moyenne = $somme / $nb_avis;
          // Note conducteur
          $sql_note = DB::table('tj_note')
            ->select('niveau', 'comment')
            ->where('id_conducteur', '=', $id_conducteur)
            ->where('id_user_app', '=', $id_user_app)
            ->get();
          foreach ($sql_note as $row_note)

            $row['nb_avis'] = $row_nb_avis->nb_avis;

          if (!empty($sql_note)) {
            $row['niveau'] = $row_note->niveau;
            $row['comment'] = $row_note->comment;
          } else {
            $row['niveau'] = "";
            $row['comment'] = "";
          }
          $row['moyenne'] = $moyenne;

          $response['success'] = 'Success';
          $response['error'] = null;
          $response['message'] = 'Note Added Successfully';
          $response['data'] = $row;
        } else {
          $response['success'] = 'Failed';
          $response['error'] = 'Failed to add note';
        }
      }
    } else {
      $response['success'] = 'Failed';
      $response['error'] = 'some field is missing';
    }


    return response()->json($response);
  }

  public function register_new(Request $request)
  {

    $id_user_app = $request->get('id_user_app');
    $id_conducteur = $request->get('id_conducteur');
    $note_value = $request->get('note_value');
    $comment = $request->get('comment');
    $ride_id = $request->get('ride_id');
    $date_heure = date('Y-m-d H:i:s');
    $ride_type = $request->get('ride_type');
    if ($id_user_app && $id_conducteur && $note_value && $comment) {

      if (!empty($ride_type) && $ride_type == 'parcel') {
        $chknote = DB::table('tj_note')
          ->select('id')
          ->where('id_user_app', '=', $id_user_app)
          ->where('id_conducteur', '=', $id_conducteur)
          ->where('parcel_id', '=', $ride_id)
          ->get();
      } else {
        $chknote = DB::table('tj_note')
          ->select('id')
          ->where('id_user_app', '=', $id_user_app)
          ->where('id_conducteur', '=', $id_conducteur)
          ->where('ride_id', '=', $ride_id)
          ->get();
      }

      if ($chknote->count() > 0) {

        if (!empty($ride_type) && $ride_type == 'parcel') {

          $updatedata = DB::update('update tj_note set niveau = ?,parcel_id = ?,modifier = ?,comment = ? where id_conducteur = ? AND id_user_app = ?', [$note_value, $ride_id, $date_heure, $comment, $id_conducteur, $id_user_app]);
        } else {
          $updatedata = DB::update('update tj_note set niveau = ?,ride_id = ?,modifier = ?,comment = ? where id_conducteur = ? AND id_user_app = ?', [$note_value, $ride_id, $date_heure, $comment, $id_conducteur, $id_user_app]);
        }

        // Nb avis conducteur
        $sql_nb_avis = DB::table('tj_note')
          ->select(DB::raw("COUNT(id) as nb_avis"), DB::raw("SUM(niveau) as somme"))
          ->where('id_user_app', '=', $id_user_app)
          ->get();

        foreach ($sql_nb_avis as $row_nb_avis) {
          $somme = $row_nb_avis->somme;
          $nb_avis = $row_nb_avis->nb_avis;
        }
        $moyenne = $somme / $nb_avis;

        // Note conducteur
        $sql_note = DB::table('tj_note')
          ->select('niveau', 'comment')
          ->where('id_conducteur', '=', $id_conducteur)
          ->where('id_user_app', '=', $id_user_app)
          ->get();
        foreach ($sql_note as $row_note)

          $row['nb_avis'] = $row_nb_avis->nb_avis;
        if (!empty($sql_note)) {
          $row['niveau'] = $row_note->niveau;
          $row['comment'] = $row_note->comment;
        } else {
          $row['niveau'] = "";
          $row['comment'] = "";
        }
        $row['moyenne'] = $moyenne;
        // $response['success'] = 'Success';
        // $response['error'] = null;
        // $response['message'] = 'Note Added Successfully';
        // $response['data'] = $row;

        $today = Carbon::now();

        $response['success'] = 'Success';
        $response['error'] = null;
        $response['message'] = 'Note Added Successfully';
        $response['data'] = $row;
        // $response['data'] = [          
        //   'assigned_coupons' => $assigned_coupons // new coupons
        // ];
      } else {
        if (!empty($ride_type) && $ride_type == 'parcel') {
          $insertdata = DB::insert("insert into tj_note(niveau,parcel_id,id_conducteur,id_user_app,statut,creer,modifier,comment)
              values('" . $note_value . "','" . $ride_id . "','" . $id_conducteur . "','" . $id_user_app . "','yes','" . $date_heure . "','" . $date_heure . "','" . $comment . "')");
        } else {
          $insertdata = DB::insert("insert into tj_note(niveau,ride_id,id_conducteur,id_user_app,statut,creer,modifier,comment)
                values('" . $note_value . "','" . $ride_id . "','" . $id_conducteur . "','" . $id_user_app . "','yes','" . $date_heure . "','" . $date_heure . "','" . $comment . "')");
        }

        $id = DB::getPdo()->lastInsertId();
        if ($insertdata > 0) {
          $row = [];

          // Nb avis conducteur
          $sql_nb_avis = DB::table('tj_note')
            ->select(DB::raw("COUNT(id) as nb_avis"), DB::raw("SUM(niveau) as somme"))
            ->where('id_user_app', '=', $id_user_app)
            ->get();
          foreach ($sql_nb_avis as $row_nb_avis) {
            $somme = $row_nb_avis->somme;
            $nb_avis = $row_nb_avis->nb_avis;
          }
          $moyenne = $somme / $nb_avis;
          // Note conducteur
          $sql_note = DB::table('tj_note')
            ->select('niveau', 'comment')
            ->where('id_conducteur', '=', $id_conducteur)
            ->where('id_user_app', '=', $id_user_app)
            ->get();
          foreach ($sql_note as $row_note)

            $row['nb_avis'] = $row_nb_avis->nb_avis;

          if (!empty($sql_note)) {
            $row['niveau'] = $row_note->niveau;
            $row['comment'] = $row_note->comment;
          } else {
            $row['niveau'] = "";
            $row['comment'] = "";
          }
          $row['moyenne'] = $moyenne;


          $assigned_coupons = [];

          $ride_amount = DB::table('tj_requete')
            ->where('id', $ride_id)
            ->value('montant');

          $today = Carbon::now()->format('Y-m-d');

          // Fetch eligible completed coupons
          // $eligible_coupons = DB::table('tj_discount')
          //   ->where('apply_for', 'completed')
          //   ->where('statut', 'yes')
          //   ->where('rating',  $note_value)            
          //   ->where('minimum_amount', '<=',  $ride_amount)            
          //   ->whereDate('expire_at', '>=', $today)
          //   ->get();

          $query = DB::table('tj_discount as d')
            ->join('coupon_slabs as s', 's.coupon_id', '=', 'd.id')
            ->where('d.apply_for', 'completed')
            ->where('d.statut', 'yes')
            ->where('d.rating', $note_value)
            ->where('s.min_ride_amount', '<=', $ride_amount)
            ->whereDate('d.expire_at', '>=', $today);

          if (!empty($rideType) && $rideType === 'parcel') {
            $query->where('d.coupon_type', 'Parcel');
          } else {
            $query->where('d.coupon_type', 'Ride');
          }

          $eligible_coupons = $query->select(
            'd.id',
            'd.expire_at',
            'd.title',
            'd.type',
            'd.discription',
            'd.code',
            'd.coupon_type',
            's.min_ride_amount',
            's.discount',
          )
            ->orderBy('s.min_ride_amount', 'desc')
            ->get();


          Log::error("FCM ID is missing for driver", ['driver_id' => $note_value,  'driver_idaaa' => $ride_amount]);

          //  dd($eligible_coupons); 

          // $response['completed_coupons'] = $completed_coupons;
          // return response()->json($response);

          // DB::table('assign_coupon_to_users')
          //   ->where('user_id', $id_user_app)
          //   ->delete();

          foreach ($eligible_coupons as $coupon) {
            // Check if already assigned
            $already_assigned = DB::table('assign_coupon_to_users')
              ->where('user_id', $id_user_app)
              ->where('coupon_id', $coupon->id)
              ->where('ride_id', $ride_id)
              ->exists();

            if (!$already_assigned) {
              $display_code = 'CPN-' . rand(100000, 999999);

              DB::table('assign_coupon_to_users')->insert([
                'user_id' => $id_user_app,
                'coupon_id' => $coupon->id,
                'display_code' => $display_code,
                'get_discount' => $coupon->discount,
                'discount_type' => $coupon->type,
                'expire_at' => $coupon->expire_at,
                'title' => $coupon->title,
                'discription' => $coupon->discription,
                'ride_id' => $ride_id,
                'created_at' => $date_heure,
                'updated_at' => $date_heure
              ]);

              $assigned_coupons[] = [
                'id' => $coupon->id,
                'code' => $coupon->code,
                'discount' => $coupon->discount,
                'type' => $coupon->type,
                'discription' => $coupon->discription,
                'coupon_type' => $coupon->coupon_type,
                'minimum_amount' => $coupon->min_ride_amount,
                'expire_at' => date('d F Y h:i A', strtotime($coupon->expire_at)),
              ];
            }
          }


          $response['success'] = 'Success';
          $response['error'] = null;
          $response['message'] = 'Note Added Successfully';
          $response['data'] = $row;
          $response['assigned_coupons'] = $assigned_coupons;
        } else {
          $response['success'] = 'Failed';
          $response['error'] = 'Failed to add note';
        }
      }
    } else {
      $response['success'] = 'Failed';
      $response['error'] = 'some field is missing';
    }


    return response()->json($response);
  }
}
