<?php

namespace App\Http\Controllers\api\v1;

use App\Http\Controllers\Controller;
use App\Models\Zone;
use App\Models\Driver;
use Illuminate\Http\Request;
use DB;

class Forceupdatecontroller extends Controller
{

    public function getData(Request $request)
    {
        // Validate the 'type' parameter
        $request->validate([
            'type' => 'required|in:customer,driver',
        ]);
        
        $settings = DB::table('tj_settings')->first();

        if (!$settings) {
            return response()->json([
                'status' => false,
                'message' => 'Settings not found.',
            ], 404);
        }
        
        $type = $request->type;

        // Build response
        $response = [
            'status' => true,
			'type' => $type,
			'android_version' => ($type == "customer" ? $settings->customer_version : ($type == "driver" ? $settings->driver_version : "")),    					
			'ios_version' => ""
        ];

        return response()->json($response);
    }
}