<?php
namespace App\Http\Controllers\api\v1;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\UserApp;
use DB;


class AddressDetailsController extends Controller
{

    public function register(Request $request){

        $request->validate([
            'longitude' => 'required',
            'latitude' => 'required',
            'address' => 'required',
            'address_type' => 'required|in:home,work',
        ]);

        $accessToken = $request->header('accesstoken');
        $user_app_id = DB::table('users_access')->where('accesstoken', $accessToken)->first()->user_id;

        DB::table('tj_user_location')->insert(['user_app_id' => $user_app_id, 'longitude' => $request->longitude, 'latitude' => $request->latitude, 'address' => $request->address, 'address_type' => $request->address_type]);

        return response()->json([
            'success' => 'success','message' => 'Data Saved Successfully!',
        ]);
        
    }


    public function getData(Request $request)
    {
        $accessToken = $request->header('accesstoken');
        $user_app_id = DB::table('users_access')->where('accesstoken', $accessToken)->first()->user_id;

        $data = DB::table('tj_user_location')
        ->select('*')
        ->where('user_app_id', $user_app_id)
        ->get();
        
        return response()->json([
            'success' => 'success',
            'message' => 'Data Retrived Successfully!',
            'data' => $data,
        ]);
    }

}
