<?php

namespace App\Console\Commands;

use App\Models\Requests;
use App\Models\DriverAssignSetting;
use App\Models\User;
use Illuminate\Console\Command;
use Carbon\Carbon;
use App\Http\Controllers\GcmController;

class NotifyAssignableBookings extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'bookings:notify-assignable';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Notify admin when a booking is ready to assign a driver (within 30 minutes)';

    /**
     * Execute the console command.
     */
    // public function handle()
    // {
    //     $now = Carbon::now();

    //     // Get dynamic window minutes from DB
    //     $minutes = DriverAssignSetting::first()->minutes ?? 30; // Fallback to 30 if not set
    //     $windowStart = $now->copy()->addMinutes($minutes);       // 1:30 PM (for a 2:00 PM booking)
    //     $windowEnd = $windowStart->copy()->addMinutes(1);        // Small window, e.g. 1:30 - 1:31

    //     // Get all pending bookings within the time window that haven't been notified
    //     $requests = Request::where('status', 'new')        
    //         ->where(function ($q) use ($windowStart, $windowEnd) {
    //             $q->where(function ($q) use ($windowStart, $windowEnd) {
    //                 $q->where('type', 'outstation_ride')
    //                     ->whereRaw('CONCAT(date_retour, " ", heure_retour) BETWEEN ? AND ?', [
    //                     $windowStart->toDateTimeString(), // $windowStart as datetime string
    //                     $windowEnd->toDateTimeString(),   
    //                 ]);
    //             })
    //             ->orWhere(function ($q) use ($windowStart, $windowEnd) {
    //                 $q->where('type', 'daily_ride')
    //                     ->whereRaw('CONCAT(date_retour, " ", heure_retour) BETWEEN ? AND ?', [
    //                     $windowStart->toDateTimeString(), // $windowStart as datetime string
    //                     $windowEnd->toDateTimeString(),   // $windowEnd as datetime string
    //                 ]);
    //             });
    //         })
    //         ->get();

    //     // If there are bookings in the window
    //     if ($requests->isNotEmpty()) {
    //         $admin = User::where('name', 'admin')->first(); 

    //         if (!$admin || empty($admin->fcm_token)) {
    //             $this->warn('No admin with FCM token found.');
    //             return;
    //         }

    //         // Notify admin for each booking
    //         foreach ($requests as $request) {          
    //             // Prepare the notification message
    //             $message = [
    //                 'title' => 'New Booking Needs Driver',
    //                 'body' => "Booking is scheduled",
    //                 'sound' => 'default'
    //             ];

    //             // Send notification via Firebase Cloud Messaging (FCM)
    //             GcmController::sendNotification($admin->fcm_token, $message);

    //             // Mark the booking as notified to prevent duplicate notifications
    //             // $booking->notified_at = now();
    //             // $booking->save();

    //             // Log the notification
    //             \Log::info("FCM sent for Booking ID");
    //         }

    //         // Inform that the admin was notified
    //         $this->info("Admin notified via FCM for " . $requests->count() . " bookings.");
    //     } else {
    //         // If no bookings were found
    //         $this->info("No assignable bookings found (within {$minutes} minutes).");
    //     }
    // }

}
