<?php

namespace App\Console\Commands;

use App\Models\ParcelOrder;
use Illuminate\Console\Command;
use DB;
use App\Models\RequestToDriver;
use Illuminate\Support\Facades\Log;

class AutoRejectRequest extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:auto-reject-request-command';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */

    public function handle()
    {
        Log::info('AutoRejectRequest Cron Started');

        $setting = DB::table('tj_settings')->where('id', 1)->first();

        if ($setting->trip_accept_reject_driver_time_sec != 0) {
            $minutes = $setting->trip_accept_reject_driver_time_sec / 60;
        } else {
            $minutes = 5;
        }

        Log::info('Timeout minutes set to: ' . $minutes);

        $today = date('Y-m-d');
        Log::info('today ' . $today);
        $requests = DB::table('tj_requete')
            ->whereIn('statut', ['new'])
            // ->whereDate('creer', $today)
            ->get();



        Log::info('Found ' . count($requests) . ' new requests for today');

        Log::info('requestsaaa ' . $requests);
        $ids = [];

        foreach ($requests as $req) {

            // Combine return date + time
            $datetime1 = new \DateTime($req->date_retour . ' ' . $req->heure_retour);
            $datetime2 = new \DateTime(); // current time


            Log::info([
                'datetime1' => $datetime1
            ]);

            Log::info([
                'datetime2' => $datetime2
            ]);

            // If return date-time is in the future → skip
            if ($datetime1 > $datetime2) {
                continue;
            }

            // Calculate difference in minutes
            $interval = $datetime1->diff($datetime2);
            $dminutes = ($interval->days * 24 * 60) + ($interval->h * 60) + $interval->i;

            Log::info([
                'interval time' => $dminutes
            ]);

            Log::info([
                'database time' => $minutes
            ]);

            // Auto reject if passed threshold
            if ($dminutes >= $minutes) {


                Log::info([
                    ' minutes' => $minutes,
                    'dminutes' => $dminutes
                ]);

                Log::info("Auto rejecting request ID {$req->id}", [
                    'passed_minutes' => $dminutes
                ]);

                DB::table('tj_requete')
                    ->where('id', $req->id)
                    ->update(['statut' => 'rejected']);

                RequestToDriver::where('request_id', $req->id)
                    ->update(['status' => 'rejected_by_cron']);

                $ids[] = $req->id;

                Log::info("Request ID {$req->id} auto-rejected successfully.");
            }
        }


        if (!empty($ids)) {
            Log::info('Total requests rejected by cron: ' . implode(', ', $ids));
        } else {
            Log::info('No requests needed to be rejected.');
        }

        Log::info('AutoRejectRequest Cron Completed');
    }

    // public function handle()
    // {
    //     $setting = DB::table('tj_settings')->where('id', 1)->first();

    //     if ($setting->trip_accept_reject_driver_time_sec != 0) {
    //         $minutes = $setting->trip_accept_reject_driver_time_sec / 60;
    //     } else {
    //         $minutes = 5;
    //     }

    //     $today = date('Y-m-d');
    //     $requests = DB::table('tj_requete')->whereIn('statut', ['new'])
    //         ->whereDate('creer', $today)->get();

    //     $ids = [];

    //     foreach ($requests as $req) {
    //         $datetime1 = new \DateTime($req->creer);
    //         $datetime2 = new \DateTime();
    //         $interval = $datetime1->diff($datetime2);
    //         $dminutes = $interval->format('%i');

    //         if ($dminutes >= $minutes) {
    //             DB::table('tj_requete')->where('id', $req->id)->update(['statut' => 'rejected']);

    //             RequestToDriver::where('request_id', $req->id)
    //                 ->update(['status' => 'rejected_by_cron']);

    //             $ids[] = $req->id;


    //         }
    //             /* $file = fopen('rejected.txt', 'a');
    //             fwrite($file, "REJECTED BY CRON".PHP_EOL);
    //             fwrite($file, print_r($ids, true));
    //             fclose($file); */
    //     }
    // }
    // public function handle()
    // {

    // }

}
